/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.tools.jst.web.server.RegistrationHelper;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.ResourceDeployer;
import org.jboss.tools.seam.internal.core.project.facet.Seam23ProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.Seam2FacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamProjectCreator;

public class Seam23FacetInstallDelegate
extends Seam2FacetInstallDelegate {
    private static String RICHFACES_SKIN = "org.richfaces.skin";
    public static AntCopyUtils.FileSet JBOOS_WAR_WEBINF_SET = new AntCopyUtils.FileSet().include("WEB-INF").include("WEB-INF/pages\\.xml").include("WEB-INF/componets\\.xml").include("WEB-INF/jboss-deployment-structure\\.xml");

    @Override
    protected void copyFilesToWarProject(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        super.copyFilesToWarProject(project, fv, model, monitor);
        if (!this.shouldCopyLibrariesAndTemplates(model)) {
            return;
        }
        if (Seam23FacetInstallDelegate.isWarConfiguration(model)) {
            File destFolder = new File(project.getLocation().toFile(), "resources");
            Seam23FacetInstallDelegate.copyDBDriverToProject(project, model, destFolder);
        }
    }

    @Override
    protected SeamProjectCreator getProjectCreator(IDataModel model, IProject project, SeamFacetAbstractInstallDelegate seamFacetInstallDelegate) {
        return new Seam23ProjectCreator(model, project, seamFacetInstallDelegate);
    }

    @Override
    protected AntCopyUtils.FileSet getJBossWarWebinfSet() {
        return JBOOS_WAR_WEBINF_SET;
    }

    @Override
    public AntCopyUtils.FileSet getEarLibFileSet() {
        return Seam23FacetInstallDelegate.getEarLibFileSet(this.facetModel);
    }

    @Override
    public AntCopyUtils.FileSet getWarLibFileSet() {
        return Seam23FacetInstallDelegate.getWarLibFileSet(this.facetModel);
    }

    @Override
    public AntCopyUtils.FileSet getWarLibFileSetForEar() {
        return Seam23FacetInstallDelegate.getWarLibFileSetForEar(this.facetModel);
    }

    public static AntCopyUtils.FileSet getEarLibFileSet(IDataModel model) {
        SeamRuntime runtime = Seam23FacetInstallDelegate.getSeamRuntime(model);
        return Seam23FacetInstallDelegate.getEarLibFileSet(runtime);
    }

    public static AntCopyUtils.FileSet getWarLibFileSet(IDataModel model) {
        SeamRuntime runtime = Seam23FacetInstallDelegate.getSeamRuntime(model);
        return Seam23FacetInstallDelegate.getWarLibFileSet(runtime);
    }

    public static AntCopyUtils.FileSet getWarLibFileSetForEar(IDataModel model) {
        SeamRuntime runtime = Seam23FacetInstallDelegate.getSeamRuntime(model);
        return Seam23FacetInstallDelegate.getWarLibFileSetForEar(runtime);
    }

    public static AntCopyUtils.FileSet getEarLibFileSet(SeamRuntime runtime) {
        String path = runtime.getDeployedJarsEarListFile();
        return Seam23FacetInstallDelegate.getFileSetOfJars(path);
    }

    public static AntCopyUtils.FileSet getWarLibFileSet(SeamRuntime runtime) {
        String path = runtime.getDeployedJarsWarListFile();
        return Seam23FacetInstallDelegate.getFileSetOfJars(path);
    }

    public static AntCopyUtils.FileSet getWarLibFileSetForEar(SeamRuntime runtime) {
        String path = runtime.getDeployedJarsEarWarListFile();
        return Seam23FacetInstallDelegate.getFileSetOfJars(path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AntCopyUtils.FileSet getFileSetOfJars(String path) {
        AntCopyUtils.FileSet fileSet = new AntCopyUtils.FileSet();
        File listFile = new File(path);
        if (listFile.exists()) {
            FileInputStream fis = null;
            try {
                Properties list = new Properties();
                fis = new FileInputStream(listFile);
                list.load(fis);
                Set<String> jarList = list.stringPropertyNames();
                for (String jar : jarList) {
                    fileSet.include(jar);
                }
            }
            catch (FileNotFoundException e) {
                SeamCorePlugin.getDefault().logError(e);
                if (fis == null) return fileSet;
                try {
                    fis.close();
                    return fileSet;
                }
                catch (IOException iOException) {}
                return fileSet;
            }
            catch (IOException e) {
                try {
                    SeamCorePlugin.getDefault().logError(e);
                    if (fis == null) return fileSet;
                }
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                    return fileSet;
                }
                catch (IOException iOException) {}
                return fileSet;
            }
            if (fis == null) return fileSet;
            try {
                fis.close();
                return fileSet;
            }
            catch (IOException iOException) {}
            return fileSet;
        }
        SeamCorePlugin.getDefault().logError(String.valueOf(path) + " doesn't exist. Can't get the list of the JARs to copy to the project.");
        return fileSet;
    }

    @Override
    protected String getSkinParamName() {
        return RICHFACES_SKIN;
    }

    private static SeamRuntime getSeamRuntime(IDataModel model) {
        Object runtimeName = model.getProperty("seam.runtime.name");
        SeamRuntime runtime = SeamRuntimeManager.getInstance().findRuntimeByName(runtimeName.toString());
        return runtime;
    }

    public static void copyDBDriverToProject(IProject project, IDataModel model, File destFolder) {
        File driver;
        String[] drvrsStrings;
        Object drvrs = model.getProperty("driver.files.array");
        if (drvrs != null && (drvrsStrings = (String[])drvrs).length > 0 && (driver = new File(drvrsStrings[0])).exists()) {
            IFile[] files;
            File dest = new File(destFolder, driver.getName());
            AntCopyUtils.copyFileToFile(driver, dest, null, false);
            IFile resource = null;
            IFile[] iFileArray = files = project.getWorkspace().getRoot().findFilesForLocationURI(dest.toURI());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (project.equals((Object)file.getProject())) {
                    resource = file;
                    break;
                }
                ++n2;
            }
            if (resource != null) {
                try {
                    resource.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    SeamCorePlugin.getDefault().logError(e);
                }
                try {
                    IFacetedProject fProj;
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
                    IRuntime runtime;
                    IServer server;
                    if (FacetedProjectFramework.isFacetedProject((IProject)project) && (server = Seam23FacetInstallDelegate.getServer(runtime = Seam23FacetInstallDelegate.getRuntime(facetRuntime = (fProj = ProjectFacetsManager.create((IProject)project)).getPrimaryRuntime()))) != null && Seam23FacetInstallDelegate.serverSupportsSingleFileModule(server)) {
                        ResourceDeployer dsJob = new ResourceDeployer(project, server, resource.getFullPath().removeFirstSegments(1));
                        dsJob.setNextJob((Job)RegistrationHelper.getRegisterInServerJob((IProject)project, (IServer[])new IServer[]{server}, null));
                        dsJob.schedule();
                    }
                }
                catch (CoreException e) {
                    SeamCorePlugin.getDefault().logError(e);
                }
            }
        }
    }

    private static IServer getServer(IRuntime runtime) {
        IServer[] servers;
        if (runtime == null) {
            return null;
        }
        IRuntimeType runtimeType = runtime.getRuntimeType();
        if (runtimeType == null || runtimeType.getId() == null) {
            return null;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeType serverRuntimeType;
            IServer server = iServerArray[n2];
            IServerType serverType = server.getServerType();
            if (serverType != null && (serverRuntimeType = serverType.getRuntimeType()) != null && runtimeType.getId().equals(serverRuntimeType.getId())) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    private static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime[] runtimes;
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            if (id.equals(r.getId())) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    private static boolean serverSupportsSingleFileModule(IServer s) {
        IRuntimeType rt = s.getServerType().getRuntimeType();
        return ServerUtil.isSupportedModule((IModuleType[])rt.getModuleTypes(), (String)"jboss.singlefile", (String)"1.0");
    }
}

