/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.ca.MessagesELTextProposal;
import org.jboss.tools.common.el.core.model.ELArgumentInvocation;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.util.StringUtil;
import org.jboss.tools.jst.web.kb.el.MessagePropertyELSegmentImpl;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamExpressionResolver;

public final class SeamELCompletionEngine
extends AbstractELCompletionEngine<ISeamContextVariable> {
    private static final ImageDescriptor SEAM_EL_PROPOSAL_IMAGE = SeamCorePlugin.getDefault().getImageDescriptorFromRegistry("images/ca/icons_Seam_EL.gif");
    private static final ImageDescriptor SEAM_MESSAGES_PROPOSAL_IMAGE = SeamCorePlugin.getDefault().getImageDescriptorFromRegistry("images/ca/icons_Message_Bundles.gif");
    private static ELParserFactory factory = ELParserUtil.getJbossFactory();
    List<IJavaElement> EMPTY_JAVA_ELEMENTS = Collections.unmodifiableList(new ArrayList());

    public ImageDescriptor getELProposalImageForMember(TypeInfoCollector.MemberInfo memberInfo) {
        return SEAM_EL_PROPOSAL_IMAGE;
    }

    public ELParserFactory getParserFactory() {
        return factory;
    }

    protected void log(Exception e) {
        SeamCorePlugin.getPluginLog().logError((Throwable)e);
    }

    /*
     * Unable to fully structure code
     */
    public List<ISeamContextVariable> resolveSeamVariableFromEL(ISeamProject project, IFile file, String el) throws BadLocationException, StringIndexOutOfBoundsException {
        block6: {
            resolvedVariables = this.EMPTY_VARIABLES_LIST;
            if (!el.startsWith("#{")) {
                el = "#{" + el + "}";
            }
            if ((is = (model = (parser = SeamELCompletionEngine.factory.createParser()).parse(el)).getInstances()).size() < 1) {
                return resolvedVariables;
            }
            ex = ((ELInstance)is.get(0)).getExpression();
            if (!(ex instanceof ELInvocationExpression)) {
                return resolvedVariables;
            }
            expr = (ELInvocationExpression)ex;
            isIncomplete = expr.getType() == ELObjectType.EL_PROPERTY_INVOCATION && ((ELPropertyInvocation)expr).getName() == null;
            left = expr;
            if (expr.getLeft() != null || !isIncomplete) ** GOTO lbl20
            resolvedVariables = this.resolveVariables(project, file, expr, true, true);
            break block6;
lbl-1000:
            // 1 sources

            {
                resolvedVars = this.resolveVariables(project, file, left, left == expr, true);
                if (resolvedVars != null && !resolvedVars.isEmpty()) {
                    resolvedVariables = resolvedVars;
                    break;
                }
                left = left.getLeft();
lbl20:
                // 2 sources

                ** while (left != null)
            }
        }
        if (left != expr && !resolvedVariables.isEmpty()) {
            resolvedVariables.clear();
        }
        return resolvedVariables;
    }

    public List<ISeamContextVariable> resolveVariables(IFile file, ELContext context, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        ISeamProject project = SeamCorePlugin.getSeamProject(file.getProject(), true);
        return this.resolveVariables(project, file, expr, isFinal, onlyEqualNames);
    }

    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(ISeamContextVariable var, ELContext context, boolean onlyEqualNames, int offset) {
        return SeamExpressionResolver.getMemberInfoByVariable(var, true, this, offset);
    }

    protected void setImage(TextProposal proposal, ISeamContextVariable var) {
        if (SeamELCompletionEngine.isSeamMessagesComponentVariable(var)) {
            proposal.setImageDescriptor(SEAM_MESSAGES_PROPOSAL_IMAGE);
        } else {
            proposal.setImageDescriptor(this.getELProposalImageForMember(null));
        }
    }

    protected boolean isSingularAttribute(ISeamContextVariable var) {
        return var instanceof IBijectedAttribute;
    }

    protected void setImage(TextProposal kbProposal, TypeInfoCollector.MemberPresentation proposal) {
        if (proposal.getMember() instanceof SeamExpressionResolver.MessagesInfo) {
            kbProposal.setImageDescriptor(SEAM_MESSAGES_PROPOSAL_IMAGE);
        } else {
            super.setImage(kbProposal, proposal);
        }
    }

    protected boolean isSingularMember(TypeInfoCollector.MemberInfo mbr) {
        return mbr instanceof SeamExpressionResolver.MessagesInfo;
    }

    protected void resolveLastSegment(ELInvocationExpression expr, List<TypeInfoCollector.MemberInfo> members, ELResolutionImpl resolution, boolean returnEqualedVariablesOnly, boolean varIsUsed) {
        if (this.resolveLastSegmentInMessages(expr, members, resolution, returnEqualedVariablesOnly, varIsUsed)) {
            return;
        }
        super.resolveLastSegment(expr, members, resolution, returnEqualedVariablesOnly, varIsUsed);
    }

    private boolean resolveLastSegmentInMessages(ELInvocationExpression expr, List<TypeInfoCollector.MemberInfo> members, ELResolutionImpl resolution, boolean returnEqualedVariablesOnly, boolean varIsUsed) {
        String filter;
        if (members.isEmpty() || !(members.get(0) instanceof SeamExpressionResolver.MessagesInfo)) {
            return false;
        }
        SeamExpressionResolver.MessagesInfo messagesInfo = (SeamExpressionResolver.MessagesInfo)members.get(0);
        MessagePropertyELSegmentImpl segment = null;
        if (expr instanceof ELPropertyInvocation) {
            segment = new MessagePropertyELSegmentImpl(((ELPropertyInvocation)expr).getName());
        } else if (expr instanceof ELArgumentInvocation) {
            segment = new MessagePropertyELSegmentImpl(((ELArgumentInvocation)expr).getArgument().getOpenArgumentToken().getNextToken());
        }
        TreeSet<TextProposal> kbProposals = new TreeSet<TextProposal>(TextProposal.KB_PROPOSAL_ORDER);
        if (segment.getToken() != null) {
            String propertyName = segment.getToken().getText();
            Map<String, List<XModelObject>> properties = messagesInfo.getPropertiesMap();
            List<XModelObject> os = properties.get(StringUtil.trimQuotes((String)propertyName));
            if (os != null) {
                for (XModelObject o : os) {
                    segment.addObject(o);
                }
            }
        }
        if (segment.getToken() != null) {
            resolution.addSegment((ELSegment)segment);
        }
        resolution.setProposals(kbProposals);
        if (expr.getType() == ELObjectType.EL_PROPERTY_INVOCATION && ((ELPropertyInvocation)expr).getName() == null) {
            for (TypeInfoCollector.MemberInfo mbr : members) {
                this.processSingularMember(mbr, kbProposals);
            }
        } else if (expr.getType() != ELObjectType.EL_ARGUMENT_INVOCATION) {
            filter = expr.getMemberName() == null ? "" : expr.getMemberName();
            block2: for (TypeInfoCollector.MemberInfo mbr : members) {
                Collection<String> keys = ((SeamExpressionResolver.MessagesInfo)mbr).getKeys();
                for (String key : keys) {
                    MessagesELTextProposal kbProposal;
                    if (returnEqualedVariablesOnly) {
                        if (!key.equals(filter)) continue;
                        kbProposal = this.createProposal(messagesInfo, key);
                        kbProposals.add((TextProposal)kbProposal);
                        continue block2;
                    }
                    if (!key.startsWith(filter)) continue;
                    kbProposal = this.createProposal(messagesInfo, key);
                    if (key.indexOf(46) == -1) {
                        kbProposal.setReplacementString(key.substring(filter.length()));
                    } else {
                        kbProposal.setReplacementString(String.valueOf('[') + kbProposal.getReplacementString());
                    }
                    kbProposals.add((TextProposal)kbProposal);
                }
            }
        } else if (expr.getType() == ELObjectType.EL_ARGUMENT_INVOCATION) {
            filter = expr.getMemberName() == null ? "" : expr.getMemberName();
            boolean b = filter.startsWith("'") || filter.startsWith("\"");
            boolean e = filter.length() > 1 && filter.endsWith("'") || filter.endsWith("\"");
            filter = StringUtil.trimQuotes((String)filter);
            block4: for (TypeInfoCollector.MemberInfo mbr : members) {
                if (!b && filter.length() > 0 || b && e && filter.length() == 0) {
                    resolution.setMapOrCollectionOrBundleAmoungTheTokens(true);
                    return true;
                }
                Collection<String> keys = ((SeamExpressionResolver.MessagesInfo)mbr).getKeys();
                for (String key : keys) {
                    MessagesELTextProposal kbProposal;
                    if (returnEqualedVariablesOnly) {
                        if (!key.equals(filter)) continue;
                        kbProposal = this.createProposal(messagesInfo, key);
                        kbProposals.add((TextProposal)kbProposal);
                        continue block4;
                    }
                    if (!key.startsWith(filter)) continue;
                    kbProposal = this.createProposal(messagesInfo, key);
                    String existingString = expr.getMemberName() == null ? "" : expr.getMemberName();
                    String replacement = kbProposal.getReplacementString();
                    String label = kbProposal.getLabel();
                    if (!replacement.startsWith("'")) {
                        replacement = String.valueOf('\'') + key + '\'';
                        label = "['" + key + "']";
                    }
                    replacement = replacement.startsWith(existingString) ? replacement.substring(existingString.length()) : replacement;
                    kbProposal.setReplacementString(replacement);
                    kbProposal.setLabel(label);
                    kbProposals.add((TextProposal)kbProposal);
                }
            }
        }
        segment.setResolved(!kbProposals.isEmpty());
        if (resolution.isResolved()) {
            resolution.setLastResolvedToken(expr);
        }
        return true;
    }

    protected void processSingularMember(TypeInfoCollector.MemberInfo mbr, Set<TextProposal> kbProposals) {
        if (mbr instanceof SeamExpressionResolver.MessagesInfo) {
            Map<String, List<XModelObject>> properties = ((SeamExpressionResolver.MessagesInfo)mbr).getPropertiesMap();
            TreeSet<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            keys.addAll(properties.keySet());
            for (String key : keys) {
                if (key == null || key.length() == 0) continue;
                MessagesELTextProposal proposal = this.createProposal((SeamExpressionResolver.MessagesInfo)mbr, key);
                if (key.indexOf(46) != -1) {
                    proposal.setReplacementString("['" + key + "']");
                    proposal.setLabel("['" + key + "']");
                } else {
                    proposal.setReplacementString(key);
                    proposal.setLabel(key);
                }
                kbProposals.add((TextProposal)proposal);
            }
        }
    }

    private MessagesELTextProposal createProposal(SeamExpressionResolver.MessagesInfo mbr, String proposal) {
        MessagesELTextProposal kbProposal = new MessagesELTextProposal();
        if (proposal.indexOf(46) != -1) {
            kbProposal.setReplacementString(String.valueOf('\'') + proposal + '\'');
            kbProposal.setLabel("['" + proposal + "']");
        } else {
            kbProposal.setReplacementString(proposal);
            kbProposal.setLabel(proposal);
        }
        kbProposal.setAlternateMatch(proposal);
        kbProposal.setImageDescriptor(SEAM_MESSAGES_PROPOSAL_IMAGE);
        Map<String, List<XModelObject>> properties = mbr.getPropertiesMap();
        List<XModelObject> ps = properties.get(proposal);
        kbProposal.setPropertyName(proposal);
        kbProposal.setObjects(ps);
        return kbProposal;
    }

    private String getBundle(XModelObject o) {
        StringBuilder sb = new StringBuilder();
        XModelObject f = FileSystemsHelper.getFile((XModelObject)o);
        if (f != null) {
            sb.append(f.getAttributeValue("name"));
            f = f.getParent();
            while (f != null && f.getFileType() == 2) {
                sb.insert(0, ".").insert(0, f.getAttributeValue("name"));
                f = f.getParent();
            }
        }
        return sb.toString();
    }

    protected void filterSingularMember(TypeInfoCollector.MemberInfo mbr, Set<TypeInfoCollector.MemberPresentation> proposalsToFilter) {
        Collection<String> keys = ((SeamExpressionResolver.MessagesInfo)mbr).getKeys();
        for (String key : keys) {
            proposalsToFilter.add(new TypeInfoCollector.MemberPresentation(key, key, mbr));
        }
    }

    public static ScopeType getScope(ISeamProject project, IResource resource) {
        if (project == null || resource == null) {
            return null;
        }
        if (!"java".equalsIgnoreCase(resource.getFileExtension())) {
            return null;
        }
        Set<ISeamComponent> components = project.getComponentsByPath(resource.getFullPath());
        if (components.size() > 1) {
            return null;
        }
        Iterator<ISeamComponent> iterator = components.iterator();
        if (iterator.hasNext()) {
            ISeamComponent component = iterator.next();
            return component.getScope();
        }
        return null;
    }

    public List<ISeamContextVariable> resolveVariables(ISeamProject project, IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        List<ISeamContextVariable> resolvedVars = this.EMPTY_VARIABLES_LIST;
        if (project == null) {
            return this.EMPTY_VARIABLES_LIST;
        }
        String varName = expr.toString();
        if (varName != null) {
            resolvedVars = SeamExpressionResolver.resolveVariables(project, file, varName, onlyEqualNames);
        }
        if (resolvedVars != null && !resolvedVars.isEmpty()) {
            if (isFinal) {
                return resolvedVars;
            }
            ArrayList<ISeamContextVariable> newResolvedVars = new ArrayList<ISeamContextVariable>();
            for (ISeamContextVariable var : resolvedVars) {
                if (!varName.equals(var.getName())) continue;
                newResolvedVars.add(var);
            }
            return newResolvedVars;
        }
        return this.EMPTY_VARIABLES_LIST;
    }

    public String getJavaElementExpression(IDocument document, int offset, IRegion region, int start, int end) throws StringIndexOutOfBoundsException {
        if (document == null || document.get() == null || offset > document.get().length()) {
            return null;
        }
        ELInvocationExpression expr = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)(region.getOffset() + region.getLength()), (int)start, (int)end);
        if (expr == null) {
            return null;
        }
        ELInvocationExpression left = expr;
        while (left != null && left.getLeft() != null) {
            left = left.getLeft();
        }
        String prefixPart = document.get().substring(expr.getStartPosition(), offset);
        while (left != null) {
            String varText = left.getText();
            if (varText != null && varText.startsWith(prefixPart)) {
                return varText;
            }
            if (left == expr) break;
            left = (ELInvocationExpression)left.getParent();
        }
        return null;
    }

    public List<IJavaElement> getJavaElementsForExpression(ISeamProject project, IFile file, String expression, int offset) throws BadLocationException, StringIndexOutOfBoundsException {
        ELExpression expr = this.parseOperand(expression);
        if (!(expr instanceof ELInvocationExpression)) {
            return this.EMPTY_JAVA_ELEMENTS;
        }
        return this.getJavaElementsForELOperandTokens(project, file, (ELInvocationExpression)expr);
    }

    public List<IJavaElement> getJavaElementsForELOperandTokens(ISeamProject project, IFile file, ELInvocationExpression expr) throws BadLocationException, StringIndexOutOfBoundsException {
        IJavaElement el;
        ELSegment segment;
        List<IJavaElement> res = this.EMPTY_JAVA_ELEMENTS;
        ElVarSearcher varSearcher = new ElVarSearcher(file, (ELCompletionEngine)this);
        List vars = varSearcher.findAllVars(file, expr.getStartPosition());
        ELResolutionImpl resolution = this.resolveELOperand(file, null, (ELExpression)expr, true, vars, varSearcher, 0);
        if (resolution != null && resolution.isResolved() && (segment = resolution.getLastSegment()) instanceof JavaMemberELSegment && (el = ((JavaMemberELSegment)segment).getJavaElement()) != null) {
            if (res == this.EMPTY_JAVA_ELEMENTS) {
                res = new ArrayList<IJavaElement>();
            }
            res.add(el);
            return res;
        }
        return res;
    }

    public static ISeamMessages getSeamMessagesComponentVariable(ISeamContextVariable variable) {
        if (variable instanceof ISeamMessages) {
            return (ISeamMessages)variable;
        }
        if (variable instanceof ISeamXmlFactory) {
            ISeamProject p;
            ISeamXmlFactory factory = (ISeamXmlFactory)variable;
            String value = factory.getValue();
            if (value != null && value.length() > 0) {
                if (value.startsWith("#{") || value.startsWith("${")) {
                    value = value.substring(2);
                }
                if (value.endsWith("}")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if (value != null && value.length() > 0 && (p = factory.getSeamProject()) != null) {
                List<ISeamContextVariable> resolvedValues = SeamExpressionResolver.resolveVariables(p, null, value, true);
                for (ISeamContextVariable var : resolvedValues) {
                    if (!var.getName().equals(value) || !(var instanceof ISeamMessages)) continue;
                    return (ISeamMessages)var;
                }
            }
        } else if (variable instanceof ISeamContextShortVariable) {
            ISeamContextShortVariable sv = (ISeamContextShortVariable)variable;
            return SeamELCompletionEngine.getSeamMessagesComponentVariable(sv.getOriginal());
        }
        return null;
    }

    public static boolean isSeamMessagesComponentVariable(ISeamContextVariable variable) {
        return SeamELCompletionEngine.getSeamMessagesComponentVariable(variable) != null;
    }

    protected boolean isStaticMethodsCollectingEnabled() {
        return true;
    }
}

