/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.event.ISeamValueMap;
import org.jboss.tools.seam.core.event.ISeamValueMapEntry;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamValueMapEntry;
import org.w3c.dom.Element;

public class SeamValueMap
extends SeamObject
implements ISeamValueMap {
    List<ISeamValueMapEntry> entries = new ArrayList<ISeamValueMapEntry>();

    @Override
    public List<ISeamValueMapEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(ISeamValueMapEntry entry) {
        this.entries.add(entry);
        this.adopt(entry);
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamValueMap v = (SeamValueMap)s;
        if (this.entries.size() != v.entries.size()) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "value", this.entries, v.entries));
        }
        this.entries = v.entries;
        int i = 0;
        while (i < this.entries.size()) {
            this.adopt((SeamObject)((Object)this.entries.get(i)));
            ++i;
        }
        return changes;
    }

    @Override
    public SeamValueMap clone() throws CloneNotSupportedException {
        SeamValueMap c = (SeamValueMap)super.clone();
        c.entries = new ArrayList<ISeamValueMapEntry>();
        for (ISeamValueMapEntry v : this.entries) {
            c.addEntry(v.clone());
        }
        return c;
    }

    @Override
    public String getXMLName() {
        return "value";
    }

    @Override
    public String getXMLClass() {
        return "map";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        for (ISeamValueMapEntry entry : this.entries) {
            SeamObject o = (SeamObject)((Object)entry);
            o.toXML(element, context);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        Element[] cs = XMLUtilities.getChildren((Element)element, (String)SeamValueMapEntry.TAG_ENTRY);
        int i = 0;
        while (i < cs.length) {
            SeamValueMapEntry entry = new SeamValueMapEntry();
            entry.loadXML(cs[i], context);
            this.addEntry(entry);
            ++i;
        }
    }
}

