/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.core.ISeamScope;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.internal.core.SeamComponent;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamPackage;
import org.jboss.tools.seam.internal.core.SeamPackageUtil;
import org.jboss.tools.seam.internal.core.SeamProject;

public class SeamScope
extends SeamObject
implements ISeamScope {
    private Map<String, SeamComponent> componentMap = new HashMap<String, SeamComponent>();
    private List<ISeamComponent> components = new ArrayList<ISeamComponent>();
    private ScopeType scopeType = null;
    Map<String, ISeamPackage> packages = new HashMap<String, ISeamPackage>();

    SeamScope(SeamProject project, ScopeType scopeType) {
        this.setParent(project);
        this.scopeType = scopeType;
    }

    @Override
    public List<ISeamComponent> getComponents() {
        return this.components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ISeamPackage> getPackages() {
        Map<String, ISeamPackage> map = this.packages;
        synchronized (map) {
            return this.packages.values();
        }
    }

    @Override
    public Collection<ISeamPackage> getAllPackages() {
        ArrayList<ISeamPackage> list = new ArrayList<ISeamPackage>();
        SeamPackageUtil.collectAllPackages(this.packages, list);
        return list;
    }

    @Override
    public ISeamPackage getPackage(ISeamComponent c) {
        String pkg = SeamPackageUtil.getPackageName(c);
        return SeamPackageUtil.findPackage(this, this.packages, pkg);
    }

    public void addComponent(SeamComponent component) {
        this.components.add(component);
        this.componentMap.put(component.getName(), component);
    }

    public void removeComponent(ISeamComponent component) {
        this.components.remove(component);
        this.componentMap.remove(component.getName());
    }

    @Override
    public ScopeType getType() {
        return this.scopeType;
    }

    void revalidatePackages() {
        List<Change> changes = SeamPackageUtil.revalidatePackages(this, this.componentMap, this.getComponents(), this.packages);
        ((SeamProject)this.getSeamProject()).fireChanges(changes, false);
    }

    public void validatePackage(SeamComponent c) {
        SeamPackage p = (SeamPackage)SeamPackageUtil.findOrCreatePackage(this, this.packages, SeamPackageUtil.getPackageName(c));
        c.setScopePackage(p);
        p.getComponents().add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(ISeamPackage p) {
        Map<String, ISeamPackage> map = this.packages;
        synchronized (map) {
            this.packages.remove(p.getName());
        }
    }
}

