/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamValue;
import org.jboss.tools.seam.core.event.ISeamValueList;
import org.jboss.tools.seam.core.event.ISeamValueString;

public class SeamMessagesLoader {
    static List<MessageBundle> EMPTY = new ArrayList<MessageBundle>();
    List<MessageBundle> resources = EMPTY;
    Map<String, Long> timestamps = null;
    Set<String> keys = null;
    Map<String, List<XModelObject>> properties = null;
    ISeamElement object;
    String resourceComponent;

    public SeamMessagesLoader(ISeamElement object, String resourceComponent) {
        this.object = object;
        this.resourceComponent = resourceComponent;
    }

    public void revalidate() {
        List<MessageBundle> resources2 = this.getResources();
        if (this.changed(resources2)) {
            this.timestamps = new HashMap<String, Long>();
            int i = 0;
            while (i < resources2.size()) {
                List<XModelObject> r = resources2.get((int)i).files;
                long q = 0L;
                for (XModelObject o : r) {
                    q += o.getTimeStamp();
                }
                this.timestamps.put(resources2.get((int)i).bundle, q);
                ++i;
            }
            this.resources = resources2;
            this.keys = null;
            this.properties = null;
        }
    }

    private boolean changed(List<MessageBundle> resources2) {
        if (this.resources == resources2) {
            return false;
        }
        if (resources2.size() != this.resources.size()) {
            return true;
        }
        if (this.timestamps == null) {
            return true;
        }
        int i = 0;
        while (i < resources2.size()) {
            List<XModelObject> r2 = resources2.get((int)i).files;
            List<XModelObject> r1 = this.resources.get((int)i).files;
            if (r1 == null || r2.size() == r1.size()) {
                return true;
            }
            long l1 = 0L;
            for (XModelObject o : r1) {
                l1 += o.getTimeStamp();
            }
            Long l2 = this.timestamps.get(resources2.get((int)i).bundle);
            if (l2 == null || l1 != l2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<MessageBundle> getResources() {
        ISeamProject p = this.object.getSeamProject();
        if (p == null) {
            return EMPTY;
        }
        IResource[] srcs = EclipseResourceUtil.getJavaSourceRoots((IProject)p.getProject());
        List<String> names = this.getNames();
        return names.isEmpty() ? EMPTY : this.getResources(names, srcs);
    }

    private List<String> getNames() {
        ISeamProject p = this.object.getSeamProject();
        if (p == null) {
            return new ArrayList<String>();
        }
        ISeamComponent c = p.getComponent(this.resourceComponent);
        if (c == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> names = new ArrayList<String>();
        Set<ISeamXmlComponentDeclaration> ds = c.getXmlDeclarations();
        for (ISeamXmlComponentDeclaration d : ds) {
            String b;
            ISeamValueString s;
            ISeamValue v;
            ISeamProperty property = d.getProperty("bundleNames");
            if (property == null || (v = property.getValue()) == null) continue;
            if (v instanceof ISeamValueList) {
                List<ISeamValueString> vs = ((ISeamValueList)v).getValues();
                for (ISeamValueString s2 : vs) {
                    if (s2.getValue() == null) continue;
                    String b2 = s2.getValue().getValue();
                    names.add(b2);
                }
                continue;
            }
            if (!(v instanceof ISeamValueString) || (s = (ISeamValueString)v).getValue() == null || (b = s.getValue().getValue()) == null || b.length() == 0) continue;
            String[] bi = b.split(",");
            int i = 0;
            while (i < bi.length) {
                names.add(bi[i].trim());
                ++i;
            }
        }
        if (ds.isEmpty()) {
            names.add("messages");
        }
        return names;
    }

    public Collection<ISeamProperty> getProperties() {
        throw new IllegalStateException("Not implemented");
    }

    public Map<String, List<XModelObject>> getPropertiesMap() {
        if (this.properties == null) {
            this.properties = new HashMap<String, List<XModelObject>>();
            int i = 0;
            while (i < this.resources.size()) {
                List<XModelObject> list = this.resources.get((int)i).files;
                for (XModelObject o : list) {
                    XModelObject[] ps;
                    XModelObject[] xModelObjectArray = ps = o.getChildren();
                    int n = ps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XModelObject p = xModelObjectArray[n2];
                        String propertyName = p.getAttributeValue("name");
                        List<XModelObject> vs = this.properties.get(propertyName);
                        if (vs == null) {
                            vs = new ArrayList<XModelObject>();
                            this.properties.put(propertyName, vs);
                        }
                        vs.add(p);
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return this.properties;
    }

    private List<MessageBundle> getResources(List<String> names, IResource[] srcs) {
        ArrayList<MessageBundle> rs = new ArrayList<MessageBundle>();
        for (String name : names) {
            String p;
            String n = name.replace('.', '/');
            int k = n.lastIndexOf(47);
            String string = p = k < 0 ? null : n.substring(0, k);
            if (k >= 0) {
                n = n.substring(k + 1);
            }
            IResource result = null;
            int j = 0;
            while (j < srcs.length && result == null) {
                result = this.find(p, n, srcs[j]);
                ++j;
            }
            if (result == null) continue;
            ArrayList<XModelObject> l = new ArrayList<XModelObject>();
            XModelObject o = EclipseResourceUtil.createObjectForResource(result);
            if (o == null) continue;
            XModelObject[] os = o.getParent().getChildren();
            String dn = o.getAttributeValue("name");
            XModelObject[] xModelObjectArray = os;
            int n2 = os.length;
            int n3 = 0;
            while (n3 < n2) {
                XModelObject c = xModelObjectArray[n3];
                String fileName = FileAnyImpl.toFileName((XProperty)c);
                if (fileName.endsWith(".properties") && (c == o || fileName.startsWith(String.valueOf(dn) + "_"))) {
                    l.add(c);
                }
                ++n3;
            }
            rs.add(new MessageBundle(name, l));
        }
        return rs;
    }

    private IResource find(String pack, String name, IResource src) {
        if (!(src instanceof IContainer)) {
            return null;
        }
        IContainer c = (IContainer)src;
        if (pack != null) {
            c = c.getFolder((IPath)new Path(pack));
        }
        if (c == null || !c.exists()) {
            return null;
        }
        String suffix = ".properties";
        String name_ = String.valueOf(name) + "_";
        String name_p = String.valueOf(name) + suffix;
        IResource result = null;
        try {
            IResource[] rs = c.members();
            int i = 0;
            while (i < rs.length) {
                String n = rs[i].getName();
                if (name_p.equals(n)) {
                    return rs[i];
                }
                if (result == null && n.startsWith(name_) && n.endsWith(suffix)) {
                    result = rs[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }

    static class MessageBundle {
        String bundle;
        List<XModelObject> files = new ArrayList<XModelObject>();

        MessageBundle(String bundle, List<XModelObject> files) {
            this.bundle = bundle;
            this.files = files;
        }
    }
}

