/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.OpenShiftException;
import com.openshift.client.SSHPublicKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AbstractSSHKeyWizardPageModel;

public class AddSSHKeyWizardPageModel
extends AbstractSSHKeyWizardPageModel {
    public static final String PROPERTY_PUBLICKEY_PATH = "publicKeyPath";
    private String keyPath;
    private IOpenShiftSSHKey key;

    public AddSSHKeyWizardPageModel(ExpressConnection user) {
        super(user);
    }

    public String getPublicKeyPath() {
        return this.keyPath;
    }

    @Override
    public File getPublicKey() {
        return new File(this.keyPath);
    }

    public void setPublicKeyPath(String keyPath) {
        this.keyPath = keyPath;
        this.firePropertyChange(PROPERTY_PUBLICKEY_PATH, this.keyPath, this.keyPath);
    }

    @Override
    public boolean hasPublicKey(String publicKeyContent) {
        return this.getConnection().hasSSHPublicKey(publicKeyContent);
    }

    @Override
    public IOpenShiftSSHKey addSSHKey() throws FileNotFoundException, OpenShiftException, IOException {
        this.key = this.getConnection().putSSHKey(this.getName(), (ISSHPublicKey)new SSHPublicKey(this.getPublicKey()));
        return this.key;
    }

    @Override
    public IOpenShiftSSHKey getSSHKey() {
        return this.key;
    }
}

