/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.RestoreSnapshotWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.RestoreSnapshotWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class RestoreSnapshotWizardPage
extends AbstractOpenShiftWizardPage {
    private RestoreSnapshotWizardPageModel pageModel;

    public RestoreSnapshotWizardPage(RestoreSnapshotWizardModel wizardModel, IWizard wizard) {
        this("Restore/Deploy Snapshot Cartridges", NLS.bind((String)"Please choose the snapshot type and file that we will restore/deploy to application {0}", (Object)StringUtils.null2emptyString((String)wizardModel.getApplication().getName())), wizardModel, wizard);
    }

    protected RestoreSnapshotWizardPage(String title, String description, RestoreSnapshotWizardModel wizardModel, IWizard wizard) {
        super(title, description, title, wizard);
        this.pageModel = new RestoreSnapshotWizardPageModel(wizardModel);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(5).margins(10, 10).applyTo(parent);
        Label snapshotTypeLabel = new Label(parent, 0);
        snapshotTypeLabel.setText("Snapshot Type:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)snapshotTypeLabel);
        Button fullSnapshotButton = new Button(parent, 16);
        fullSnapshotButton.setText("Full");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)fullSnapshotButton);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)fullSnapshotButton)).converting((IConverter)new InvertingBooleanConverter())).to(BeanProperties.value((String)"deploymentSnapshot").observe((Object)this.pageModel)).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        Button deploymentSnapshotButton = new Button(parent, 16);
        deploymentSnapshotButton.setText("Deployment");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)deploymentSnapshotButton);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)deploymentSnapshotButton)).to(BeanProperties.value((String)"deploymentSnapshot").observe((Object)this.pageModel)).in(dbc);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)new Composite(parent, 0));
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)new Composite(parent, 0));
        Label filepathLabel = new Label(parent, 0);
        filepathLabel.setText("File:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)filepathLabel);
        Text filepathText = new Text(parent, 2048);
        filepathText.setEditable(false);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).hint(100, -1).grab(true, false).applyTo((Control)filepathText);
        ISWTObservableValue filenameObservable = WidgetProperties.text((int)24).observe((Widget)filepathText);
        ValueBindingBuilder.bind((IObservableValue)filenameObservable).to(BeanProperties.value((String)"filepath").observe((Object)this.pageModel)).in(dbc);
        Button workspaceButton = new Button(parent, 8);
        workspaceButton.setText("Workspace...");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(100, -1).applyTo((Control)workspaceButton);
        workspaceButton.addSelectionListener((SelectionListener)this.onWorkspace());
        Button browseButton = new Button(parent, 8);
        browseButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseButton);
        browseButton.addSelectionListener((SelectionListener)this.onBrowse());
        Button hotDeployButton = new Button(parent, 32);
        hotDeployButton.setText("Use Hot Deployment");
        GridDataFactory.fillDefaults().span(5, 1).align(4, 0x1000000).applyTo((Control)hotDeployButton);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)hotDeployButton)).to(BeanProperties.value((String)"hotDeploy").observe((Object)this.pageModel)).in(dbc);
        FilepathValidator filenameValidator = new FilepathValidator((IObservableValue)filenameObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)filenameValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)filenameValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, true).applyTo((Control)new Composite(parent, 0));
    }

    private SelectionAdapter onBrowse() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(RestoreSnapshotWizardPage.this.getShell(), 4096);
                dialog.setText("Choose your snapshot file");
                dialog.setFilterPath(FileUtils.getParent((String)RestoreSnapshotWizardPage.this.pageModel.getFilepath()));
                String filepath = dialog.open();
                if (!StringUtils.isEmpty((String)filepath)) {
                    RestoreSnapshotWizardPage.this.pageModel.setFilepath(filepath);
                }
            }
        };
    }

    private SelectionAdapter onWorkspace() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(RestoreSnapshotWizardPage.this.getShell(), 4096);
                dialog.setText("Choose your snapshot file");
                dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                String filepath = dialog.open();
                if (!StringUtils.isEmpty((String)filepath)) {
                    RestoreSnapshotWizardPage.this.pageModel.setFilepath(filepath);
                }
            }
        };
    }

    static class FilepathValidator
    extends MultiValidator {
        private IObservableValue filepathObservable;

        public FilepathValidator(IObservableValue filenameObservable) {
            this.filepathObservable = filenameObservable;
        }

        protected IStatus validate() {
            String filepath = (String)this.filepathObservable.getValue();
            if (StringUtils.isEmpty((String)filepath)) {
                return ValidationStatus.cancel((String)"Please provide a file that we can restore/deploy.");
            }
            File snapshotFile = new File(filepath);
            if (!snapshotFile.exists()) {
                return ValidationStatus.error((String)NLS.bind((String)"File {0} is not existing.", (Object)filepath));
            }
            if (!snapshotFile.canRead()) {
                return ValidationStatus.error((String)NLS.bind((String)"File {0} is not readable. Please check your permissions.", (Object)filepath));
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.filepathObservable);
            return targets;
        }
    }
}

