/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import com.openshift.client.DeploymentTypes;
import com.openshift.client.IApplication;
import com.openshift.internal.client.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.RestoreSnapshotWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.RestoreSnapshotWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;

public class RestoreSnapshotWizard
extends AbstractOpenShiftWizard<RestoreSnapshotWizardModel> {
    public RestoreSnapshotWizard(IApplication application) {
        super("Restore/Deploy Snapshot", (Object)new RestoreSnapshotWizardModel(application));
    }

    public boolean performFinish() {
        final IApplication application = ((RestoreSnapshotWizardModel)((Object)this.getModel())).getApplication();
        final String applicationName = application.getName();
        try {
            final RestoreJob restoreJob = new RestoreJob(application);
            Job jobChain = new JobChainBuilder((Job)restoreJob).runWhenDone((Job)new UIJob(NLS.bind((String)"Show Snapshot Restore/Deploy Output for application {0}...", (Object)applicationName)){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageConsole console = ConsoleUtils.displayConsoleView(application);
                    if (console == null) {
                        return ExpressUIActivator.createCancelStatus(NLS.bind((String)"Cound not open console for application {0}", (Object)applicationName));
                    }
                    this.printResponse(restoreJob.getResponse(), console);
                    return Status.OK_STATUS;
                }

                private void printResponse(String response, MessageConsole console) {
                    MessageConsoleStream messageStream = console.newMessageStream();
                    if (StringUtils.isEmpty((String)response)) {
                        messageStream.print("Done");
                    } else {
                        messageStream.print(response);
                    }
                }
            }).build();
            WizardUtils.runInWizard((Job)jobChain, (IWizardContainer)this.getContainer());
            return restoreJob.getResult().isOK();
        }
        catch (InvocationTargetException e) {
            IStatus status = ExpressUIActivator.createErrorStatus(e.getMessage(), e);
            new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not restore snapshot for application {0}", (Object)applicationName), status, 4).open();
            return false;
        }
        catch (InterruptedException e) {
            IStatus status = ExpressUIActivator.createErrorStatus(e.getMessage(), e);
            new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not restore snapshot for application {0}", (Object)applicationName), status, 4).open();
            return false;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new RestoreSnapshotWizardPage((RestoreSnapshotWizardModel)((Object)this.getModel()), (IWizard)this));
    }

    private class RestoreJob
    extends AbstractDelegatingMonitorJob {
        private IApplication application;
        private String response;

        RestoreJob(IApplication application) {
            super(NLS.bind((String)"Restoring/Deploying snapshot for application {0}...", (Object)application.getName()));
            this.application = application;
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String deploymentType = this.application.getDeploymentType();
            try {
                if (((RestoreSnapshotWizardModel)((Object)RestoreSnapshotWizard.this.getModel())).isDeploymentSnapshot()) {
                    monitor.subTask(NLS.bind((String)"Setting binary deployment type for application {0}...", (Object)this.application.getName()));
                    this.application.setDeploymentType(DeploymentTypes.binary());
                }
                monitor.subTask("Restoring snapshot...");
                this.response = ((RestoreSnapshotWizardModel)((Object)RestoreSnapshotWizard.this.getModel())).restoreSnapshot(monitor);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (IOException e) {
                IStatus iStatus = ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not restore snapshot for application {0}", (Object)this.application.getName()), e);
                return iStatus;
            }
            finally {
                if (((RestoreSnapshotWizardModel)((Object)RestoreSnapshotWizard.this.getModel())).isDeploymentSnapshot()) {
                    monitor.subTask(NLS.bind((String)"Restoring deployment type {0} for application {1}", (Object)deploymentType, (Object)this.application.getName()));
                    this.application.setDeploymentType(deploymentType);
                }
            }
        }

        public String getResponse() {
            return this.response;
        }
    }
}

