/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.markers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.wizard.markers.ConfigureMarkersWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class ConfigureMarkersWizard
extends Wizard {
    private IProject project;
    private ConfigureMarkersWizardPage configureMarkersPage;

    public ConfigureMarkersWizard(IProject project) {
        this.project = project;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NLS.bind((String)"Configure OpenShift Markers for project {0}", (Object)project.getName()));
    }

    public boolean performFinish() {
        try {
            Collection<IOpenShiftMarker> removedMarkers = this.configureMarkersPage.getRemovedMarkers();
            Collection<IOpenShiftMarker> addedMarkers = this.configureMarkersPage.getAddedMarkers();
            AddRemoveMarkersJob job = new AddRemoveMarkersJob(removedMarkers, addedMarkers, this.project);
            IStatus result = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            return result.isOK();
        }
        catch (Exception e) {
            ExpressUIActivator.log(e);
            return false;
        }
    }

    public void addPages() {
        this.configureMarkersPage = new ConfigureMarkersWizardPage(this.project, (IWizard)this);
        this.addPage((IWizardPage)this.configureMarkersPage);
    }

    private class AddRemoveMarkersJob
    extends AbstractDelegatingMonitorJob {
        private Collection<IOpenShiftMarker> markersToAdd;
        private Collection<IOpenShiftMarker> markersToRemove;
        private IProject project;

        public AddRemoveMarkersJob(Collection<IOpenShiftMarker> removedMarkers, Collection<IOpenShiftMarker> addedMarkers, IProject project) {
            super(NLS.bind((String)"Adding/Removing markers in project {0}", (Object)project.getName()));
            this.project = project;
            this.markersToAdd = addedMarkers;
            this.markersToRemove = removedMarkers;
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            MultiStatus multiStatus = new MultiStatus("org.jboss.tools.openshift.express.ui", 0, "Error(s) occurred while adding/removing marker(s)", null);
            Repository repository = EGitUtils.getRepository((IProject)this.project);
            this.removeMarkers(this.markersToRemove, this.project, monitor, multiStatus);
            this.addMarkers(this.markersToAdd, this.project, repository, monitor, multiStatus);
            return multiStatus;
        }

        private IStatus removeMarkers(Collection<IOpenShiftMarker> removedMarkers, IProject project, IProgressMonitor monitor, MultiStatus multiStatus) {
            monitor.beginTask(NLS.bind((String)"Removing markers from project {0}", (Object)project.getName()), removedMarkers.size());
            for (IOpenShiftMarker marker : removedMarkers) {
                try {
                    monitor.subTask("Removing marker {0}...");
                    monitor.internalWorked(1.0);
                    marker.removeFrom(project, monitor);
                }
                catch (CoreException e) {
                    multiStatus.add(ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not remove marker {0}", (Object)marker.getName()), e));
                }
            }
            return multiStatus;
        }

        private IStatus addMarkers(Collection<IOpenShiftMarker> markersToAdd, IProject project, Repository repository, IProgressMonitor monitor, MultiStatus multiStatus) {
            monitor.beginTask(NLS.bind((String)"Adding markers to project {0}", (Object)project.getName()), markersToAdd.size());
            for (IOpenShiftMarker marker : markersToAdd) {
                try {
                    monitor.subTask("Adding marker {0}...");
                    monitor.internalWorked(1.0);
                    IFile markerFile = marker.addTo(project, monitor);
                    if (repository == null) continue;
                    EGitUtils.addToRepository(Collections.singletonList(markerFile), (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    multiStatus.add(ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not add marker {0}", (Object)marker.getName()), e));
                }
            }
            return multiStatus;
        }
    }
}

