/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.IApplicationProperties;
import org.jboss.tools.openshift.express.internal.core.cartridges.CodeAnythingCartridge;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.util.CollectionUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.EmbedCartridgesJob;
import org.jboss.tools.openshift.express.internal.ui.job.FireExpressConnectionsChangedJob;
import org.jboss.tools.openshift.express.internal.ui.wizard.CreationLogDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.LogEntryFactory;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPage;

public class EditEmbeddedCartridgesWizard
extends Wizard {
    private EmbeddedCartridgesWizardModel wizardModel;
    private EmbeddedCartridgesWizardPage embeddedCartridgesWizardPage;
    private IApplication application;

    public EditEmbeddedCartridgesWizard(IApplication application, ExpressConnection connection) {
        Assert.isLegal((application != null ? 1 : 0) != 0);
        this.wizardModel = new EmbeddedCartridgesWizardModel(new HashSet<ICartridge>(application.getEmbeddedCartridges()), (List)CollectionUtils.addTo((Object)new CodeAnythingCartridge(), new ArrayList(CollectionUtils.addAllTo(new ArrayList(application.getEmbeddedCartridges()), new HashSet(connection.getEmbeddableCartridges())))), new ExistingApplicationProperties(application), application.getDomain(), connection);
        this.application = application;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Edit Embedded Cartridges");
    }

    public boolean performFinish() {
        return this.processCartridges();
    }

    public boolean processCartridges() {
        try {
            EmbedCartridgesJob job = new EmbedCartridgesJob(new ArrayList<ICartridge>(this.wizardModel.getCheckedEmbeddableCartridges()), this.application);
            IStatus result = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            if (!result.isOK()) {
                this.safeRefreshSelectedEmbeddedCartridges();
            } else {
                this.openLogDialog(job.getAddedCartridges(), job.isTimeouted(result));
            }
            new FireExpressConnectionsChangedJob(this.wizardModel.getConnection()).schedule();
            return result.isOK();
        }
        catch (Exception e) {
            String errorMessage = NLS.bind((String)"Could not embed cartridge(s) for application {0}", (Object)this.application.getName());
            IStatus status = ExpressUIActivator.createErrorStatus(errorMessage, e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error while embedding cartridges", (String)(String.valueOf(errorMessage) + ": " + StringUtils.null2emptyString((String)e.getMessage())), (IStatus)status);
            return false;
        }
    }

    private void openLogDialog(final List<IEmbeddedCartridge> cartridges, final boolean isTimeouted) {
        if (cartridges.size() == 0) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new CreationLogDialog(EditEmbeddedCartridgesWizard.this.getShell(), LogEntryFactory.create(cartridges, isTimeouted)).open();
            }
        });
    }

    private void safeRefreshSelectedEmbeddedCartridges() {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EditEmbeddedCartridgesWizard.this.embeddedCartridgesWizardPage.setCheckedEmbeddableCartridges(EditEmbeddedCartridgesWizard.this.wizardModel.getEmbeddedCartridges());
                }
                catch (Exception e) {
                    ExpressUIActivator.log(e);
                }
            }
        });
    }

    public void addPages() {
        this.embeddedCartridgesWizardPage = new EmbeddedCartridgesWizardPage(this.wizardModel, (IWizard)this);
        this.addPage((IWizardPage)this.embeddedCartridgesWizardPage);
    }

    private static class ExistingApplicationProperties
    implements IApplicationProperties {
        private IApplication application;

        ExistingApplicationProperties(IApplication application) {
            this.application = application;
        }

        public IStandaloneCartridge getStandaloneCartridge() {
            return this.application.getCartridge();
        }

        public ApplicationScale getApplicationScale() {
            return this.application.getApplicationScale();
        }

        public String getApplicationName() {
            return this.application.getName();
        }
    }
}

