/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;

public class ManageDomainsWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_DOMAIN = "selectedDomain";
    public static final String PROPERTY_DOMAINS = "domains";
    private ExpressConnection connection;
    private IDomain selectedDomain;
    private List<IDomain> domains;
    private IConnectionsRegistryListener connectionChangeListener;

    public ManageDomainsWizardPageModel(IDomain domain, ExpressConnection connection) {
        this(connection);
        this.setSelectedDomain(domain);
    }

    public ManageDomainsWizardPageModel(ExpressConnection connection) {
        this.connection = connection;
        this.connectionChangeListener = this.onConnectionsChanged();
        ConnectionsRegistrySingleton.getInstance().addListener(this.connectionChangeListener);
    }

    private IConnectionsRegistryListener onConnectionsChanged() {
        return new IConnectionsRegistryListener(){

            public void connectionRemoved(IConnection connection) {
                if (ConnectionType.Express == connection.getType()) {
                    ManageDomainsWizardPageModel.this.connection = null;
                    ManageDomainsWizardPageModel.this.loadDomains();
                }
            }

            public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
                if (ConnectionType.Express == connection.getType()) {
                    ManageDomainsWizardPageModel.this.setDomains(Collections.emptyList());
                    ManageDomainsWizardPageModel.this.loadDomains();
                }
            }

            public void connectionAdded(IConnection connection) {
                if (ConnectionType.Express == connection.getType()) {
                    ManageDomainsWizardPageModel.this.loadDomains();
                }
            }
        };
    }

    public void loadDomains() {
        if (this.connection == null) {
            this.setDomains(Collections.emptyList());
        } else {
            this.setDomains(this.connection.getDomains());
        }
    }

    public void setDomains(List<IDomain> domains) {
        this.domains = domains;
        this.firePropertyChange(PROPERTY_DOMAINS, null, this.domains);
    }

    public List<IDomain> getDomains() {
        return this.domains;
    }

    public void refresh() {
        this.connection.refresh();
        this.loadDomains();
    }

    public void setSelectedDomain(IDomain domain) {
        this.selectedDomain = domain;
        this.firePropertyChange(PROPERTY_SELECTED_DOMAIN, this.selectedDomain, this.selectedDomain);
    }

    public IDomain getSelectedDomain() {
        return this.selectedDomain;
    }

    public ExpressConnection getConnection() {
        return this.connection;
    }

    public void dispose() {
        ConnectionsRegistrySingleton.getInstance().removeListener(this.connectionChangeListener);
    }
}

