/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerFactory;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.ImportNewProject;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.MergeIntoGitSharedProject;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.MergeIntoUnsharedProject;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;

class OpenShiftApplicationWizardModel
extends ObservablePojo
implements IOpenShiftApplicationWizardModel {
    protected HashMap<String, Object> dataModel = new HashMap();

    public OpenShiftApplicationWizardModel(ExpressConnection connection, IDomain domain) {
        this(connection, domain, null, null, false);
    }

    public OpenShiftApplicationWizardModel(ExpressConnection connection, IDomain domain, IApplication application, IProject project, boolean useExistingApplication) {
        this.setProject(project);
        this.setApplicationName(project);
        this.setDomain(domain);
        this.setApplication(application);
        this.setUseExistingApplication(useExistingApplication);
        this.setConnection(connection);
        this.setEnvironmentVariables(new LinkedHashMap<String, String>());
    }

    @Override
    public IProject importProject(IProgressMonitor monitor) throws OpenShiftException, CoreException, InterruptedException, URISyntaxException, InvocationTargetException, IOException, NoWorkTreeException, GitAPIException {
        IProject project = new ImportNewProject(this.getProjectName(), this.getApplication(), this.getRemoteName(), this.getRepositoryFile(), this.getMarkers(), this.getConnection()).execute(monitor);
        this.setProject(project);
        return project;
    }

    public Object getContext() {
        return null;
    }

    @Override
    public IProject mergeIntoUnsharedProject(IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, IOException, CoreException, URISyntaxException {
        IProject project = new MergeIntoUnsharedProject(this.getProjectName(), this.getApplication(), this.getRemoteName(), this.getMarkers(), this.getConnection()).execute(monitor);
        this.setProject(project);
        return project;
    }

    @Override
    public IProject mergeIntoGitSharedProject(IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, IOException, CoreException, URISyntaxException, NoWorkTreeException, GitAPIException {
        IProject project = new MergeIntoGitSharedProject(this.getProjectName(), this.getApplication(), this.getRemoteName(), this.getMarkers(), this.getConnection()).execute(monitor);
        this.setProject(project);
        return project;
    }

    @Override
    public IServer createServerAdapter(IProgressMonitor monitor) throws OpenShiftException {
        IServer server = null;
        if (this.isCreateServerAdapter()) {
            IProject project = this.getProject();
            if (project == null) {
                throw new OpenShiftException("Could not create a server adapter for your application {0}. No project was found when importing", new Object[]{this.getApplication().getName()});
            }
            server = new OpenShiftServerFactory().create(project, this.getApplication(), this.getDomain(), monitor);
            this.setServerAdapter(server);
        }
        return server;
    }

    @Override
    public File getRepositoryFile() {
        String repositoryPath = this.getRepositoryPath();
        if (repositoryPath == null || repositoryPath.length() == 0) {
            return null;
        }
        return new File(repositoryPath, this.getApplicationName());
    }

    @Override
    public boolean hasDomain() {
        return this.getDomain() != null;
    }

    @Override
    public IDomain setDomain(IDomain domain) {
        return this.setProperty("domain", domain);
    }

    @Override
    public IDomain getDomain() {
        return (IDomain)this.getProperty("domain");
    }

    @Override
    public void setDefaultDomainIfRequired() {
        Assert.isNotNull((Object)this.getConnection());
        if (!this.hasDomain()) {
            this.setDomain(this.getConnection().getDefaultDomain());
        }
    }

    @Override
    public List<IDomain> setDomains(List<IDomain> domains) {
        return this.setProperty("domains", domains);
    }

    @Override
    public List<IDomain> getDomains() {
        return (List)this.getProperty("domains");
    }

    @Override
    public IApplication getApplication() {
        return (IApplication)this.getProperty("application");
    }

    @Override
    public IApplication setApplication(IApplication application) {
        this.setProperty("application", application);
        this.setApplicationName(application);
        return application;
    }

    @Override
    public String setRemoteName(String remoteName) {
        return this.setProperty("remoteName", remoteName);
    }

    @Override
    public String getRemoteName() {
        return (String)this.getProperty("remoteName");
    }

    @Override
    public String setRepositoryPath(String repositoryPath) {
        return this.setProperty("repositoryPath", repositoryPath);
    }

    @Override
    public String getRepositoryPath() {
        return (String)this.getProperty("repositoryPath");
    }

    @Override
    public boolean isNewProject() {
        return this.getBooleanProperty("newProject");
    }

    @Override
    public Boolean setNewProject(boolean newProject) {
        return this.setProperty("newProject", newProject);
    }

    @Override
    public String setProjectName(String projectName) {
        return this.setProperty("projectName", projectName);
    }

    @Override
    public IProject setProject(IProject project) {
        if (project != null) {
            this.setProjectName(project.getName());
        } else {
            this.setProjectName(null);
        }
        return project;
    }

    @Override
    public boolean isGitSharedProject() {
        return EGitUtils.isSharedWithGit((IProject)this.getProject());
    }

    @Override
    public IProject getProject() {
        String projectName = this.getProjectName();
        if (StringUtils.isEmpty((String)projectName)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    @Override
    public Boolean setCreateServerAdapter(Boolean createServerAdapter) {
        return this.setProperty("createServerAdapter", createServerAdapter);
    }

    @Override
    public boolean isCreateServerAdapter() {
        return this.getBooleanProperty("createServerAdapter");
    }

    @Override
    public Boolean setSkipMavenBuild(Boolean skipMavenBuild) {
        return this.setProperty("skipMavenBuild", skipMavenBuild);
    }

    @Override
    public boolean isSkipMavenBuild() {
        return this.getBooleanProperty("skipMavenBuild");
    }

    private List<IOpenShiftMarker> getMarkers() {
        ArrayList<IOpenShiftMarker> markers = new ArrayList<IOpenShiftMarker>();
        if (this.isSkipMavenBuild()) {
            markers.add(IOpenShiftMarker.SKIP_MAVEN_BUILD);
        }
        return markers;
    }

    @Override
    public String getProjectName() {
        return (String)this.getProperty("projectName");
    }

    @Override
    public String setMergeUri(String mergeUri) {
        return this.setProperty("mergeUri", mergeUri);
    }

    @Override
    public String getMergeUri() {
        return (String)this.getProperty("mergeUri");
    }

    @Override
    public boolean isUseExistingApplication() {
        return this.getBooleanProperty("useExistingApplication");
    }

    @Override
    public boolean setUseExistingApplication(boolean useExistingApplication) {
        return this.setProperty("useExistingApplication", useExistingApplication);
    }

    @Override
    public ApplicationScale getApplicationScale() {
        return (ApplicationScale)this.getProperty("applicationScale");
    }

    @Override
    public ApplicationScale setApplicationScale(ApplicationScale scale) {
        return this.setProperty("applicationScale", scale);
    }

    protected void setApplicationScale(IApplication application) {
        ApplicationScale scale = null;
        if (application != null) {
            scale = application.getApplicationScale();
        }
        this.setApplicationScale(scale);
    }

    @Override
    public ICartridge getStandaloneCartridge() {
        IApplicationTemplate template = this.getSelectedApplicationTemplate();
        if (template == null) {
            return null;
        }
        return template.getStandaloneCartridge();
    }

    @Override
    public Set<ICartridge> getCartridges() {
        HashSet<ICartridge> allCartridges = new HashSet<ICartridge>(this.getEmbeddedCartridges());
        if (this.getStandaloneCartridge() != null) {
            allCartridges.add(this.getStandaloneCartridge());
        }
        return allCartridges;
    }

    @Override
    public Set<ICartridge> getEmbeddedCartridges() {
        Set<ICartridge> selectedEmbeddableCartridges = this.getProperty("embeddedCartridges", Collections.emptySet());
        return selectedEmbeddableCartridges;
    }

    @Override
    public Set<ICartridge> setEmbeddedCartridges(Set<ICartridge> cartridges) {
        return this.setProperty("embeddedCartridges", cartridges);
    }

    @Override
    public void addEmbeddedCartridges(List<ICartridge> addedCartridges) {
        Set<ICartridge> cartridges = this.getEmbeddedCartridges();
        cartridges.addAll(addedCartridges);
        this.firePropertyChange("embeddedCartridges", null, cartridges);
    }

    @Override
    public void removeEmbeddedCartridge(ICartridge removedCartridge) {
        Set<ICartridge> cartridges = this.getEmbeddedCartridges();
        cartridges.remove(removedCartridge);
        this.firePropertyChange("embeddedCartridges", null, cartridges);
    }

    @Override
    public void removeEmbeddedCartridges(List<ICartridge> removedCartridges) {
        Set<ICartridge> cartridges = this.getEmbeddedCartridges();
        cartridges.removeAll(removedCartridges);
        this.firePropertyChange("embeddedCartridges", null, cartridges);
    }

    @Override
    public List<ICartridge> getAvailableEmbeddableCartridges() {
        return this.getProperty("allEmbeddableCartridges", Collections.emptyList());
    }

    @Override
    public List<ICartridge> setAvailableEmbeddableCartridges(List<ICartridge> embeddableCartridges) {
        return this.setProperty("allEmbeddableCartridges", embeddableCartridges);
    }

    protected void setDomain(IApplication application) {
        IDomain domain = null;
        if (application != null) {
            domain = application.getDomain();
        }
        this.setDomain(domain);
    }

    @Override
    public IGearProfile getApplicationGearProfile() {
        return (IGearProfile)this.getProperty("applicationGearProfile");
    }

    @Override
    public IGearProfile setApplicationGearProfile(IGearProfile gearProfile) {
        return this.setProperty("applicationGearProfile", gearProfile);
    }

    protected void setApplicationGearProfile(IApplication application) {
        IGearProfile profile = null;
        if (application != null) {
            profile = application.getGearProfile();
        }
        this.setApplicationGearProfile(profile);
    }

    @Override
    public List<IStandaloneCartridge> setAvailableStandaloneCartridges(List<IStandaloneCartridge> cartridges) {
        return this.setProperty("allStandaloneCartridges", cartridges);
    }

    @Override
    public List<IStandaloneCartridge> getAvailableStandaloneCartridges() {
        return (List)this.getProperty("allStandaloneCartridges");
    }

    @Override
    public String setApplicationName(String applicationName) {
        return this.setProperty("applicationName", applicationName);
    }

    protected void setApplicationName(IApplication application) {
        if (application != null) {
            this.setApplicationName(application.getName());
        }
    }

    protected void setApplicationName(IProject project) {
        if (project != null) {
            this.setApplicationName(project.getName());
        }
    }

    @Override
    public String getApplicationName() {
        return (String)this.getProperty("applicationName");
    }

    @Override
    public String getInitialGitUrl() {
        return (String)this.getProperty("initialGitUrl");
    }

    @Override
    public String setInitialGitUrl(String initialGitUrl) {
        return this.setProperty("initialGitUrl", initialGitUrl);
    }

    @Override
    public boolean isUseInitialGitUrl() {
        return this.getProperty("useInitialGitUrl", false);
    }

    @Override
    public boolean setUseInitialGitUrl(boolean useInitialGitUrl) {
        if (!useInitialGitUrl) {
            this.setInitialGitUrl(null);
        }
        return this.setProperty("useInitialGitUrl", useInitialGitUrl);
    }

    public boolean hasConnection() {
        return this.getConnection() != null;
    }

    public ExpressConnection setConnection(ExpressConnection connection) {
        this.setProperty("connection", connection);
        return connection;
    }

    public ExpressConnection getConnection() {
        return (ExpressConnection)this.getProperty("connection");
    }

    protected IServer setServerAdapter(IServer server) {
        return this.setProperty("serverAdapter", server);
    }

    protected IServer getServerAdapter() {
        return (IServer)this.getProperty("serverAdapter");
    }

    protected boolean hasServerAdapter() {
        return this.getServerAdapter() != null;
    }

    private void update(ExpressConnection connection) {
        if (!this.isValid(connection)) {
            return;
        }
        if (!connection.hasDomain()) {
            IDomain domain = this.getDomain();
            domain = connection.getFirstDomain();
            this.setDomain(domain);
        }
    }

    @Override
    public IApplicationTemplate getSelectedApplicationTemplate() {
        return (IApplicationTemplate)this.getProperty("selectedApplicationTemplate");
    }

    @Override
    public IApplicationTemplate setSelectedApplicationTemplate(IApplicationTemplate template) {
        this.setUseExistingApplication(false);
        this.setInitialGitUrl(template.getInitialGitUrl());
        this.setUseInitialGitUrl(!StringUtils.isEmpty((String)template.getInitialGitUrl()));
        this.setEmbeddedCartridges(template.getEmbeddedCartridges());
        this.setProperty("selectedApplicationTemplate", template);
        return template;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return (Map)this.getProperty("environmentVariables");
    }

    @Override
    public Map<String, String> setEnvironmentVariables(Map<String, String> environmentVariables) {
        return this.setProperty("environmentVariables", environmentVariables);
    }

    public boolean isValid(ExpressConnection connection) {
        return connection != null && connection.isConnected();
    }

    private <V> V setProperty(String key, V value) {
        Object oldVal = this.dataModel.get(key);
        this.dataModel.put(key, value);
        this.firePropertyChange(key, oldVal, value);
        return value;
    }

    private <E> E getProperty(String key) {
        return this.getProperty(key, null);
    }

    private <V> V getProperty(String key, V defaultValue) {
        Object value = this.dataModel.get(key);
        if (value == null) {
            value = defaultValue;
            return (V)value;
        }
        return (V)value;
    }

    private boolean getBooleanProperty(String name) {
        Boolean binaryValue = (Boolean)this.getProperty(name);
        return binaryValue != null && binaryValue != false;
    }
}

