/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.preferences.ExpressCorePreferences;
import org.jboss.tools.openshift.express.internal.ui.ExpressImages;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.ContentProposalUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICartridgeApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICodeAnythingApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IQuickstartApplicationTemplate;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;

public class ApplicationTemplateDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView defaultView = new DefaultView();
    private final AbstractStackedDetailViews.IDetailView downloadableCartridgeView = new CodeAnthingCartridgeView();
    private final AbstractStackedDetailViews.IDetailView quickstartView = new QuickstartView();
    private IObservableValue disabled;

    ApplicationTemplateDetailViews(IObservableValue detailViewModel, IObservableValue disabled, Composite parent, DataBindingContext dbc) {
        super(detailViewModel, null, parent, dbc);
        this.disabled = disabled;
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.downloadableCartridgeView.createControls(parent, context, dbc);
        this.quickstartView.createControls(parent, context, dbc);
        this.defaultView.createControls(parent, context, dbc);
        this.emptyView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.quickstartView, this.downloadableCartridgeView, this.defaultView};
    }

    private class CodeAnthingCartridgeView
    extends DefaultView {
        private StyledText nameText;
        private StyledText descriptionText;
        private Text urlText;
        private Binding binding;

        private CodeAnthingCartridgeView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 2).spacing(6, 2).applyTo(container);
            this.nameText = new StyledText(container, 8);
            StyledTextUtils.setTransparent((StyledText)this.nameText);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
            this.descriptionText = new StyledText(container, 584);
            this.descriptionText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.descriptionText);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, true).hint(container.getClientArea().x, -1).applyTo((Control)this.descriptionText);
            Label urlLabel = new Label(container, 0);
            urlLabel.setText("Cartridge URL:");
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)urlLabel);
            this.urlText = new Text(container, 2048);
            this.createContentProposal(this.urlText);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.urlText);
            return container;
        }

        private void createContentProposal(Text text) {
            final ControlDecoration decoration = ContentProposalUtils.createContenProposalDecoration("History available", (Control)text);
            ContentProposalUtils.createContentProposal(text, ExpressCorePreferences.INSTANCE.getDownloadableStandaloneCartUrls());
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    decoration.show();
                }

                public void focusLost(FocusEvent e) {
                    decoration.hide();
                }
            });
        }

        @Override
        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameText)) {
                return;
            }
            IApplicationTemplate applicationTemplate = (IApplicationTemplate)value;
            String name = applicationTemplate.getName();
            this.nameText.setText(name);
            this.nameText.setStyleRange(StyledTextUtils.createBoldStyleRange((String)name, null));
            this.descriptionText.setText(applicationTemplate.getDescription());
            ISWTObservableValue urlTextObservable = WidgetProperties.text((int)24).observe((Widget)this.urlText);
            this.binding = ValueBindingBuilder.bind((IObservableValue)urlTextObservable).to(BeanProperties.value((String)"url", String.class).observeDetail(applicationTemplateObservable)).in(dbc);
            CodeAnythingCartridgeUrlValidator codeAnythingCartridgeUrlValidator = new CodeAnythingCartridgeUrlValidator((IObservableValue)urlTextObservable, applicationTemplateObservable, ApplicationTemplateDetailViews.this.disabled);
            dbc.addValidationStatusProvider((ValidationStatusProvider)codeAnythingCartridgeUrlValidator);
            ControlDecorationSupport.create((ValidationStatusProvider)codeAnythingCartridgeUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        }

        public void onInVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            DataBindingUtils.dispose((ValidationStatusProvider)this.binding);
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICodeAnythingApplicationTemplate;
        }

        class CodeAnythingCartridgeUrlValidator
        extends MultiValidator {
            private IObservableValue url;
            private IObservableValue disabled;
            private IObservableValue applicationTemplate;

            private CodeAnythingCartridgeUrlValidator(IObservableValue url, IObservableValue template, IObservableValue disabled) {
                this.url = url;
                this.applicationTemplate = template;
                this.disabled = disabled;
            }

            protected IStatus validate() {
                String url = (String)this.url.getValue();
                IApplicationTemplate applicationTemplate = (IApplicationTemplate)this.applicationTemplate.getValue();
                Boolean disabled = (Boolean)this.disabled.getValue();
                if (Boolean.valueOf(disabled).booleanValue()) {
                    return ValidationStatus.ok();
                }
                if (applicationTemplate == null || !(applicationTemplate instanceof ICodeAnythingApplicationTemplate)) {
                    return ValidationStatus.ok();
                }
                if (StringUtils.isEmpty((String)url)) {
                    return ValidationStatus.cancel((String)"Please provide an url for your cartridge.");
                }
                if (!UrlUtils.isValid((String)url) && !EGitUtils.isValidGitUrl((String)url)) {
                    return ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid url.", (Object)url));
                }
                return ValidationStatus.ok();
            }
        }
    }

    private class DefaultView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText nameText;
        private StyledText descriptionText;

        private DefaultView() {
            super((AbstractStackedDetailViews)ApplicationTemplateDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(super.createControls(parent, context, dbc));
            GridLayoutFactory.fillDefaults().margins(8, 2).spacing(6, 2).applyTo(container);
            this.nameText = new StyledText(container, 8);
            this.nameText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.nameText);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
            this.descriptionText = new StyledText(container, 584);
            this.descriptionText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.descriptionText);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(container.getClientArea().x, -1).applyTo((Control)this.descriptionText);
            return container;
        }

        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameText)) {
                return;
            }
            IApplicationTemplate applicationTemplate = (IApplicationTemplate)value;
            String templateName = applicationTemplate.getName();
            this.nameText.setText(templateName);
            this.nameText.setStyleRange(StyledTextUtils.createBoldStyleRange((String)templateName, null));
            this.descriptionText.setText(applicationTemplate.getDescription());
        }

        public boolean isViewFor(Object object) {
            return object instanceof ICartridgeApplicationTemplate;
        }

        /* synthetic */ DefaultView(DefaultView defaultView, DefaultView defaultView2) {
            this();
        }
    }

    private class QuickstartView
    extends AbstractStackedDetailViews.EmptyView {
        private Link nameLink;
        private CLabel openshiftMaintainedLabel;
        private CLabel securityUpdatesLabel;
        private StyledText summaryText;
        private IQuickstartApplicationTemplate template;

        private QuickstartView() {
            super((AbstractStackedDetailViews)ApplicationTemplateDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(8, 2).numColumns(4).spacing(6, 2).applyTo(container);
            this.nameLink = new Link(container, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.nameLink);
            this.nameLink.addSelectionListener(this.onLinkClicked());
            this.openshiftMaintainedLabel = new CLabel(container, 0);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.openshiftMaintainedLabel);
            this.securityUpdatesLabel = new CLabel(container, 0);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.securityUpdatesLabel);
            this.summaryText = new StyledText(container, 584);
            this.summaryText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.summaryText);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, true).hint(container.getClientArea().x, -1).applyTo((Control)this.summaryText);
            return container;
        }

        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IQuickstartApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameLink)) {
                return;
            }
            this.template = (IQuickstartApplicationTemplate)value;
            this.nameLink.setText("<a>" + this.template.getName() + "</a>");
            this.nameLink.setEnabled(this.template.hasPageUrl());
            this.updateOpenShiftMaintainedIcon(this.template);
            this.updateSecurityUpdatesIcon(this.template);
            this.summaryText.setText(this.template.getDescription());
        }

        private void updateOpenShiftMaintainedIcon(IQuickstartApplicationTemplate template) {
            if (template.isOpenShiftMaintained()) {
                this.setImageAndTooltip(this.openshiftMaintainedLabel, "OpenShift maintained", ExpressImages.OPENSHIFT_MAINTAINED_IMG);
            } else {
                this.setImageAndTooltip(this.openshiftMaintainedLabel, "Community created", ExpressImages.NOT_OPENSHIFT_MAINTAINED_IMG);
            }
        }

        private void updateSecurityUpdatesIcon(IQuickstartApplicationTemplate template) {
            if (template.isAutomaticSecurityUpdates()) {
                this.setImageAndTooltip(this.securityUpdatesLabel, "automatic security updates", ExpressImages.SECURITY_UPDATES_IMG);
            } else {
                this.setImageAndTooltip(this.securityUpdatesLabel, "no automatic security updates", ExpressImages.NO_SECURITY_UPDATES_IMG);
            }
        }

        private void setImageAndTooltip(CLabel label, String text, Image image) {
            label.setImage(image);
            label.setToolTipText(text);
        }

        private SelectionListener onLinkClicked() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QuickstartView.this.template == null) {
                        return;
                    }
                    new BrowserUtility().checkedCreateExternalBrowser(QuickstartView.this.template.getPageUrl(), "org.jboss.tools.openshift.express.ui", ExpressUIActivator.getDefault().getLog());
                }
            };
        }

        public boolean isViewFor(Object object) {
            return object instanceof IQuickstartApplicationTemplate;
        }
    }
}

