/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.NotFoundOpenShiftException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.common.ui.wizard.OkButtonWizardDialog;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.cartridges.EmbedCartridgeStrategy;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.util.CartridgeToStringConverter;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.DialogChildVisibilityAdapter;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.viewer.EmbeddableCartridgeViewerSorter;
import org.jboss.tools.openshift.express.internal.ui.viewer.EqualityComparer;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.AddEmbeddableCartridgesWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ApplicationConfigurationWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.EditAlternativeCartridgesWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IQuickstartApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.ManageDomainsWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.NewEnvironmentVariablesWizard;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.databinding.EmptyStringToNullConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.MultiConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimmingStringConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.viewer.AbstractLabelProvider;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;

public class ApplicationConfigurationWizardPage
extends AbstractOpenShiftWizardPage {
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_APPLY = 1;
    public static final int RESULT_IGNORE = 2;
    private ApplicationConfigurationWizardPageModel pageModel;
    private Text applicationNameText;
    private OpenShiftApplicationWizardModel wizardModel;
    private Button advancedButton;
    private DialogChildVisibilityAdapter advancedSectionVisibilityAdapter;

    ApplicationConfigurationWizardPage(IWizard wizard, OpenShiftApplicationWizardModel wizardModel) {
        super("New or existing OpenShift Application", "", "New or existing OpenShift Application, wizard", wizard);
        this.setDescription("Create a new OpenShift Application.");
        this.wizardModel = wizardModel;
        this.pageModel = new ApplicationConfigurationWizardPageModel(wizardModel);
        this.setupWizardModelListeners(wizardModel);
    }

    private void setupWizardModelListeners(OpenShiftApplicationWizardModel wizardModel) {
        wizardModel.addPropertyChangeListener("connection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ApplicationConfigurationWizardPage.this.pageModel.setResourcesLoaded(false);
            }
        });
    }

    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(3).applyTo(container);
        this.createDomainControls(container, dbc);
        this.createApplicationControls(container, dbc);
    }

    private void createDomainControls(Composite parent, DataBindingContext dbc) {
        Label domainLabel = new Label(parent, 0);
        domainLabel.setText("Domain:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)domainLabel);
        ComboViewer domainViewer = new ComboViewer(parent);
        domainViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        domainViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IDomain)) {
                    return null;
                }
                return ((IDomain)element).getId();
            }
        });
        domainViewer.setInput((Object)BeanProperties.list((String)"domains").observe((Object)this.pageModel));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(domainViewer.getControl());
        IViewerObservableValue selectedDomainObservable = ViewerProperties.singlePostSelection().observe((Viewer)domainViewer);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)selectedDomainObservable).notUpdating(BeanProperties.value((String)"domain").observe((Object)this.pageModel)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof IDomain)) {
                    return ValidationStatus.error((String)"Please choose a domain.");
                }
                return ValidationStatus.ok();
            }
        })).in(dbc);
        selectedDomainObservable.addValueChangeListener(this.onDomainChanged(dbc));
        Link manageDomainsLink = new Link(parent, 0);
        manageDomainsLink.setText("<a>Manage Domains</a>");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)manageDomainsLink);
        manageDomainsLink.addSelectionListener(this.onManageDomains());
    }

    private IValueChangeListener onDomainChanged(final DataBindingContext dbc) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object value = event.getObservableValue().getValue();
                if (!(value instanceof IDomain)) {
                    return;
                }
                final IDomain domain = (IDomain)value;
                if (ApplicationConfigurationWizardPage.this.pageModel.isCurrentDomain(domain)) {
                    return;
                }
                try {
                    WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob(NLS.bind((String)"Loading applications for domain {0}...", (Object)domain.getId())){

                        protected IStatus doRun(IProgressMonitor monitor) {
                            ApplicationConfigurationWizardPage.this.pageModel.setDomain(domain);
                            ApplicationConfigurationWizardPage.this.pageModel.loadExistingApplications();
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)ApplicationConfigurationWizardPage.this.getContainer(), (DataBindingContext)dbc);
                }
                catch (InvocationTargetException e) {
                    ExpressUIActivator.log(ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not load applications for domain {0}.", (Object)domain), e));
                }
                catch (InterruptedException e) {
                    ExpressUIActivator.log(ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not load applications for domain {0}.", (Object)domain), e));
                }
            }
        };
    }

    private void createApplicationControls(Composite parent, DataBindingContext dbc) {
        Label newAppNameLabel = new Label(parent, 0);
        newAppNameLabel.setText("Name:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)newAppNameLabel);
        this.applicationNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 4).applyTo((Control)this.applicationNameText);
        UIUtils.selectAllOnFocus((Text)this.applicationNameText);
        ISWTObservableValue applicationNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.applicationNameText);
        IObservableValue applicationNameModelObservable = BeanProperties.value((String)"applicationName").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)applicationNameTextObservable).to(applicationNameModelObservable).in(dbc);
        NewApplicationNameValidator newApplicationNameValidator = new NewApplicationNameValidator(BeanProperties.value((String)"useExistingApplication").observe((Object)this.pageModel), BeanProperties.value((String)"resourcesLoaded").observe((Object)this.pageModel), (IObservableValue)applicationNameTextObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)newApplicationNameValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)newApplicationNameValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label applicationTypeLabel = new Label(parent, 0);
        applicationTypeLabel.setText("Type:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)applicationTypeLabel);
        Label selectedApplicationTemplateLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)selectedApplicationTemplateLabel);
        IObservableValue selectedApplicationTemplate = BeanProperties.value((String)"selectedApplicationTemplate").observe((Object)this.pageModel);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)BeanProperties.value((String)"name").observeDetail(selectedApplicationTemplate)).converting((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                if (!(fromObject instanceof String)) {
                    return fromObject;
                }
                return StringUtils.shorten((String)((String)fromObject), (int)50);
            }
        })).to((IObservableValue)WidgetProperties.text().observe((Widget)selectedApplicationTemplateLabel)).notUpdatingParticipant()).in(dbc);
        Label gearProfileLabel = new Label(parent, 0);
        gearProfileLabel.setText("Gear profile:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)gearProfileLabel);
        ComboViewer gearViewer = new ComboViewer(parent);
        gearViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        gearViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                return ExpressResourceLabelUtils.toString((IGearProfile)((IGearProfile)element));
            }
        });
        gearViewer.setInput((Object)BeanProperties.list((String)"gearProfiles").observe((Object)this.pageModel));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(gearViewer.getControl());
        Button enableScalingButton = new Button(parent, 32);
        enableScalingButton.setText("Enable scaling");
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)enableScalingButton)).converting((IConverter)new BooleanToApplicationScaleConverter())).to(BeanProperties.value((String)"scale").observe((Object)this.pageModel)).converting((IConverter)new ApplicationScaleToBooleanConverter())).in(dbc);
        Group embeddableCartridgesGroup = new Group(parent, 0);
        embeddableCartridgesGroup.setText(this.getCartridgesListLabel(this.pageModel.getSelectedApplicationTemplate()));
        BeanProperties.value((String)"selectedApplicationTemplate").observe((Object)this.pageModel).addValueChangeListener(this.onApplicationTemplateChanged(embeddableCartridgesGroup));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(3, 1).applyTo((Control)embeddableCartridgesGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)embeddableCartridgesGroup);
        Composite tableContainer = new Composite((Composite)embeddableCartridgesGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).hint(400, -1).grab(true, true).span(1, 2).applyTo((Control)tableContainer);
        TableViewer embeddableCartridgesTableViewer = this.createEmbeddableCartridgesViewer(tableContainer);
        embeddableCartridgesTableViewer.setInput((Object)BeanProperties.set((String)"embeddedCartridges").observe((Object)this.pageModel));
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singlePostSelection().observe((Viewer)embeddableCartridgesTableViewer)).to(BeanProperties.value((String)"selectedCartridge").observe((Object)this.pageModel)).in(dbc);
        Composite buttonsComposite = this.createAddRemoveEditButtons(embeddableCartridgesGroup, dbc);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)buttonsComposite);
        this.createAdvancedGroup(parent, dbc);
    }

    private IValueChangeListener onApplicationTemplateChanged(final Group cartridgesGroup) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff.getNewValue() instanceof IApplicationTemplate) {
                    IApplicationTemplate template = (IApplicationTemplate)event.diff.getNewValue();
                    cartridgesGroup.setText(ApplicationConfigurationWizardPage.this.getCartridgesListLabel(template));
                    if (template instanceof IQuickstartApplicationTemplate) {
                        IQuickstartApplicationTemplate quickstart = (IQuickstartApplicationTemplate)template;
                        ApplicationConfigurationWizardPage.this.showAdvancedSection(!StringUtils.isEmpty((String)quickstart.getInitialGitUrl()));
                    } else {
                        ApplicationConfigurationWizardPage.this.showAdvancedSection(false);
                    }
                }
            }
        };
    }

    private String getCartridgesListLabel(IApplicationTemplate template) {
        if (template instanceof IQuickstartApplicationTemplate) {
            return "All Cartridges";
        }
        return "Embedded Cartridges";
    }

    private Composite createAddRemoveEditButtons(Group parent, DataBindingContext dbc) {
        Composite buttonsContainer = new Composite((Composite)parent, 0);
        StackLayout stackLayout = new StackLayout();
        buttonsContainer.setLayout((Layout)stackLayout);
        Composite addRemoveButtons = new Composite(buttonsContainer, 0);
        GridLayoutFactory.fillDefaults().applyTo(addRemoveButtons);
        Button addButton = new Button(addRemoveButtons, 8);
        addButton.setText("&Add...");
        GridDataFactory.fillDefaults().align(4, 4).hint(110, -1).applyTo((Control)addButton);
        addButton.addSelectionListener(this.onAdd());
        Button removeButton = new Button(addRemoveButtons, 8);
        removeButton.setText("&Remove");
        GridDataFactory.fillDefaults().align(4, 4).hint(110, -1).applyTo((Control)removeButton);
        removeButton.addSelectionListener(this.onRemove());
        IObservableValue selectedEmbeddableCartridge = BeanProperties.value((String)"selectedCartridge").observe((Object)this.pageModel);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to(selectedEmbeddableCartridge).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Composite editButtons = new Composite(buttonsContainer, 0);
        GridLayoutFactory.fillDefaults().applyTo(editButtons);
        Button editButton = new Button(editButtons, 8);
        editButton.setText("&Edit...");
        GridDataFactory.fillDefaults().align(4, 4).hint(110, -1).applyTo((Control)editButton);
        editButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editButton)).notUpdatingParticipant()).to(selectedEmbeddableCartridge).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        stackLayout.topControl = this.getEmbeddableCartridgesButtons(this.pageModel.isCanAddRemoveCartridges(), addRemoveButtons, editButtons);
        BeanProperties.value((String)"canAddRemoveCartridges").observe((Object)this.pageModel).addValueChangeListener(this.onCanAddRemoveChanged(addRemoveButtons, editButtons, buttonsContainer, stackLayout));
        return buttonsContainer;
    }

    private IValueChangeListener onCanAddRemoveChanged(final Composite addRemoveButtons, final Composite editButtons, final Composite parent, final StackLayout stackLayout) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (!(event.diff.getNewValue() instanceof Boolean)) {
                    return;
                }
                stackLayout.topControl = ApplicationConfigurationWizardPage.this.getEmbeddableCartridgesButtons((Boolean)event.diff.getNewValue(), addRemoveButtons, editButtons);
                parent.layout(true);
            }
        };
    }

    private Composite getEmbeddableCartridgesButtons(boolean canAddRemoveEmbeddableCartridges, Composite addRemoveButtons, Composite editButtons) {
        if (canAddRemoveEmbeddableCartridges) {
            return addRemoveButtons;
        }
        return editButtons;
    }

    private void createAdvancedGroup(Composite parent, DataBindingContext dbc) {
        this.advancedButton = new Button(parent, 0);
        this.advancedButton.setText(this.getAdvancedButtonLabel(false));
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).applyTo((Control)this.advancedButton);
        Composite advancedComposite = new Composite(parent, 0);
        GridData advancedCompositeGridData = GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(3, 1).create();
        advancedComposite.setLayoutData((Object)advancedCompositeGridData);
        GridLayoutFactory.fillDefaults().applyTo(advancedComposite);
        Group sourceGroup = new Group(advancedComposite, 0);
        sourceGroup.setText("Source Code");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)sourceGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)sourceGroup);
        Button useDefaultSourceButton = new Button((Composite)sourceGroup, 32);
        useDefaultSourceButton.setText("Use default source code");
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(2, 1).applyTo((Control)useDefaultSourceButton);
        ISWTObservableValue useDefaultSourceButtonObservable = WidgetProperties.selection().observe((Widget)useDefaultSourceButton);
        IObservableValue useInitialGitUrlModelObservable = BeanProperties.value((String)"useInitialGitUrl").observe((Object)this.pageModel);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)useDefaultSourceButtonObservable).converting((IConverter)new InvertingBooleanConverter())).to(useInitialGitUrlModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        IObservableValue initialGitUrlEditable = BeanProperties.value((String)"initialGitUrlEditable").observe((Object)this.pageModel);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)useDefaultSourceButton)).notUpdatingParticipant()).to(initialGitUrlEditable).in(dbc);
        Label sourceUrlLabel = new Label((Composite)sourceGroup, 0);
        sourceUrlLabel.setText("Source code:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)sourceUrlLabel);
        IObservableValue sourceUrlWidgetsEnablement = BeanProperties.value((String)"initialGitUrlUsereditable").observe((Object)this.pageModel);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)sourceUrlLabel)).notUpdatingParticipant()).to(sourceUrlWidgetsEnablement).in(dbc);
        Text sourceUrlText = new Text((Composite)sourceGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sourceUrlText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)sourceUrlText)).notUpdatingParticipant()).to(sourceUrlWidgetsEnablement).in(dbc);
        ISWTObservableValue sourcecodeUrlObservable = WidgetProperties.text((int)24).observe((Widget)sourceUrlText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)sourcecodeUrlObservable).converting((IConverter)new MultiConverter(new IConverter[]{new TrimmingStringConverter(), new EmptyStringToNullConverter()}))).to(BeanProperties.value((String)"initialGitUrl").observe((Object)this.pageModel)).in(dbc);
        SourceCodeUrlValidator sourceCodeUrlValidator = new SourceCodeUrlValidator((IObservableValue)useDefaultSourceButtonObservable, (IObservableValue)sourcecodeUrlObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)sourceCodeUrlValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)sourceCodeUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        this.advancedSectionVisibilityAdapter = new DialogChildVisibilityAdapter(advancedComposite, false);
        this.advancedButton.addSelectionListener(this.onAdvancedClicked());
        StyledText sourceCodeExplanationText = new StyledText((Composite)sourceGroup, 584);
        sourceCodeExplanationText.setAlwaysShowScrollBars(false);
        sourceCodeExplanationText.setText("Your application will start with an exact copy of the code and configuration provided in this Git repository instead of the default application.");
        sourceCodeExplanationText.setEnabled(false);
        StyledTextUtils.setTransparent((StyledText)sourceCodeExplanationText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(2, 1).applyTo((Control)sourceCodeExplanationText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)sourceCodeExplanationText)).notUpdatingParticipant()).to(sourceUrlWidgetsEnablement).in(dbc);
        Button environmentVariablesButton = new Button(advancedComposite, 0);
        environmentVariablesButton.setText("Environment Variables... ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)environmentVariablesButton);
        environmentVariablesButton.addSelectionListener(this.onBrowseEnvironmentVariables(dbc));
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.visible().observe((Widget)environmentVariablesButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"environmentVariablesSupported").observe((Object)this.pageModel)).in(dbc);
    }

    protected SelectionListener onManageDomains() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressConnection connection = ApplicationConfigurationWizardPage.this.pageModel.getConnection();
                if (connection == null) {
                    return;
                }
                ManageDomainsWizard domainWizard = new ManageDomainsWizard("Choose domain", "Please choose the domain for your new application", ApplicationConfigurationWizardPage.this.pageModel.getDomain(), connection);
                if (new OkButtonWizardDialog(ApplicationConfigurationWizardPage.this.getShell(), (IWizard)domainWizard).open() == 0) {
                    ApplicationConfigurationWizardPage.this.pageModel.setDomains(domainWizard.getDomains());
                    ApplicationConfigurationWizardPage.this.pageModel.setDomain(domainWizard.getDomain());
                }
            }
        };
    }

    private TableViewer createEmbeddableCartridgesViewer(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).sorter((ViewerSorter)new EmbeddableCartridgeViewerSorter()).comparer((IElementComparer)new EqualityComparer()).contentProvider((IStructuredContentProvider)new ObservableSetContentProvider()).column("Name").weight(1).labelProvider((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<ICartridge>(){

            public String getValue(ICartridge cartridge) {
                return ExpressResourceLabelUtils.toString((ICartridge)cartridge);
            }
        }).buildColumn().buildViewer();
        return viewer;
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEmbeddableCartridgesWizard cartridgesWizard = new AddEmbeddableCartridgesWizard(ApplicationConfigurationWizardPage.this.wizardModel);
                if (new OkCancelButtonWizardDialog(ApplicationConfigurationWizardPage.this.getShell(), (IWizard)cartridgesWizard).open() == 0) {
                    ApplicationConfigurationWizardPage.this.pageModel.setEmbeddedCartridges(cartridgesWizard.getCheckedCartridges());
                }
            }
        };
    }

    private SelectionListener onRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.remove(ApplicationConfigurationWizardPage.this.pageModel.getSelectedCartridge());
            }

            private void remove(ICartridge cartridge) {
                EmbedCartridgeStrategy embedCartridgeStrategy = this.createEmbedCartridgeStrategy(ApplicationConfigurationWizardPage.this.pageModel.getDomain());
                EmbedCartridgeStrategy.EmbeddableCartridgeDiff additionalOperations = embedCartridgeStrategy.remove(cartridge, ApplicationConfigurationWizardPage.this.pageModel.getEmbeddedCartridges());
                int result = 1;
                if (additionalOperations.hasChanges()) {
                    result = this.executeAdditionalOperations(cartridge, additionalOperations);
                }
                if (result != 0) {
                    ApplicationConfigurationWizardPage.this.wizardModel.removeEmbeddedCartridge(cartridge);
                }
            }

            private EmbedCartridgeStrategy createEmbedCartridgeStrategy(IDomain domain) {
                IOpenShiftConnection connection = domain.getUser().getConnection();
                EmbedCartridgeStrategy embedCartridgeStrategy = new EmbedCartridgeStrategy(new ArrayList(connection.getEmbeddableCartridges()), new ArrayList(connection.getStandaloneCartridges()), (Collection)domain.getApplications());
                return embedCartridgeStrategy;
            }

            protected int executeAdditionalOperations(ICartridge cartridge, EmbedCartridgeStrategy.EmbeddableCartridgeDiff additionalOperations) {
                int result = this.openAdditionalOperationsDialog("Remove Cartridges", NLS.bind((String)"If you want to remove {0}, it is suggested you:\n", (Object)new CartridgeToStringConverter().toString(additionalOperations.getCartridge())) + additionalOperations.toString() + "\n\nDo you want to Apply or Ignore these suggestions??");
                switch (result) {
                    case 1: {
                        ApplicationConfigurationWizardPage.this.wizardModel.removeEmbeddedCartridges(additionalOperations.getRemovals());
                        ApplicationConfigurationWizardPage.this.wizardModel.addEmbeddedCartridges(additionalOperations.getAdditions());
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
                return result;
            }

            public int openAdditionalOperationsDialog(String title, String message) {
                MessageDialog dialog = new MessageDialog(ApplicationConfigurationWizardPage.this.getShell(), title, null, message, 3, new String[]{"Cancel", "Apply", "Ignore"}, 1);
                return dialog.open();
            }
        };
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICartridge selectedCartridge = ApplicationConfigurationWizardPage.this.pageModel.getSelectedCartridge();
                if (selectedCartridge == null) {
                    return;
                }
                IApplicationTemplate selectedTemplate = ApplicationConfigurationWizardPage.this.pageModel.getSelectedApplicationTemplate();
                if (selectedTemplate == null || selectedTemplate.canAddRemoveCartridges()) {
                    return;
                }
                IQuickstartApplicationTemplate selectedQuickstart = (IQuickstartApplicationTemplate)selectedTemplate;
                EditAlternativeCartridgesWizard cartridgesWizard = new EditAlternativeCartridgesWizard(selectedCartridge, selectedQuickstart.getAlternativesFor(selectedCartridge), ApplicationConfigurationWizardPage.this.wizardModel);
                if (new OkCancelButtonWizardDialog(ApplicationConfigurationWizardPage.this.getShell(), (IWizard)cartridgesWizard).open() == 0) {
                    ICartridge checkedCartridge = cartridgesWizard.getCheckedCartridge();
                    this.replaceSelectedCartridge(selectedCartridge, checkedCartridge);
                }
            }

            protected void replaceSelectedCartridge(ICartridge selectedCartridge, ICartridge checkedCartridge) {
                if (!selectedCartridge.equals(checkedCartridge)) {
                    ApplicationConfigurationWizardPage.this.pageModel.removeEmbeddedCartridges(selectedCartridge);
                    ApplicationConfigurationWizardPage.this.pageModel.addEmbeddedCartridges(checkedCartridge);
                }
            }
        };
    }

    private SelectionListener onAdvancedClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationConfigurationWizardPage.this.showAdvancedSection(!ApplicationConfigurationWizardPage.this.advancedSectionVisibilityAdapter.isVisible());
            }
        };
    }

    protected void showAdvancedSection(boolean visible) {
        this.advancedSectionVisibilityAdapter.setVisible(visible);
        this.advancedButton.setText(this.getAdvancedButtonLabel(visible));
    }

    protected String getAdvancedButtonLabel(boolean visible) {
        if (visible) {
            return " << Advanced ";
        }
        return " Advanced >> ";
    }

    private SelectionListener onBrowseEnvironmentVariables(DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvironmentVariablesWizard environmentVariablesWizard = new NewEnvironmentVariablesWizard(ApplicationConfigurationWizardPage.this.pageModel.getEnvironmentVariables(), ApplicationConfigurationWizardPage.this.pageModel.getDomain());
                if (new OkButtonWizardDialog(ApplicationConfigurationWizardPage.this.getShell(), (IWizard)environmentVariablesWizard).open() == 0) {
                    ApplicationConfigurationWizardPage.this.pageModel.setEnvironmentVariables(environmentVariablesWizard.getEnvironmentVariables());
                }
            }
        };
    }

    protected void onPageWillGetActivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        if (this.pageModel.isUseExistingApplication()) {
            this.getContainer().showPage(direction.getFollowingPage((IWizardPage)this));
            event.doit = false;
            return;
        }
    }

    protected void onPageActivated(DataBindingContext dbc) {
        try {
            this.loadOpenshiftResources(dbc);
            this.applicationNameText.setFocus();
        }
        catch (OpenShiftException e) {
            Logger.error("Failed to reset page fields", e);
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    protected void loadOpenshiftResources(DataBindingContext dbc) {
        try {
            if (this.pageModel.isResourcesLoaded()) {
                return;
            }
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Loading applications, cartridges and gears..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        ApplicationConfigurationWizardPage.this.pageModel.loadResources();
                        return Status.OK_STATUS;
                    }
                    catch (NotFoundOpenShiftException notFoundOpenShiftException) {
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return ExpressUIActivator.createErrorStatus("Could not load applications, cartridges and gears", e);
                    }
                }
            }, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (Exception exception) {}
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    private static final class ApplicationScaleToBooleanConverter
    extends Converter {
        private ApplicationScaleToBooleanConverter() {
            super(Object.class, Boolean.class);
        }

        public Object convert(Object fromObject) {
            if (!(fromObject instanceof ApplicationScale)) {
                return null;
            }
            switch ((ApplicationScale)fromObject) {
                case SCALE: {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
    }

    private final class BooleanToApplicationScaleConverter
    extends Converter {
        private BooleanToApplicationScaleConverter() {
            super(Boolean.class, ApplicationScale.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof Boolean) {
                return (Boolean)fromObject != false ? ApplicationScale.SCALE : ApplicationScale.NO_SCALE;
            }
            return null;
        }
    }

    class NewApplicationNameValidator
    extends MultiValidator {
        private final IObservableValue applicationNameObservable;
        private IObservableValue existingApplicationsLoadedObservable;
        private IObservableValue useExistingApplicationObservable;

        NewApplicationNameValidator(IObservableValue useExistingApplication, IObservableValue existingApplicationsLoaded, IObservableValue applicationName) {
            this.useExistingApplicationObservable = useExistingApplication;
            this.existingApplicationsLoadedObservable = existingApplicationsLoaded;
            this.applicationNameObservable = applicationName;
        }

        protected IStatus validate() {
            boolean useExistingApplication = (Boolean)this.useExistingApplicationObservable.getValue();
            String applicationName = (String)this.applicationNameObservable.getValue();
            Boolean existingApplicationsLoaded = (Boolean)this.existingApplicationsLoadedObservable.getValue();
            if (useExistingApplication) {
                return ValidationStatus.ok();
            }
            if (applicationName.isEmpty()) {
                return ValidationStatus.cancel((String)"Please choose a name for your new application.");
            }
            if (!StringUtils.isAlphaNumeric((String)applicationName)) {
                return ValidationStatus.error((String)"The name may only contain letters and digits.");
            }
            if (existingApplicationsLoaded != null && !existingApplicationsLoaded.booleanValue()) {
                return ValidationStatus.cancel((String)"Existing applications are not loaded yet.");
            }
            if (ApplicationConfigurationWizardPage.this.pageModel.isExistingApplication(applicationName)) {
                return ValidationStatus.error((String)"An application with the same name already exists on OpenShift.");
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.applicationNameObservable);
            return targets;
        }
    }

    static class SourceCodeUrlValidator
    extends MultiValidator {
        private IObservableValue defaultSourcecodeObservable;
        private IObservableValue sourcecodeUrlObservable;

        public SourceCodeUrlValidator(IObservableValue defaultSourcecodeObservable, IObservableValue sourcecodeUrlObservable) {
            this.defaultSourcecodeObservable = defaultSourcecodeObservable;
            this.sourcecodeUrlObservable = sourcecodeUrlObservable;
        }

        protected IStatus validate() {
            if (Boolean.TRUE.equals(this.defaultSourcecodeObservable.getValue())) {
                return ValidationStatus.ok();
            }
            Object value = this.sourcecodeUrlObservable.getValue();
            if (value instanceof String) {
                String gitUri = StringUtils.trim((String)((String)value));
                if (StringUtils.isEmpty((String)gitUri)) {
                    return ValidationStatus.cancel((String)"Please provide a git url for your source code");
                }
                if (UrlUtils.isValid((String)gitUri) || EGitUtils.isValidGitUrl((String)gitUri)) {
                    return ValidationStatus.ok();
                }
            }
            return ValidationStatus.error((String)"You have to provide a valid git url.");
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.sourcecodeUrlObservable);
            return targets;
        }
    }
}

