/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.BrowserUtil;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressImages;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;

public class CreationLogDialog
extends TitleAreaDialog {
    private static final Pattern HTTP_LINK_REGEX = Pattern.compile("(http[^ |\n]+)");
    private List<Link> links;
    private LogEntry[] logEntries;

    public CreationLogDialog(Shell parentShell, LogEntry[] logEntries) {
        super(parentShell);
        this.logEntries = logEntries;
        this.links = new ArrayList<Link>();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setupDialog(parent);
        return control;
    }

    private void setupDialog(Composite parent) {
        parent.getShell().setText("Embedded Cartridges");
        this.setTitle("Please make note of the credentials and url that were reported\nwhen your cartridges were embedded / application was created. ");
        this.setTitleImage(ExpressImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
        CreationLogDialog.setDialogHelpAvailable((boolean)false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        Label separator = new Label(container, 258);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)separator);
        StyledText logText = new StyledText(container, 2624);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, true).hint(400, -1).applyTo((Control)logText);
        logText.setEditable(false);
        this.writeLogEntries(this.logEntries, logText);
        logText.addListener(3, this.onLinkClicked(logText));
        return container;
    }

    private Listener onLinkClicked(final StyledText logText) {
        return new Listener(){

            public void handleEvent(Event event) {
                try {
                    int offset = logText.getOffsetAtLocation(new Point(event.x, event.y));
                    Link link = CreationLogDialog.this.getLink(offset);
                    if (link == null || !this.isLinkStyle(offset)) {
                        return;
                    }
                    try {
                        link.execute();
                    }
                    catch (Exception e) {
                        ExpressUIActivator.log(e);
                        MessageDialog.openError((Shell)CreationLogDialog.this.getShell(), (String)"Could not execute link", (String)e.getMessage());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }

            private boolean isLinkStyle(int offset) {
                StyleRange style = logText.getStyleRangeAtOffset(offset);
                return style != null && style.underline;
            }
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void writeLogEntries(LogEntry[] logEntries, StyledText logText) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        LogEntry[] logEntryArray = logEntries;
        int n = logEntries.length;
        int n2 = 0;
        while (n2 < n) {
            LogEntry logEntry = logEntryArray[n2];
            this.createTextAndStyle(logEntry, builder, styles);
            ++n2;
        }
        logText.setText(builder.toString());
        this.setStyleRanges(logText, styles);
    }

    private void createTextAndStyle(LogEntry logEntry, StringBuilder builder, List<StyleRange> styles) {
        if (logEntry == null) {
            return;
        }
        this.appendTitle(logEntry.getName(), builder, styles);
        this.appendLog(logEntry, builder, styles);
    }

    private void appendLog(LogEntry logEntry, StringBuilder builder, List<StyleRange> styles) {
        String log = logEntry.getLog();
        if (logEntry.isTimeouted) {
            builder.append(NLS.bind((String)"<The request timed out but we could create {0}. You can look up eventual credentials in the environment variables>", (Object)logEntry.getName()));
        } else if (StringUtils.isEmpty((String)log)) {
            builder.append("<no information reported by OpenShift>");
        } else {
            this.createUrlLinks(log, builder.length(), styles);
            builder.append(log);
        }
        builder.append(StringUtils.getLineSeparator());
    }

    private void createUrlLinks(String log, int baseIndex, List<StyleRange> styles) {
        if (log == null) {
            return;
        }
        Matcher matcher = HTTP_LINK_REGEX.matcher(log);
        while (matcher.find() && matcher.groupCount() == 1) {
            int linkStart = matcher.start() + baseIndex;
            int linkStop = matcher.end() + baseIndex;
            String url = matcher.group(1);
            UrlLink linkEntry = new UrlLink(linkStart, linkStop, url);
            this.links.add(linkEntry);
            StyleRange linkStyle = StyledTextUtils.createLinkStyle((int)linkStart, (int)linkStop, (Shell)this.getShell());
            styles.add(linkStyle);
        }
    }

    private void appendTitle(String title, StringBuilder builder, List<StyleRange> styles) {
        StyleRange styleRange = this.startBoldStyleRange(builder);
        builder.append(title).append(StringUtils.getLineSeparator()).append("---------------------------------").append(StringUtils.getLineSeparator());
        this.finishBoldStyleRange(builder, styleRange);
        styles.add(styleRange);
    }

    private StyleRange startBoldStyleRange(StringBuilder builder) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = builder.length();
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private StyleRange finishBoldStyleRange(StringBuilder builder, StyleRange styleRange) {
        styleRange.length = builder.length() - styleRange.start;
        return styleRange;
    }

    private void setStyleRanges(StyledText logText, List<StyleRange> styles) {
        for (StyleRange style : styles) {
            logText.setStyleRange(style);
        }
    }

    private Link getLink(int offset) {
        for (Link link : this.links) {
            if (offset >= link.getStopOffset() || offset <= link.getStartOffset()) continue;
            return link;
        }
        return null;
    }

    private static abstract class Link {
        private int startOffset;
        private int stopOffset;

        public Link(int startOffset, int stopOffset) {
            this.startOffset = startOffset;
            this.stopOffset = stopOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getStopOffset() {
            return this.stopOffset;
        }

        public abstract void execute() throws Exception;
    }

    public static class LogEntry {
        private String name;
        private String log;
        private boolean isTimeouted;
        private Object element;

        public LogEntry(String name, String log, boolean isTimeouted, Object element) {
            this.name = name;
            this.log = log;
            this.isTimeouted = isTimeouted;
            this.element = element;
        }

        public String getName() {
            return this.name;
        }

        public String getLog() {
            return this.log;
        }

        public boolean isTimeouted() {
            return this.isTimeouted;
        }

        public Object getElement() {
            return this.element;
        }
    }

    private static class UrlLink
    extends Link {
        private String url;

        public UrlLink(int startOffset, int stopOffset, String url) {
            super(startOffset, stopOffset);
            this.url = url;
        }

        @Override
        public void execute() {
            if (this.url == null || this.url.length() == 0) {
                return;
            }
            BrowserUtil.checkedCreateExternalBrowser((String)this.url, (String)"org.jboss.tools.openshift.express.ui", (ILog)ExpressUIActivator.getDefault().getLog());
        }
    }
}

