/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeUtils {
    public static TreeEditor createTreeEditor(Control control, String cellText, ViewerCell cell) {
        Assert.isTrue((boolean)(cell.getControl() instanceof Tree));
        Tree tree = (Tree)cell.getControl();
        final TreeEditor treeEditor = new TreeEditor(tree);
        TreeUtils.initializeTreeEditor(treeEditor, control, cellText, cell);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                treeEditor.dispose();
            }
        });
        return treeEditor;
    }

    public static void initializeTreeEditor(TreeEditor treeEditor, Control control, String cellText, ViewerCell cell) {
        treeEditor.grabHorizontal = true;
        treeEditor.grabVertical = true;
        treeEditor.horizontalAlignment = 4;
        treeEditor.verticalAlignment = 4;
        TreeItem treeItem = (TreeItem)cell.getItem();
        treeEditor.setEditor(control, treeItem, cell.getColumnIndex());
    }

    public static void setRowHeight(final int height, Tree tree) {
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = height;
            }
        });
    }
}

