/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.server;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitMessageHistory;
import org.eclipse.egit.ui.internal.commit.CommitProposalProcessor;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.components.FilteredCheckboxTree;
import org.eclipse.egit.ui.internal.decorators.ProblemLabelDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageArea;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressImages;
import org.jboss.tools.openshift.express.internal.ui.server.CommitItem;
import org.jboss.tools.openshift.express.internal.ui.server.CommitViewerComparator;

public class CommitDialog
extends TitleAreaDialog {
    private static final String SHOW_UNTRACKED_PREF = "CommitDialog.showUntracked";
    private static final String DIALOG_SETTINGS_SECTION_NAME = String.valueOf(Activator.getPluginId()) + ".COMMIT_DIALOG_SECTION";
    FormToolkit toolkit;
    CommitMessageComponent commitMessageComponent;
    SpellcheckableMessageArea commitText;
    Text authorText;
    Text committerText;
    ToolItem amendingItem;
    ToolItem signedOffItem;
    ToolItem changeIdItem;
    ToolItem showUntrackedItem;
    CachedCheckboxTreeViewer filesViewer;
    Section filesSection;
    Button commitButton;
    ArrayList<CommitItem> items = new ArrayList();
    private String commitMessage = null;
    private String author = null;
    private String committer = null;
    private Set<String> preselectedFiles = Collections.emptySet();
    private boolean preselectAll = false;
    private ArrayList<String> selectedFiles = new ArrayList();
    private boolean amending = false;
    private boolean amendAllowed = true;
    private boolean showUntracked = true;
    private boolean createChangeId = false;
    private boolean allowToChangeSelection = true;
    private Repository repository;
    private boolean isAhead;
    private boolean canCommit;
    private String applicationName;
    private String remote;

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public CommitDialog(String remote, String applicationName, Shell parentShell) {
        super(parentShell);
        this.remote = remote;
        this.applicationName = applicationName;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String s) {
        this.commitMessage = s;
    }

    public Collection<String> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setPreselectedFiles(Set<String> preselectedFiles) {
        Assert.isNotNull(preselectedFiles);
        this.preselectedFiles = preselectedFiles;
    }

    public void setPreselectAll(boolean preselectAll) {
        this.preselectAll = preselectAll;
    }

    public void setFiles(Repository repository, Set<String> paths, IndexDiff indexDiff) {
        this.repository = repository;
        this.items.clear();
        for (String path : paths) {
            CommitItem item = new CommitItem();
            item.status = CommitDialog.getFileStatus(path, indexDiff);
            item.submodule = FileMode.GITLINK == indexDiff.getIndexMode(path);
            item.path = path;
            item.problemSeverity = CommitDialog.getProblemSeverity(repository, path);
            this.items.add(item);
        }
        Collections.sort(this.items, new Comparator<CommitItem>(){

            @Override
            public int compare(CommitItem o1, CommitItem o2) {
                int diff = o1.status.ordinal() - o2.status.ordinal();
                if (diff != 0) {
                    return diff;
                }
                return o1.path.compareTo(o2.path);
            }
        });
        this.isAhead = this.isAhead(this.remote, repository);
    }

    private boolean isAhead(String remote, Repository repository) {
        if (remote != null && remote.length() > 0) {
            try {
                return EGitUtils.isAhead((Repository)repository, (String)remote, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                Activator.logError((String)NLS.bind((String)"Could not check if local branch is ahead of remote {0}", (Object)remote), (Throwable)e);
                return false;
            }
            catch (URISyntaxException e) {
                Activator.logError((String)NLS.bind((String)"Could not check if local branch is ahead of remote {0}", (Object)remote), (Throwable)e);
                return false;
            }
            catch (InvocationTargetException e) {
                Activator.logError((String)NLS.bind((String)"Could not check if local branch is ahead of remote {0}", (Object)remote), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public boolean isAmending() {
        return this.amending;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setAmendAllowed(boolean amendAllowed) {
        this.amendAllowed = amendAllowed;
    }

    public void setAllowToChangeSelection(boolean allowToChangeSelection) {
        this.allowToChangeSelection = allowToChangeSelection;
    }

    public boolean getCreateChangeId() {
        return this.createChangeId;
    }

    public boolean isPushRequested() {
        return this.canCommit;
    }

    public boolean isPushOnlyRequested() {
        return !this.canCommit && this.isAhead;
    }

    private boolean isDirty() {
        return this.items != null && this.items.size() > 0;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.toolkit.adapt((Control)parent, false, false);
        this.commitButton = this.createButton(parent, 0, "Commit and Publish", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateMessage();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected Control createButtonBar(Composite parent) {
        this.toolkit.adapt((Control)parent, false, false);
        return super.createButtonBar(parent);
    }

    protected Control createHelpControl(Composite parent) {
        this.toolkit.adapt((Control)parent, false, false);
        Control help = super.createHelpControl(parent);
        this.toolkit.adapt(help, false, false);
        return help;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION_NAME);
        }
        return section;
    }

    protected ToolBar addMessageDropDown(Composite parent) {
        ToolBar dropDownBar = new ToolBar(parent, 0x820000);
        final ToolItem dropDownItem = new ToolItem(dropDownBar, 8);
        dropDownItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_RENDERED_VIEW_MENU"));
        final Menu menu = new Menu((Control)dropDownBar);
        dropDownItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        MenuItem preferencesItem = new MenuItem(menu, 8);
        preferencesItem.setText(UIText.CommitDialog_ConfigureLink);
        preferencesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] pages = new String[]{"org.eclipse.egit.ui.internal.preferences.CommitDialogPreferencePage"};
                PreferencesUtil.createPreferenceDialogOn((Shell)CommitDialog.this.getShell(), (String)pages[0], (String[])pages, null).open();
            }
        });
        dropDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle b = dropDownItem.getBounds();
                Point p = dropDownItem.getParent().toDisplay(new Point(b.x, b.y + b.height));
                menu.setLocation(p.x, p.y);
                menu.setVisible(true);
            }
        });
        return dropDownBar;
    }

    protected Control createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitDialog.this.toolkit.dispose();
            }
        });
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        parent.getShell().setText("Publish Changes");
        container = this.toolkit.createComposite(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.toolkit.paintBordersFor(container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        SashForm sashForm = new SashForm(container, 516);
        this.toolkit.adapt((Control)sashForm, true, true);
        sashForm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createMessageAndPersonArea((Composite)sashForm);
        this.filesSection = this.createFileSection((Composite)sashForm);
        sashForm.setWeights(new int[]{50, 50});
        CommitDialog.applyDialogFont((Control)container);
        container.pack();
        this.commitText.setFocus();
        this.setTitleImage(ExpressImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
        this.setTitle("Commit and push local changes to OpenShift");
        this.setMessage(UIText.CommitDialog_Message, 1);
        this.filesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommitDialog.this.updateMessage();
            }
        });
        this.updateFileSectionText();
        return container;
    }

    private Section createFileSection(Composite container) {
        Section filesSection = this.toolkit.createSection(container, 272);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)filesSection);
        Composite filesArea = this.toolkit.createComposite((Composite)filesSection);
        filesSection.setClient((Control)filesArea);
        this.toolkit.paintBordersFor(filesArea);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(filesArea);
        ToolBar filesToolbar = new ToolBar((Composite)filesSection, 0x800000);
        filesSection.setTextClient((Control)filesToolbar);
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (element instanceof CommitItem) {
                    CommitItem commitItem = (CommitItem)element;
                    return this.wordMatches(commitItem.path);
                }
                return super.isLeafMatch(viewer, element);
            }
        };
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredCheckboxTree resourcesTreeComposite = new FilteredCheckboxTree(filesArea, this.toolkit, 65536, patternFilter){

            protected WorkbenchJob doCreateRefreshJob() {
                WorkbenchJob filterJob = super.doCreateRefreshJob();
                filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CommitDialog.this.updateFileSectionText();
                                }
                            });
                        }
                    }
                });
                return filterJob;
            }
        };
        Tree resourcesTree = resourcesTreeComposite.getViewer().getTree();
        resourcesTree.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        resourcesTreeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().hint(600, 200).grab(true, true).create());
        resourcesTree.addSelectionListener((SelectionListener)new CommitItemSelectionListener());
        resourcesTree.setHeaderVisible(true);
        TreeColumn statCol = new TreeColumn(resourcesTree, 16384);
        statCol.setText(UIText.CommitDialog_Status);
        statCol.setWidth(150);
        statCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByStatus));
        TreeColumn resourceCol = new TreeColumn(resourcesTree, 16384);
        resourceCol.setText(UIText.CommitDialog_Path);
        resourceCol.setWidth(415);
        resourceCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByFile));
        this.filesViewer = resourcesTreeComposite.getCheckboxTreeViewer();
        new TreeViewerColumn((TreeViewer)this.filesViewer, statCol).setLabelProvider(CommitDialog.createStatusLabelProvider());
        new TreeViewerColumn((TreeViewer)this.filesViewer, resourceCol).setLabelProvider((CellLabelProvider)new CommitPathLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.filesViewer);
        this.filesViewer.setContentProvider((IContentProvider)new CommitFileContentProvider());
        this.filesViewer.setUseHashlookup(true);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(SHOW_UNTRACKED_PREF) != null) {
            this.showUntracked = Boolean.valueOf(settings.get(SHOW_UNTRACKED_PREF)) != false || CommitDialog.getPreferenceStore().getBoolean("commit_dialog_include_untracked");
        }
        this.filesViewer.addFilter((ViewerFilter)new CommitItemFilter());
        this.filesViewer.setInput((Object)this.items.toArray());
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createContextMenuListener());
        this.filesViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.filesViewer.getTree()));
        this.filesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommitDialog.this.updateFileSectionText();
            }
        });
        this.showUntrackedItem = new ToolItem(filesToolbar, 32);
        Image showUntrackedImage = UIIcons.UNTRACKED_FILE.createImage();
        UIUtils.hookDisposal((Widget)this.showUntrackedItem, (Resource)showUntrackedImage);
        this.showUntrackedItem.setImage(showUntrackedImage);
        this.showUntrackedItem.setToolTipText(UIText.CommitDialog_ShowUntrackedFiles);
        this.showUntrackedItem.setSelection(this.showUntracked);
        this.showUntrackedItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.showUntracked = CommitDialog.this.showUntrackedItem.getSelection();
                CommitDialog.this.filesViewer.refresh(true);
                CommitDialog.this.updateFileSectionText();
                CommitDialog.this.updateMessage();
            }
        });
        ToolItem checkAllItem = new ToolItem(filesToolbar, 8);
        Image checkImage = UIIcons.CHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)checkAllItem, (Resource)checkImage);
        checkAllItem.setImage(checkImage);
        checkAllItem.setToolTipText(UIText.CommitDialog_SelectAll);
        checkAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.filesViewer.setAllChecked(true);
                CommitDialog.this.updateFileSectionText();
                CommitDialog.this.updateMessage();
            }
        });
        ToolItem uncheckAllItem = new ToolItem(filesToolbar, 8);
        Image uncheckImage = UIIcons.UNCHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)uncheckAllItem, (Resource)uncheckImage);
        uncheckAllItem.setImage(uncheckImage);
        uncheckAllItem.setToolTipText(UIText.CommitDialog_DeselectAll);
        uncheckAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.filesViewer.setAllChecked(false);
                CommitDialog.this.updateFileSectionText();
                CommitDialog.this.updateMessage();
            }
        });
        if (!this.allowToChangeSelection) {
            this.amendingItem.setSelection(false);
            this.amendingItem.setEnabled(false);
            this.showUntrackedItem.setSelection(false);
            this.showUntrackedItem.setEnabled(false);
            checkAllItem.setEnabled(false);
            uncheckAllItem.setEnabled(false);
            this.filesViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (!event.getChecked()) {
                        CommitDialog.this.filesViewer.setAllChecked(true);
                    }
                    CommitDialog.this.updateFileSectionText();
                }
            });
            this.filesViewer.setAllChecked(true);
        } else {
            boolean includeUntracked = CommitDialog.getPreferenceStore().getBoolean("commit_dialog_include_untracked");
            for (CommitItem item : this.items) {
                if (!this.preselectAll && !this.preselectedFiles.contains(item.path) || item.status == CommitItem.Status.ASSUME_UNCHANGED || !includeUntracked && item.status == CommitItem.Status.UNTRACKED) continue;
                this.filesViewer.setChecked((Object)item, true);
            }
        }
        statCol.pack();
        resourceCol.pack();
        return filesSection;
    }

    private Composite createMessageAndPersonArea(Composite container) {
        Composite messageAndPersonArea = this.toolkit.createComposite(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messageAndPersonArea);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(messageAndPersonArea);
        Section messageSection = this.toolkit.createSection(messageAndPersonArea, 272);
        messageSection.setText(UIText.CommitDialog_CommitMessage);
        Composite messageArea = this.toolkit.createComposite((Composite)messageSection);
        GridLayoutFactory.fillDefaults().spacing(0, 0).extendedMargins(2, 2, 2, 2).applyTo(messageArea);
        this.toolkit.paintBordersFor(messageArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messageSection);
        GridLayoutFactory.swtDefaults().applyTo((Composite)messageSection);
        Composite headerArea = new Composite((Composite)messageSection, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(2).applyTo(headerArea);
        ToolBar messageToolbar = new ToolBar(headerArea, 0x800100);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)messageToolbar);
        this.addMessageDropDown(headerArea);
        messageSection.setTextClient((Control)headerArea);
        final CommitProposalProcessor commitProposalProcessor = new CommitProposalProcessor(){

            protected Collection<String> computeFileNameProposals() {
                return CommitDialog.this.getFileList();
            }

            protected Collection<String> computeMessageProposals() {
                return CommitMessageHistory.getCommitHistory();
            }
        };
        this.commitText = new CommitMessageArea(messageArea, this.commitMessage, 0){

            protected CommitProposalProcessor getCommitProposalProcessor() {
                return commitProposalProcessor;
            }
        };
        this.commitText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        messageSection.setClient((Control)messageArea);
        Point size = this.commitText.getTextWidget().getSize();
        int minHeight = this.commitText.getTextWidget().getLineHeight() * 3;
        this.commitText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(size).minSize(size.x, minHeight).align(4, 4).create());
        UIUtils.addBulbDecorator((Control)this.commitText.getTextWidget(), (String)UIText.CommitDialog_ContentAssist);
        Composite personArea = this.toolkit.createComposite(messageAndPersonArea);
        this.toolkit.paintBordersFor(personArea);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(personArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)personArea);
        this.toolkit.createLabel(personArea, UIText.CommitDialog_Author).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.authorText = this.toolkit.createText(personArea, null);
        this.authorText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.repository != null && this.repository.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
            this.authorText.setEnabled(false);
        }
        this.toolkit.createLabel(personArea, UIText.CommitDialog_Committer).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.committerText = this.toolkit.createText(personArea, null);
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.committer != null) {
            this.committerText.setText(this.committer);
        }
        this.amendingItem = new ToolItem(messageToolbar, 32);
        this.amendingItem.setSelection(this.amending);
        if (this.amending) {
            this.amendingItem.setEnabled(false);
        } else if (!this.amendAllowed) {
            this.amendingItem.setEnabled(false);
        }
        this.amendingItem.setToolTipText(UIText.CommitDialog_AmendPreviousCommit);
        Image amendImage = UIIcons.AMEND_COMMIT.createImage();
        UIUtils.hookDisposal((Widget)this.amendingItem, (Resource)amendImage);
        this.amendingItem.setImage(amendImage);
        this.signedOffItem = new ToolItem(messageToolbar, 32);
        this.signedOffItem.setToolTipText(UIText.CommitDialog_AddSOB);
        Image signedOffImage = UIIcons.SIGNED_OFF.createImage();
        UIUtils.hookDisposal((Widget)this.signedOffItem, (Resource)signedOffImage);
        this.signedOffItem.setImage(signedOffImage);
        this.changeIdItem = new ToolItem(messageToolbar, 32);
        Image changeIdImage = UIIcons.GERRIT.createImage();
        UIUtils.hookDisposal((Widget)this.changeIdItem, (Resource)changeIdImage);
        this.changeIdItem.setImage(changeIdImage);
        this.changeIdItem.setToolTipText(UIText.CommitDialog_AddChangeIdLabel);
        ICommitMessageComponentNotifications listener = new ICommitMessageComponentNotifications(){

            public void updateSignedOffToggleSelection(boolean selection) {
                CommitDialog.this.signedOffItem.setSelection(selection);
            }

            public void updateChangeIdToggleSelection(boolean selection) {
                CommitDialog.this.changeIdItem.setSelection(selection);
            }

            public void statusUpdated() {
                CommitDialog.this.updateMessage();
            }
        };
        this.commitMessageComponent = new CommitMessageComponent(this.repository, listener);
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.setDefaults();
        this.commitMessageComponent.attachControls(this.commitText, this.authorText, this.committerText);
        this.commitMessageComponent.setCommitMessage(this.commitMessage);
        this.commitMessageComponent.setAuthor(this.author);
        this.commitMessageComponent.setCommitter(this.committer);
        this.commitMessageComponent.setAmending(this.amending);
        this.commitMessageComponent.setFilesToCommit(this.getFileList());
        this.amendingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CommitDialog.this.commitMessageComponent.setAmendingButtonSelection(CommitDialog.this.amendingItem.getSelection());
            }
        });
        this.changeIdItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CommitDialog.this.commitMessageComponent.setChangeIdButtonSelection(CommitDialog.this.changeIdItem.getSelection());
            }
        });
        this.signedOffItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CommitDialog.this.commitMessageComponent.setSignedOffButtonSelection(CommitDialog.this.signedOffItem.getSelection());
            }
        });
        this.commitMessageComponent.updateUI();
        this.commitMessageComponent.enableListeners(true);
        return messageAndPersonArea;
    }

    private static CellLabelProvider createStatusLabelProvider() {
        CommitStatusLabelProvider baseProvider = new CommitStatusLabelProvider();
        ProblemLabelDecorator decorator = new ProblemLabelDecorator(null);
        return new DecoratingStyledCellLabelProvider(baseProvider, (ILabelDecorator)decorator, null){

            public String getToolTipText(Object element) {
                return ((CommitItem)element).status.getText();
            }
        };
    }

    private void updateMessage() {
        if (this.commitButton == null) {
            return;
        }
        String message = null;
        int type = 0;
        String commitMsg = this.commitMessageComponent.getCommitMessage();
        if (commitMsg == null || commitMsg.trim().length() == 0) {
            message = UIText.CommitDialog_Message;
            type = 1;
        } else if (!this.isCommitWithoutFilesAllowed()) {
            message = UIText.CommitDialog_MessageNoFilesSelected;
            type = 1;
        } else {
            CommitMessageComponent.CommitStatus status = this.commitMessageComponent.getStatus();
            message = status.getMessage();
            type = status.getMessageType();
        }
        this.canCommit = type == 2 || type == 0;
        this.commitButton.setEnabled(this.canCommit);
        if (this.canCommit) {
            this.commitButton.setText("Commit and Publish");
            this.commitButton.setEnabled(this.canCommit);
        } else if (this.isAhead) {
            this.commitButton.setText("Publish Only");
            this.commitButton.setEnabled(true);
        } else {
            this.commitButton.setText("Commit and Publish");
            this.commitButton.setEnabled(false);
        }
        if (!this.canCommit && this.isAhead && this.isDirty()) {
            message = String.valueOf(message) + NLS.bind((String)"\nIf you publish now, uncommitted changes will not be present in your OpenShift application {0}", (Object)this.applicationName);
        }
        this.setMessage(message, type);
    }

    private boolean isCommitWithoutFilesAllowed() {
        if (this.filesViewer.getCheckedElements().length > 0) {
            return true;
        }
        if (this.amendingItem.getSelection()) {
            return true;
        }
        return CommitHelper.isCommitWithoutFilesAllowed((Repository)this.repository);
    }

    private Collection<String> getFileList() {
        ArrayList<String> result = new ArrayList<String>();
        for (CommitItem item : this.items) {
            result.add(item.path);
        }
        return result;
    }

    private void updateFileSectionText() {
        this.filesSection.setText(MessageFormat.format(UIText.CommitDialog_Files, this.filesViewer.getCheckedElements().length, this.filesViewer.getTree().getItemCount()));
    }

    private IMenuListener createContextMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!CommitDialog.this.allowToChangeSelection) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.size() == 1 && selection.getFirstElement() instanceof CommitItem) {
                    CommitItem commitItem = (CommitItem)selection.getFirstElement();
                    manager.add((IAction)CommitDialog.this.createCompareAction(commitItem));
                }
                manager.add((IAction)CommitDialog.this.createAddAction(selection));
            }
        };
    }

    private Action createCompareAction(final CommitItem commitItem) {
        return new Action(UIText.CommitDialog_CompareWithHeadRevision){

            public void run() {
                CommitDialog.this.compare(commitItem);
            }
        };
    }

    private Action createAddAction(final IStructuredSelection selection) {
        return new Action(UIText.CommitDialog_AddFileOnDiskToIndex){

            public void run() {
                AddCommand addCommand = new Git(CommitDialog.this.repository).add();
                for (CommitItem commitItem : selection) {
                    addCommand.addFilepattern(commitItem.path);
                }
                try {
                    addCommand.call();
                }
                catch (Exception e) {
                    Activator.logError((String)UIText.CommitDialog_ErrorAddingFiles, (Throwable)e);
                }
                for (CommitItem commitItem : selection) {
                    try {
                        commitItem.status = CommitDialog.this.getFileStatus(commitItem.path);
                    }
                    catch (IOException e) {
                        Activator.logError((String)UIText.CommitDialog_ErrorAddingFiles, (Throwable)e);
                    }
                }
                CommitDialog.this.filesViewer.refresh(true);
            }
        };
    }

    private CommitItem.Status getFileStatus(String path) throws IOException {
        AdaptableFileTreeIterator fileTreeIterator = new AdaptableFileTreeIterator(this.repository, ResourcesPlugin.getWorkspace().getRoot());
        IndexDiff indexDiff = new IndexDiff(this.repository, "HEAD", (WorkingTreeIterator)fileTreeIterator);
        Set<String> repositoryPaths = Collections.singleton(path);
        indexDiff.setFilter(PathFilterGroup.createFromStrings(repositoryPaths));
        indexDiff.diff(null, 0, 0, "");
        return CommitDialog.getFileStatus(path, indexDiff);
    }

    private static CommitItem.Status getFileStatus(String path, IndexDiff indexDiff) {
        if (indexDiff.getAssumeUnchanged().contains(path)) {
            return CommitItem.Status.ASSUME_UNCHANGED;
        }
        if (indexDiff.getAdded().contains(path)) {
            if (indexDiff.getModified().contains(path)) {
                return CommitItem.Status.ADDED_INDEX_DIFF;
            }
            return CommitItem.Status.ADDED;
        }
        if (indexDiff.getChanged().contains(path)) {
            if (indexDiff.getModified().contains(path)) {
                return CommitItem.Status.MODIFIED_INDEX_DIFF;
            }
            return CommitItem.Status.MODIFIED;
        }
        if (indexDiff.getUntracked().contains(path)) {
            if (indexDiff.getRemoved().contains(path)) {
                return CommitItem.Status.REMOVED_UNTRACKED;
            }
            return CommitItem.Status.UNTRACKED;
        }
        if (indexDiff.getRemoved().contains(path)) {
            return CommitItem.Status.REMOVED;
        }
        if (indexDiff.getMissing().contains(path)) {
            return CommitItem.Status.REMOVED_NOT_STAGED;
        }
        if (indexDiff.getModified().contains(path)) {
            return CommitItem.Status.MODIFIED_NOT_STAGED;
        }
        return CommitItem.Status.UNKNOWN;
    }

    private static int getProblemSeverity(Repository repository, String path) {
        IFile file = ResourceUtil.getFileForLocation((Repository)repository, (String)path);
        if (file != null) {
            try {
                int severity = file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1);
                return severity;
            }
            catch (CoreException coreException) {}
        }
        return -1;
    }

    protected void okPressed() {
        if (this.canCommit) {
            if (!this.isCommitWithoutFilesAllowed()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoItemsSelected, (String)UIText.CommitDialog_ErrorNoItemsSelectedToBeCommitted);
                return;
            }
            if (!this.commitMessageComponent.checkCommitInfo()) {
                return;
            }
            Object[] checkedElements = this.filesViewer.getCheckedElements();
            this.selectedFiles.clear();
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                this.selectedFiles.add(((CommitItem)obj).path);
                ++n2;
            }
            this.amending = this.commitMessageComponent.isAmending();
            this.commitMessage = this.commitMessageComponent.getCommitMessage();
            this.author = this.commitMessageComponent.getAuthor();
            this.committer = this.commitMessageComponent.getCommitter();
            this.createChangeId = this.changeIdItem.getSelection();
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put(SHOW_UNTRACKED_PREF, this.showUntracked);
            CommitMessageHistory.saveCommitHistory((String)this.getCommitMessage());
        }
        super.okPressed();
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void compare(CommitItem commitItem) {
        IFile file = this.findFile(commitItem.path);
        if (file == null || RepositoryProvider.getProvider((IProject)file.getProject()) == null) {
            CompareUtils.compareHeadWithWorkingTree((Repository)this.repository, (String)commitItem.path);
        } else {
            CompareUtils.compareHeadWithWorkspace((Repository)this.repository, (IFile)file);
        }
    }

    private IFile findFile(String path) {
        return ResourceUtil.getFileForLocation((Repository)this.repository, (String)path);
    }

    static class CommitFileContentProvider
    extends BaseWorkbenchContentProvider {
        CommitFileContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof Object[]) {
                return (Object[])element;
            }
            if (element instanceof Collection) {
                return ((Collection)element).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private final class CommitItemFilter
    extends ViewerFilter {
        private CommitItemFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            if (!(CommitDialog.this.showUntracked && CommitDialog.this.allowToChangeSelection || !(element instanceof CommitItem))) {
                CommitItem item = (CommitItem)element;
                if (item.status == CommitItem.Status.UNTRACKED) {
                    result = false;
                }
            }
            return result;
        }
    }

    class CommitItemSelectionListener
    extends SelectionAdapter {
        CommitItemSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
            CommitItem commitItem = (CommitItem)selection.getFirstElement();
            if (commitItem == null) {
                return;
            }
            CommitDialog.this.compare(commitItem);
        }
    }

    static class CommitPathLabelProvider
    extends ColumnLabelProvider {
        CommitPathLabelProvider() {
        }

        public String getText(Object obj) {
            return ((CommitItem)obj).path;
        }

        public String getToolTipText(Object element) {
            return ((CommitItem)element).status.getText();
        }
    }

    static class CommitStatusLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private Image DEFAULT = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        private final Image SUBMODULE = UIIcons.REPOSITORY.createImage();

        CommitStatusLabelProvider() {
        }

        private Image getEditorImage(CommitItem item) {
            if (!item.submodule) {
                Image image = this.DEFAULT;
                String name = new Path(item.path).lastSegment();
                if (name != null) {
                    ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
                    image = (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
                }
                return image;
            }
            return this.SUBMODULE;
        }

        private Image getDecoratedImage(Image base, ImageDescriptor decorator) {
            DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, decorator, 3);
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
        }

        public StyledString getStyledText(Object element) {
            return new StyledString();
        }

        public Image getImage(Object element) {
            CommitItem item = (CommitItem)element;
            ImageDescriptor decorator = null;
            switch (item.status) {
                case UNTRACKED: {
                    decorator = UIIcons.OVR_UNTRACKED;
                    break;
                }
                case ADDED: 
                case ADDED_INDEX_DIFF: {
                    decorator = UIIcons.OVR_STAGED_ADD;
                    break;
                }
                case REMOVED: 
                case REMOVED_NOT_STAGED: 
                case REMOVED_UNTRACKED: {
                    decorator = UIIcons.OVR_STAGED_REMOVE;
                    break;
                }
            }
            return decorator != null ? this.getDecoratedImage(this.getEditorImage(item), decorator) : this.getEditorImage(item);
        }

        public void dispose() {
            this.SUBMODULE.dispose();
            this.resourceManager.dispose();
            super.dispose();
        }
    }

    class HeaderSelectionListener
    extends SelectionAdapter {
        private CommitItem.Order order;
        private Boolean reversed;

        public HeaderSelectionListener(CommitItem.Order order) {
            this.order = order;
        }

        public void widgetSelected(SelectionEvent e) {
            Comparator<CommitItem> comparator;
            TreeColumn column = (TreeColumn)e.widget;
            Tree tree = column.getParent();
            if (column == tree.getSortColumn()) {
                int currentDirection = tree.getSortDirection();
                switch (currentDirection) {
                    case 0: {
                        this.reversed = Boolean.FALSE;
                        break;
                    }
                    case 128: {
                        this.reversed = Boolean.TRUE;
                        break;
                    }
                    default: {
                        this.reversed = null;
                        break;
                    }
                }
            } else {
                this.reversed = Boolean.FALSE;
            }
            if (this.reversed == null) {
                tree.setSortColumn(null);
                tree.setSortDirection(0);
                CommitDialog.this.filesViewer.setComparator(null);
                return;
            }
            tree.setSortColumn(column);
            if (this.reversed.booleanValue()) {
                comparator = this.order.descending();
                tree.setSortDirection(1024);
            } else {
                comparator = this.order;
                tree.setSortDirection(128);
            }
            CommitDialog.this.filesViewer.setComparator((ViewerComparator)new CommitViewerComparator(comparator));
        }
    }
}

