/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.portforward;

import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.OpenShiftSSHOperationException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHSessionRepository;

public class PortForwardingWizardModel
extends ObservablePojo {
    public static final String PROPERTY_USE_DEFAULT_LOCAL_IP_ADDRESS = "useDefaultLocalIpAddress";
    public static final String PROPERTY_FORWARDABLE_PORTS = "forwardablePorts";
    public static final String PROPERTY_USE_FREE_PORTS = "useFreePorts";
    public static final String PROPERTY_PORT_FORWARDING = "portForwarding";
    private Boolean useDefaultLocalIpAddress = Boolean.TRUE;
    private Boolean useFreePorts = Boolean.FALSE;
    private final IApplication application;

    public PortForwardingWizardModel(IApplication application) {
        this.application = application;
    }

    public final IApplication getApplication() {
        return this.application;
    }

    public boolean isPortForwardingStarted() {
        return this.application.isPortFowardingStarted();
    }

    public List<IApplicationPortForwarding> getForwardablePorts() throws OpenShiftSSHOperationException {
        return this.application.getForwardablePorts();
    }

    public boolean hasForwardablePorts() {
        return this.application != null && this.application.getForwardablePorts() != null && !this.application.getForwardablePorts().isEmpty();
    }

    public boolean getPortForwarding() throws OpenShiftSSHOperationException {
        return this.application.isPortFowardingStarted();
    }

    public void startPortForwarding() throws OpenShiftSSHOperationException {
        if (this.application.isPortFowardingStarted()) {
            return;
        }
        MessageConsole console = ConsoleUtils.findMessageConsole(this.getMessageConsoleName());
        MessageConsoleStream stream = console.newMessageStream();
        stream.println("Starting port-forwarding...");
        this.application.startPortForwarding();
        for (IApplicationPortForwarding port : this.application.getForwardablePorts()) {
            stream.println(" " + this.getPortStatus(port));
        }
        stream.println("done.");
        ConsoleUtils.displayConsoleView((IConsole)console);
        this.firePropertyChange(PROPERTY_PORT_FORWARDING, false, this.application.isPortFowardingStarted());
    }

    private String getMessageConsoleName() {
        return "Port forwarding for application '" + this.application.getName() + "' (" + this.application.getDomain().getId() + ")";
    }

    public void stopPortForwarding() throws OpenShiftSSHOperationException {
        if (!this.application.isPortFowardingStarted()) {
            return;
        }
        MessageConsole console = ConsoleUtils.findMessageConsole(this.getMessageConsoleName());
        MessageConsoleStream stream = console.newMessageStream();
        stream.println("Stopping port-forwarding...");
        this.application.stopPortForwarding();
        for (IApplicationPortForwarding port : this.application.getForwardablePorts()) {
            stream.println(" " + this.getPortStatus(port));
        }
        stream.println("done.");
        ConsoleUtils.displayConsoleView((IConsole)console);
        this.firePropertyChange(PROPERTY_PORT_FORWARDING, true, this.application.isPortFowardingStarted());
    }

    private String getPortStatus(IApplicationPortForwarding port) throws OpenShiftSSHOperationException {
        return String.valueOf(port.getName()) + " " + port.getLocalAddress() + ":" + port.getLocalPort() + " -> " + port.getRemoteAddress() + ":" + port.getRemotePort() + " " + (port.isStarted(this.application.getSSHSession()) ? "(started)" : "(stopped)");
    }

    public final Boolean getUseDefaultLocalIpAddress() {
        return this.useDefaultLocalIpAddress;
    }

    public final void setUseDefaultLocalIpAddress(Boolean useDefaultLocalIpAddress) throws OpenShiftSSHOperationException {
        this.updateLocalAddressBindings(useDefaultLocalIpAddress);
        this.useDefaultLocalIpAddress = useDefaultLocalIpAddress;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_LOCAL_IP_ADDRESS, this.useDefaultLocalIpAddress, this.useDefaultLocalIpAddress);
    }

    public Boolean getUseFreePorts() {
        return this.useFreePorts;
    }

    public void setUseFreePorts(Boolean useFreePorts) throws OpenShiftSSHOperationException {
        if (!this.application.isPortFowardingStarted()) {
            this.updateLocalPortBindings(useFreePorts);
        }
        this.useFreePorts = useFreePorts;
        this.firePropertyChange(PROPERTY_USE_DEFAULT_LOCAL_IP_ADDRESS, this.useFreePorts, this.useFreePorts);
    }

    private void updateLocalAddressBindings(boolean useLocalIpAddress) throws OpenShiftSSHOperationException {
        List ports = this.application.getForwardablePorts();
        for (IApplicationPortForwarding port : ports) {
            port.setLocalAddress(useLocalIpAddress ? "127.0.0.1" : port.getRemoteAddress());
        }
    }

    private void updateLocalPortBindings(boolean useFreePorts) throws OpenShiftSSHOperationException {
        List ports = this.application.getForwardablePorts();
        ArrayList<String> bindings = new ArrayList<String>();
        for (IApplicationPortForwarding port : ports) {
            if (useFreePorts) {
                port.setLocalPort(SocketUtil.findFreePort());
                continue;
            }
            port.setLocalPort(port.getRemotePort());
            String key = this.computeKey(port);
            while (bindings.contains(key)) {
                port.setLocalPort(SocketUtil.findFreePort());
                key = this.computeKey(port);
            }
            bindings.add(key);
        }
    }

    private String computeKey(IApplicationPortForwarding port) {
        return String.valueOf(port.getLocalAddress()) + ":" + port.getLocalPort();
    }

    public void loadForwardablePorts() throws OpenShiftSSHOperationException {
        this.getApplication().getForwardablePorts();
        this.refreshForwardablePorts();
    }

    public void refreshForwardablePorts() throws OpenShiftSSHOperationException {
        if (!this.application.isPortFowardingStarted()) {
            this.application.refreshForwardablePorts();
            this.updateLocalAddressBindings(this.useDefaultLocalIpAddress);
            this.updateLocalPortBindings(this.useFreePorts);
            this.firePropertyChange(PROPERTY_FORWARDABLE_PORTS, null, this.application.getForwardablePorts());
        }
    }

    boolean verifyApplicationSSHSession() throws OpenShiftSSHOperationException {
        boolean hasAlreadySSHSession = this.getApplication().hasSSHSession();
        if (!hasAlreadySSHSession) {
            Logger.debug("Opening a new SSH Session for application '" + this.getApplication().getName() + "'");
            Session session = SSHSessionRepository.getInstance().getSession(this.getApplication());
            this.getApplication().setSSHSession(session);
        }
        return this.getApplication().hasSSHSession();
    }
}

