/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.ApplicationBuilder;
import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftTimeoutException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.internal.client.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class CreateApplicationJob
extends AbstractDelegatingMonitorJob {
    private String name;
    private ApplicationScale scale;
    private IGearProfile gear;
    private IApplication application;
    private IDomain domain;
    private String initialGitUrl;
    private Map<String, String> environmentVariables;
    private Collection<ICartridge> cartridges;

    public CreateApplicationJob(String name, ApplicationScale scale, IGearProfile gear, ICartridge cartridge, IDomain domain) {
        this(name, scale, gear, null, new LinkedHashMap<String, String>(), Collections.singletonList(cartridge), domain);
    }

    public CreateApplicationJob(String name, ApplicationScale scale, IGearProfile gear, String initialGitUrl, Map<String, String> environmentVariables, Collection<ICartridge> cartridges, IDomain domain) {
        super(NLS.bind((String)(cartridges == null ? ExpressUIMessages.CREATING_APPLICATION : ExpressUIMessages.CREATING_APPLICATION_WITH_EMBEDDED), (Object)name));
        this.name = name;
        this.scale = scale;
        this.gear = gear;
        this.initialGitUrl = initialGitUrl;
        this.domain = domain;
        this.environmentVariables = environmentVariables;
        this.cartridges = cartridges;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            Assert.isLegal((!StringUtils.isEmpty((String)this.name) ? 1 : 0) != 0, (String)"No application name provided.");
            Assert.isLegal((this.domain != null ? 1 : 0) != 0, (String)"No domain provided.");
            Assert.isLegal((this.cartridges != null && this.cartridges.size() >= 1 ? 1 : 0) != 0, (String)"No application type provided.");
            try {
                this.application = ((ApplicationBuilder.NamedUnTypedCartridgeBuilder)((ApplicationBuilder.NamedUnTypedCartridgeBuilder)((ApplicationBuilder.NamedUnTypedCartridgeBuilder)((ApplicationBuilder.NamedUnTypedCartridgeBuilder)new ApplicationBuilder(this.domain).setName(this.name).setCartridges(this.cartridges).setGearProfile(this.gear)).setApplicationScale(this.scale)).setEnvironmentVariables(this.environmentVariables)).setInitialGitUrl(this.initialGitUrl)).build();
                return new Status(0, "org.jboss.tools.openshift.express.ui", 0, "timeouted", null);
            }
            catch (OpenShiftTimeoutException openShiftTimeoutException) {
                this.application = this.refreshAndCreateApplication(monitor);
                if (this.application != null) {
                    return new Status(0, "org.jboss.tools.openshift.express.ui", 1, "timeouted", null);
                }
                return new Status(8, "org.jboss.tools.openshift.express.ui", 1, "timeouted", null);
            }
        }
        catch (Exception e) {
            this.safeRefreshDomain();
            return ExpressUIActivator.createErrorStatus(ExpressUIMessages.COULD_NOT_CREATE_APPLICATION, e, StringUtils.nullToEmptyString((String)this.name));
        }
    }

    private IApplication refreshAndCreateApplication(IProgressMonitor monitor) throws OpenShiftException {
        if (monitor.isCanceled()) {
            return null;
        }
        IApplication application = null;
        do {
            try {
                this.domain.refresh();
                application = this.domain.getApplicationByName(this.name);
                if (application != null) continue;
                application = ((ApplicationBuilder.NamedUnTypedCartridgeBuilder)((ApplicationBuilder.NamedUnTypedCartridgeBuilder)((ApplicationBuilder.NamedUnTypedCartridgeBuilder)new ApplicationBuilder(this.domain).setName(this.name).setCartridges(this.cartridges).setGearProfile(this.gear)).setInitialGitUrl(this.initialGitUrl)).setEnvironmentVariables(this.environmentVariables)).build();
            }
            catch (OpenShiftTimeoutException openShiftTimeoutException) {}
        } while (application == null && this.openKeepTryingDialog() && !monitor.isCanceled());
        return application;
    }

    private void safeRefreshDomain() {
        try {
            this.domain.refresh();
        }
        catch (OpenShiftException e) {
            ExpressUIActivator.log(e);
        }
    }

    public IApplication getApplication() {
        return this.application;
    }

    public List<IEmbeddedCartridge> getAddedCartridges() {
        return this.application.getEmbeddedCartridges();
    }

    protected boolean openKeepTryingDialog() {
        final AtomicBoolean keepTrying = new AtomicBoolean(false);
        final Display display = Display.getDefault();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(display.getActiveShell(), NLS.bind((String)"Creating {0}", (Object)CreateApplicationJob.this.name), display.getSystemImage(4), NLS.bind((String)"Could not create application {0}. ExpressConnection timed out.\n\nKeep trying?", (Object)CreateApplicationJob.this.name), 3, new String[]{"Keep trying", ExpressUIMessages.BTN_CLOSE_WIZARD}, 3);
                keepTrying.set(dialog.open() == 0);
            }
        });
        return keepTrying.get();
    }
}

