/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.explorer;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.List;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.explorer.OpenShiftExplorerContentCategory;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;

public class ExpressExplorerContentProvider
extends BaseExplorerContentProvider {
    protected void handleConnectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
        if (!(connection instanceof ExpressConnection)) {
            return;
        }
        super.handleConnectionChanged(connection, property, oldValue, newValue);
    }

    protected void handleConnectionRemoved(IConnection connection) {
        if (!(connection instanceof ExpressConnection)) {
            return;
        }
        super.handleConnectionRemoved(connection);
    }

    public Object[] getExplorerElements(Object parentElement) {
        if (parentElement instanceof ConnectionsRegistry) {
            ConnectionsRegistry registry = (ConnectionsRegistry)parentElement;
            return registry.getAll(ExpressConnection.class).toArray();
        }
        if (parentElement instanceof ExpressConnection) {
            List domains = ((ExpressConnection)parentElement).getDomains();
            return domains.toArray(new IDomain[domains.size()]);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ExpressConnection) {
            ExpressConnection connection = (ExpressConnection)parentElement;
            if (!connection.isConnected() && !connection.canPromptForPassword()) {
                return new Object[]{new BaseExplorerContentProvider.NotConnectedUserStub()};
            }
            return this.loadChildren(parentElement);
        }
        if (parentElement instanceof IDomain) {
            return this.loadChildren(parentElement);
        }
        if (parentElement instanceof IApplication) {
            return this.loadChildren(parentElement);
        }
        return this.getChildrenFor(parentElement);
    }

    protected Object[] getChildrenFor(Object parentElement) {
        Object[] children = new Object[]{};
        try {
            if (parentElement instanceof OpenShiftExplorerContentCategory) {
                ExpressConnection user = ((OpenShiftExplorerContentCategory)parentElement).getUser();
                children = new Object[]{user};
            } else if (parentElement instanceof ExpressConnection) {
                ExpressConnection connection = (ExpressConnection)parentElement;
                children = connection.getDomains().toArray();
            } else if (parentElement instanceof IDomain) {
                IDomain domain = (IDomain)parentElement;
                children = domain.getApplications().toArray();
            } else if (parentElement instanceof IApplication) {
                children = ((IApplication)parentElement).getEmbeddedCartridges().toArray();
            }
        }
        catch (OpenShiftException e) {
            this.addException(parentElement, (Exception)((Object)e));
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ConnectionsRegistry || element instanceof IConnection || element instanceof IDomain || element instanceof IApplication;
    }
}

