/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.console;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.ui.console.MessageConsole;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class TailServerLogWorker
implements Runnable {
    private final Process process;
    private final MessageConsole console;
    private final RemoteSession remoteSession;

    public TailServerLogWorker(MessageConsole console, Process process, RemoteSession remoteSession) {
        this.console = console;
        this.process = process;
        this.remoteSession = remoteSession;
    }

    @Override
    public void run() {
        try {
            String line;
            InputStream in = this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                this.console.newMessageStream().println(line);
            }
        }
        catch (Throwable e) {
            Logger.error("Error while receiving the remote server adapter log", e);
            this.console.newMessageStream().println("Error while receiving the remote server adapter log: " + e.getMessage());
        }
    }

    public void stop() {
        this.remoteSession.disconnect();
        this.process.destroy();
    }
}

