/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.console;

import com.openshift.client.IGearGroup;
import com.openshift.client.NotFoundOpenShiftException;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.console.GearGroupsUtils;
import org.jboss.tools.openshift.express.internal.ui.console.TailFilesWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class TailFilesWizardPage
extends AbstractOpenShiftWizardPage {
    private final TailFilesWizardPageModel pageModel;
    private CheckboxTableViewer viewer;

    public TailFilesWizardPage(TailFilesWizardPageModel pageModel, IWizard wizard) {
        super("Tail Log Files", "This will run tail on your OpenShift application '" + pageModel.getApplication().getName() + "'.\nYou can use the defaults or change the tail options.", "TailFilePage", wizard);
        this.pageModel = pageModel;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(parent);
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        Label filePatternLabel = new Label(container, 0);
        filePatternLabel.setText("Tail options:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)filePatternLabel);
        Text filePatternText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)filePatternText);
        ISWTObservableValue filePatternTextObservable = WidgetProperties.text((int)24).observe((Widget)filePatternText);
        IObservableValue filePatternModelObservable = BeanProperties.value((String)"filePattern").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)filePatternTextObservable).to(filePatternModelObservable).in(dbc);
        Button resetButton = new Button(container, 8);
        resetButton.setText("Reset");
        GridDataFactory.fillDefaults().hint(100, -1).span(1, 1).align(4, 0x1000000).grab(false, false).applyTo((Control)resetButton);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TailFilesWizardPage.this.pageModel.resetFilePattern();
            }
        });
        Composite gearsSelectionContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(3, 1).applyTo((Control)gearsSelectionContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(gearsSelectionContainer);
        Label selectGearsLabel = new Label(gearsSelectionContainer, 0);
        selectGearsLabel.setText("Please, select the gears on which you want to tail files:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)selectGearsLabel);
        Composite tableContainer = new Composite(gearsSelectionContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(1, 2).applyTo((Control)tableContainer);
        this.viewer = this.createTable(tableContainer);
        dbc.bindSet((IObservableSet)ViewerProperties.checkedElements(IGearGroup.class).observe((Viewer)this.viewer), BeanProperties.set((String)"selectedGearGroups").observe((Object)this.pageModel));
        Button selectAllButton = new Button(gearsSelectionContainer, 8);
        selectAllButton.setText("Select all");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TailFilesWizardPage.this.pageModel.selectAllGears();
            }
        });
        GridDataFactory.fillDefaults().hint(100, -1).align(4, 128).grab(false, false).applyTo((Control)selectAllButton);
        Button deselectAllButton = new Button(gearsSelectionContainer, 8);
        deselectAllButton.setText("Deselect all");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TailFilesWizardPage.this.pageModel.deselectAllGears();
            }
        });
        GridDataFactory.fillDefaults().hint(100, -1).align(4, 128).grab(false, false).applyTo((Control)deselectAllButton);
    }

    private CheckboxTableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68384);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableColumn("Cartridges", 5, 16384, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IGearGroup gearGroup = (IGearGroup)cell.getElement();
                String cartridgeNames = GearGroupsUtils.getCartridgeDisplayNames(gearGroup);
                cell.setText(cartridgeNames);
            }
        }, (TableViewer)viewer, tableLayout);
        this.createTableColumn("Number of Gears", 3, 131072, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IGearGroup gearGroup = (IGearGroup)cell.getElement();
                cell.setText(Integer.toString(gearGroup.getGears().size()));
            }
        }, (TableViewer)viewer, tableLayout);
        this.createTableColumn("", 1, 131072, new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        }, (TableViewer)viewer, tableLayout);
        return viewer;
    }

    private void createTableColumn(String name, int weight, int alignment, CellLabelProvider cellLabelProvider, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(name);
        column.getColumn().setAlignment(alignment);
        if (cellLabelProvider != null) {
            column.setLabelProvider(cellLabelProvider);
        }
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    protected void onPageActivated(DataBindingContext dbc) {
        try {
            this.loadApplicationGearGroups(dbc);
        }
        catch (Exception e) {
            Logger.error("Could not reset File Pattern text field", e);
        }
    }

    private void loadApplicationGearGroups(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new Job("Loading gear groups for application '" + this.pageModel.getApplication().getName() + "'..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        TailFilesWizardPage.this.pageModel.loadGearGroups();
                        TailFilesWizardPage.this.setViewerInput(TailFilesWizardPage.this.pageModel.getGearGroups());
                        return Status.OK_STATUS;
                    }
                    catch (NotFoundOpenShiftException notFoundOpenShiftException) {
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return ExpressUIActivator.createErrorStatus("Could not load application's gear list", e);
                    }
                }
            }, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (Exception exception) {}
    }

    private void setViewerInput(final Collection<IGearGroup> gearGroups) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (TailFilesWizardPage.this.viewer != null) {
                    TailFilesWizardPage.this.viewer.setInput((Object)gearGroups);
                }
            }
        });
    }
}

