/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.command.AbstractDomainHandler;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EditEnvironmentVariablesWizard;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class EditEnvironmentVariablesHandler
extends AbstractDomainHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IApplication application = (IApplication)UIUtils.getFirstElement((ISelection)selection, IApplication.class);
        if (application != null) {
            return this.openEnvironmentVariablesWizard(application, HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        IServer server = (IServer)UIUtils.getFirstElement((ISelection)selection, IServer.class);
        if (server == null) {
            return null;
        }
        return this.openEnvironmentVariablesWizard(server, HandlerUtil.getActiveShell((ExecutionEvent)event));
    }

    private Object openEnvironmentVariablesWizard(IApplication application, Shell shell) {
        try {
            WizardUtils.openWizardDialog((IWizard)new EditEnvironmentVariablesWizard(application), (Shell)shell);
            return null;
        }
        catch (OpenShiftException e) {
            Logger.error("Failed to edit cartridges", e);
            return ExpressUIActivator.createErrorStatus("Failed to edit cartridges", e);
        }
    }

    private Object openEnvironmentVariablesWizard(IServer server, final Shell shell) {
        final LoadApplicationJob job = new LoadApplicationJob(server);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getJob().getResult().isOK()) {
                    return;
                }
                final IApplication application = job.getApplication();
                if (application == null) {
                    return;
                }
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EditEnvironmentVariablesHandler.this.openEnvironmentVariablesWizard(application, shell);
                    }
                });
            }
        });
        job.schedule();
        return null;
    }
}

