/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.util.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.core.tasks.TaskModel;
import org.jboss.tools.runtime.core.extract.ExtractUtility;
import org.jboss.tools.runtime.core.extract.IOverwrite;

public class DownloadRuntimeOperationUtility {
    private static final String SEPARATOR = "/";

    protected File getNextUnusedFilename(File destination, String name) {
        String nameWithoutSuffix = null;
        nameWithoutSuffix = name.indexOf(46) == -1 ? name : (name.endsWith(".tar.gz") ? name.substring(0, name.length() - ".tar.gz".length()) : name.substring(0, name.lastIndexOf(46)));
        String suffix = name.substring(nameWithoutSuffix.length());
        int i = 1;
        String tmpName = null;
        File file = new File(destination, name);
        while (file.exists()) {
            tmpName = String.valueOf(nameWithoutSuffix) + "(" + i++ + ")" + suffix;
            file = new File(destination, tmpName);
        }
        return file;
    }

    private File getDestinationFile(String downloadDestinationPath, String urlString, boolean deleteOnExit) throws CoreException {
        File ret = null;
        try {
            URL url = new URL(urlString);
            String name = url.getPath();
            int slashIdx = name.lastIndexOf(47);
            if (slashIdx >= 0) {
                name = name.substring(slashIdx + 1);
            }
            File destination = new File(downloadDestinationPath);
            destination.mkdirs();
            ret = new File(destination, name);
            if (deleteOnExit) {
                ret = this.getNextUnusedFilename(destination, name);
            }
            if (deleteOnExit) {
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (IOException e) {
            this.cancel(ret);
            Status s = new Status(4, "org.jboss.tools.runtime.core", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }

    private boolean cacheOutdated(File local, boolean deleteOnExit, long urlLastModified) {
        boolean download = true;
        long urlModified = 0L;
        if (!deleteOnExit) {
            long cacheModified = local.lastModified();
            download = cacheModified <= 0L || cacheModified != urlModified;
        }
        return download;
    }

    private long getRemoteURLModified(String urlString, String user, String pass, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("Checking remote timestamp", 100);
        long l = new URLTransportUtility().getLastModified(new URL(urlString), user, pass, monitor);
        monitor.worked(100);
        monitor.done();
        return l;
    }

    private void validateInputs(String downloadDirectoryPath, String unzipDirectoryPath) throws CoreException {
        File downloadDirectory = new File(downloadDirectoryPath);
        downloadDirectory.mkdirs();
        if (!downloadDirectory.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", "The '" + downloadDirectory + "' is not a directory."));
        }
        File unzipDirectory = new File(unzipDirectoryPath);
        unzipDirectory.mkdirs();
        if (!unzipDirectory.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", "The '" + unzipDirectory + "' is not a directory."));
        }
    }

    public File download(String unzipDirectoryPath, String downloadDirectoryPath, String urlString, boolean deleteOnExit, String user, String pass, TaskModel tm, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Download runtime from url " + urlString, 500);
        try {
            File downloadedFile;
            this.validateInputs(downloadDirectoryPath, unzipDirectoryPath);
            File file = downloadedFile = this.downloadRemoteRuntime(unzipDirectoryPath, downloadDirectoryPath, urlString, deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            return file;
        }
        finally {
            monitor.done();
        }
    }

    public IStatus downloadAndUnzip(String unzipDirectoryPath, String downloadDirectoryPath, String urlString, boolean deleteOnExit, String user, String pass, TaskModel tm, IProgressMonitor monitor) {
        monitor.beginTask("Configuring runtime from url " + urlString, 500);
        try {
            try {
                this.validateInputs(downloadDirectoryPath, unzipDirectoryPath);
                File downloadedFile = this.downloadRemoteRuntime(unzipDirectoryPath, downloadDirectoryPath, urlString, deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 450));
                ExtractUtility extractUtil = new ExtractUtility(downloadedFile);
                IOverwrite ow = (IOverwrite)tm.getObject("dl.runtime.overwrite");
                if (ow == null) {
                    ow = this.createOverwriteFileQuery();
                }
                this.unzip(extractUtil, downloadedFile, unzipDirectoryPath, ow, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                String updatedRuntimeRoot = this.getUpdatedUnzipPath(extractUtil, unzipDirectoryPath, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                tm.putObject("dl.runtime.unzipped.home.dir", (Object)updatedRuntimeRoot);
            }
            catch (CoreException ce) {
                IStatus iStatus = ce.getStatus();
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private File downloadRemoteRuntime(String unzipDirectoryPath, String destinationDirectory, String urlString, boolean deleteOnExit, String user, String pass, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Downloading " + urlString, 1000);
        File file = null;
        try {
            file = this.getDestinationFile(destinationDirectory, urlString, deleteOnExit);
            long urlModified = 0L;
            if (!deleteOnExit) {
                try {
                    urlModified = this.getRemoteURLModified(urlString, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            }
            boolean download = this.cacheOutdated(file, deleteOnExit, urlModified);
            IStatus result = null;
            if (download) {
                result = this.downloadFileFromRemoteUrl(file, new URL(urlString), urlModified, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
            }
            if (!result.isOK()) {
                throw new CoreException(result);
            }
            if (monitor.isCanceled()) {
                throw new CoreException(this.cancel(file));
            }
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            this.cancel(file);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.runtime.core", e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void unzip(ExtractUtility util, File downloadedFile, String unzipDirectoryPath, IOverwrite overwriteQuery, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Unzipping " + downloadedFile.getAbsolutePath(), 1000);
        if (monitor.isCanceled()) {
            throw new CoreException(this.cancel(downloadedFile));
        }
        IStatus status = util.extract(new File(unzipDirectoryPath), overwriteQuery, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        if (monitor.isCanceled()) {
            throw new CoreException(this.cancel(downloadedFile));
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private IStatus cancel(File f) {
        if (f != null) {
            f.deleteOnExit();
            f.delete();
        }
        return Status.CANCEL_STATUS;
    }

    private IOverwrite createOverwriteFileQuery() {
        return new IOverwrite(){

            @Override
            public int overwrite(File file) {
                return 0;
            }
        };
    }

    private String getUpdatedUnzipPath(ExtractUtility util, String unzipDirectoryPath, IProgressMonitor monitor) throws CoreException {
        try {
            File rootFile;
            String root = util.getExtractedRootFolder((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (root != null && (rootFile = new File(unzipDirectoryPath, root)) != null && rootFile.exists()) {
                unzipDirectoryPath = rootFile.getAbsolutePath();
            }
            String string = unzipDirectoryPath;
            return string;
        }
        catch (CoreException ce) {
            this.cancel(util.getOriginalFile());
            throw ce;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus downloadFileFromRemoteUrl(File toFile, URL url, long remoteUrlModified, String user, String pass, IProgressMonitor monitor) throws IOException {
        IStatus iStatus;
        block8: {
            OutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(toFile));
                IStatus result = new URLTransportUtility().download(toFile.getName(), url.toExternalForm(), user, pass, out, -1, monitor);
                out.flush();
                out.close();
                if (remoteUrlModified > 0L) {
                    toFile.setLastModified(remoteUrlModified);
                }
                iStatus = result;
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return iStatus;
    }
}

