/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BP4200
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();

    public BP4200(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(ExtensibilityElement obj, Object parent, WSDLTraversalContext ctx) {
        if (!(parent instanceof Types || obj.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/") || obj.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/"))) {
            this.errorList.add(obj.getElementType());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitExtensibilityElement(true);
        traversal.visitElement(true);
        traversal.ignoreImport();
        traversal.ignoreReferences();
        traversal.traverse(definition);
        try {
            Document doc = this.validator.parseXMLDocumentURL(definition.getDocumentBaseURI(), null);
            if (doc != null) {
                this.checkElement(doc.getDocumentElement());
                if (this.errorList.isEmpty()) {
                    this.result = "notApplicable";
                } else {
                    this.failureDetail = this.validator.createFailureDetail(String.valueOf(testAssertion.getDetailDescription()) + "\n\n" + this.errorList.toString(), entryContext);
                }
            }
        }
        catch (Throwable throwable) {}
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void checkElement(Element elem) {
        while (elem != null) {
            String elemNS = elem.getNamespaceURI();
            NamedNodeMap attrs = elem.getAttributes();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    String attrNS = attr.getNamespaceURI();
                    if (!(attrNS == null || attrNS.equals("http://www.w3.org/2000/xmlns/") || attrNS.equals("http://schemas.xmlsoap.org/wsdl/") || attrNS.equals("http://schemas.xmlsoap.org/wsdl/soap/"))) {
                        this.errorList.add("Extensibility attribute " + attr.getName() + "for the " + elem.getNodeName() + " element is found.");
                    }
                    ++i;
                }
            }
            if (!elemNS.equals("http://www.w3.org/2001/XMLSchema")) {
                this.checkElement(XMLUtils.getFirstChild(elem));
            }
            elem = XMLUtils.getNextSibling(elem);
        }
    }
}

