/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.maven.conversion.core.DependencyCollector;
import org.jboss.tools.maven.conversion.core.ProjectDependency;
import org.jboss.tools.maven.conversion.ui.dialog.ConversionWizardDialog;
import org.jboss.tools.maven.conversion.ui.dialog.ConvertToMavenDependencyWizard;

public abstract class AbstractReferenceConversionParticipant
extends AbstractProjectConversionParticipant {
    public static final String REFERENCE_CONVERSION_SKIP_KEY = "org.jboss.tools.reference.conversion.skip";
    private DependencyCollector dependencyCollector;

    public AbstractReferenceConversionParticipant(DependencyCollector dependencyCollector) {
        this.dependencyCollector = dependencyCollector;
    }

    public boolean accept(IProject project) throws CoreException {
        return !Boolean.getBoolean(REFERENCE_CONVERSION_SKIP_KEY) && this.dependencyCollector != null && this.dependencyCollector.appliesTo(project);
    }

    public void convert(IProject project, final Model model, IProgressMonitor monitor) throws CoreException {
        if (this.dependencyCollector != null && this.dependencyCollector.appliesTo(project)) {
            List<ProjectDependency> entries = this.dependencyCollector.collectDependencies(project);
            if (entries == null || entries.isEmpty()) {
                return;
            }
            final ConvertToMavenDependencyWizard conversionWizard = new ConvertToMavenDependencyWizard(project, entries);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    List<Dependency> dependencies;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ConversionWizardDialog dialog = new ConversionWizardDialog(shell, (IWizard)conversionWizard);
                    if (dialog.open() == 0 && (dependencies = conversionWizard.getDependencies()) != null && !dependencies.isEmpty()) {
                        model.setDependencies(dependencies);
                    }
                }
            });
        }
    }
}

