/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.jboss.tools.maven.conversion.core.DependencyCollector;
import org.jboss.tools.maven.conversion.core.ProjectDependency;
import org.jboss.tools.maven.conversion.core.internal.ComponentDependency;

public class ComponentDependencyCollector
extends DependencyCollector {
    @Override
    public List<ProjectDependency> collectDependencies(IProject project) throws CoreException {
        if (!this.appliesTo(project)) {
            return null;
        }
        ArrayList<ProjectDependency> moduleDependencies = new ArrayList<ProjectDependency>();
        this.collectReferences(project, moduleDependencies);
        return moduleDependencies;
    }

    private void collectReferences(IProject project, List<ProjectDependency> moduleDependencies) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (boolean)true);
        if (component == null) {
            return;
        }
        IVirtualReference[] references = component.getReferences();
        if (references == null || references.length == 0) {
            return;
        }
        IVirtualReference[] iVirtualReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference r = iVirtualReferenceArray[n2];
            moduleDependencies.add(new ComponentDependency(r.getReferencedComponent()));
            ++n2;
        }
    }

    @Override
    public boolean appliesTo(IProject project) throws CoreException {
        return project != null && ModuleCoreNature.isFlexibleProject((IProject)project) && !project.hasNature("org.eclipse.jdt.core.javanature");
    }
}

