/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import java.util.EventListener;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComboModelAdapter<E> {
    protected final ListValueModel<E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final ModifiablePropertyValueModel<E> selectedItemHolder;
    protected final PropertyChangeListener selectedItemChangeListener;
    protected Transformer<E, String> transformer;
    protected final ComboHolder comboHolder;
    protected ModifyListener comboModifyListener;
    protected SelectionListener comboSelectionListener;
    protected final ListenerList<SelectionChangeListener> selectionChangeListenerList;
    protected final ListenerList<DoubleClickListener> doubleClickListenerList;
    protected final DisposeListener comboDisposeListener;

    protected AbstractComboModelAdapter(ListValueModel<E> listHolder, ModifiablePropertyValueModel<E> selectedItemHolder, ComboHolder comboHolder, Transformer<E, String> transformer) {
        Assert.isNotNull(listHolder, (String)"The holder of the items");
        Assert.isNotNull(selectedItemHolder, (String)"The holder of the selected item cannot be null");
        Assert.isNotNull((Object)comboHolder, (String)"The holder of the combo widget cannot be null");
        Assert.isNotNull(transformer, (String)"The string converter cannot be null");
        this.listHolder = listHolder;
        this.selectedItemHolder = selectedItemHolder;
        this.comboHolder = comboHolder;
        this.transformer = transformer;
        this.listChangeListener = this.buildListChangeListener();
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.selectedItemChangeListener = this.buildSelectedItemChangeListener();
        this.selectedItemHolder.addPropertyChangeListener("value", this.selectedItemChangeListener);
        if (this.comboHolder.isEditable()) {
            this.comboModifyListener = this.buildComboModifyListener();
            this.comboHolder.addModifyListener(this.comboModifyListener);
        } else {
            this.comboSelectionListener = this.buildComboSelectionListener();
            this.comboHolder.addSelectionListener(this.comboSelectionListener);
        }
        this.selectionChangeListenerList = this.buildSelectionChangeListenerList();
        this.doubleClickListenerList = this.buildDoubleClickListenerList();
        this.comboDisposeListener = this.buildComboDisposeListener();
        this.comboHolder.addDisposeListener(this.comboDisposeListener);
        this.synchronizeCombo();
    }

    protected ListChangeListener buildListChangeListener() {
        return SWTListenerTools.wrap(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                AbstractComboModelAdapter.this.listItemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                AbstractComboModelAdapter.this.listItemsRemoved(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                AbstractComboModelAdapter.this.listItemsMoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                AbstractComboModelAdapter.this.listItemsReplaced(event);
            }

            public void listCleared(ListClearEvent event) {
                AbstractComboModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                AbstractComboModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    protected PropertyChangeListener buildSelectedItemChangeListener() {
        return SWTListenerTools.wrap(this.buildSelectedItemChangeListener_());
    }

    protected PropertyChangeListener buildSelectedItemChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                AbstractComboModelAdapter.this.selectedItemChanged(e);
            }
        };
    }

    protected ModifyListener buildComboModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractComboModelAdapter.this.comboSelectionChanged(event);
            }

            public String toString() {
                return "combo modify listener";
            }
        };
    }

    protected SelectionListener buildComboSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractComboModelAdapter.this.comboSelectionChanged(event);
            }

            public String toString() {
                return "combo modify listener";
            }
        };
    }

    protected ListenerList<DoubleClickListener> buildDoubleClickListenerList() {
        return new ListenerList(DoubleClickListener.class);
    }

    protected ListenerList<SelectionChangeListener> buildSelectionChangeListenerList() {
        return new ListenerList(SelectionChangeListener.class);
    }

    protected DisposeListener buildComboDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractComboModelAdapter.this.comboDisposed(event);
            }

            public String toString() {
                return "combo dispose listener";
            }
        };
    }

    protected void synchronizeCombo() {
        this.synchronizeComboItems();
        this.synchronizeComboSelection();
    }

    public void setStringConverter(Transformer<E, String> transformer) {
        Assert.isNotNull(transformer, (String)"The StringConverter cannot be null");
        this.transformer = transformer;
        this.synchronizeCombo();
    }

    protected String convert(E item) {
        return (String)this.transformer.transform(item);
    }

    protected void synchronizeComboItems() {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        int len = this.listHolder.size();
        String[] items = new String[len];
        int index = 0;
        while (index < len) {
            items[index] = this.convert(this.listHolder.get(index));
            ++index;
        }
        try {
            this.comboHolder.setPopulating(true);
            this.comboHolder.setItems(items);
        }
        finally {
            this.comboHolder.setPopulating(false);
        }
    }

    protected void listItemsAdded(ListAddEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        this.comboHolder.getItemCount();
        int index = event.getIndex();
        for (E item : this.getItems(event)) {
            this.comboHolder.add(this.convert(item), index++);
        }
        this.synchronizeComboSelection();
    }

    protected void listItemsRemoved(ListRemoveEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        this.comboHolder.setPopulating(true);
        try {
            this.comboHolder.remove(event.getIndex(), event.getIndex() + event.getItemsSize() - 1);
        }
        finally {
            this.comboHolder.setPopulating(false);
        }
    }

    protected void listItemsMoved(ListMoveEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        int target = event.getTargetIndex();
        int source = event.getSourceIndex();
        int len = event.getLength();
        int loStart = Math.min(target, source);
        int hiStart = Math.max(target, source);
        Object[] subArray = (String[])ArrayTools.subArray((Object[])this.comboHolder.getItems(), (int)loStart, (int)(hiStart + len - loStart));
        subArray = (String[])ArrayTools.move((Object[])subArray, (int)(target - loStart), (int)(source - loStart), (int)len);
        int index = 0;
        while (index < subArray.length) {
            this.comboHolder.setItem(loStart + index, (String)subArray[index]);
            ++index;
        }
    }

    protected void listItemsReplaced(ListReplaceEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        int index = event.getIndex();
        int selectionIndex = this.comboHolder.getSelectionIndex();
        this.comboHolder.setPopulating(true);
        try {
            for (E item : this.getNewItems(event)) {
                this.comboHolder.setItem(index++, this.convert(item));
            }
            if (selectionIndex == 0) {
                this.comboHolder.setText(this.comboHolder.getItems()[0]);
            }
        }
        finally {
            this.comboHolder.setPopulating(false);
        }
    }

    protected void listCleared(ListClearEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        this.comboHolder.setPopulating(true);
        try {
            this.comboHolder.removeAll();
        }
        finally {
            this.comboHolder.setPopulating(false);
        }
    }

    protected void listChanged(ListChangeEvent event) {
        this.synchronizeCombo();
    }

    protected Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    protected int indexOf(E item) {
        int length = this.listHolder.size();
        int index = 0;
        while (index < length) {
            if (this.valuesAreEqual(this.listHolder.get(index), item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected void synchronizeComboSelection() {
        if (this.comboHolder.isDisposed() || this.comboHolder.isPopulating()) {
            return;
        }
        Object selectedValue = this.selectedItemHolder.getValue();
        if (this.comboHolder.getText().equals(selectedValue)) {
            return;
        }
        this.comboHolder.setPopulating(true);
        try {
            this.comboHolder.deselectAll();
            String selectedItem = this.convert(selectedValue);
            if (selectedItem == null) {
                selectedItem = "";
            }
            this.comboHolder.setText(selectedItem);
            this.notifyListeners(selectedValue);
        }
        finally {
            this.comboHolder.setPopulating(false);
        }
    }

    protected void selectedItemChanged(PropertyChangeEvent event) {
        this.synchronizeComboSelection();
    }

    protected final boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    protected void comboSelectionChanged(SelectionEvent event) {
        this.selectionChanged();
    }

    protected void comboSelectionChanged(ModifyEvent event) {
        this.selectionChanged();
    }

    protected void selectionChanged() {
        if (!this.comboHolder.isPopulating()) {
            E selectedItem = this.selectedItem();
            this.comboHolder.setPopulating(true);
            try {
                this.selectedItemHolder.setValue(selectedItem);
                this.notifyListeners(selectedItem);
            }
            finally {
                this.comboHolder.setPopulating(false);
            }
        }
    }

    private void notifyListeners(E selectedItem) {
        if (this.selectionChangeListenerList.size() > 0) {
            SelectionChangeEvent<E> scEvent = new SelectionChangeEvent<E>(this, selectedItem);
            for (SelectionChangeListener selectionChangeListener : this.selectionChangeListenerList) {
                selectionChangeListener.selectionChanged(scEvent);
            }
        }
    }

    protected E selectedItem() {
        if (this.comboHolder.isDisposed()) {
            return null;
        }
        if (this.comboHolder.isEditable()) {
            String text = this.comboHolder.getText();
            if (text.length() == 0) {
                return null;
            }
            int index = this.listHolder.size();
            while (--index >= 0) {
                Object item = this.listHolder.get(index);
                String value = this.convert(item);
                if (!this.valuesAreEqual(text, value)) continue;
                return (E)item;
            }
            try {
                return (E)text;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        int index = this.comboHolder.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return (E)this.listHolder.get(index);
    }

    protected void comboDoubleClicked(SelectionEvent event) {
        if (this.comboHolder.isDisposed()) {
            return;
        }
        if (this.doubleClickListenerList.size() > 0) {
            Object selection = this.listHolder.get(this.comboHolder.getSelectionIndex());
            DoubleClickEvent<Object> dcEvent = new DoubleClickEvent<Object>(this, selection);
            for (DoubleClickListener doubleClickListener : this.doubleClickListenerList) {
                doubleClickListener.doubleClick(dcEvent);
            }
        }
    }

    protected void comboDisposed(DisposeEvent event) {
        this.comboHolder.removeDisposeListener(this.comboDisposeListener);
        if (this.comboHolder.isEditable()) {
            this.comboHolder.removeModifyListener(this.comboModifyListener);
        } else {
            this.comboHolder.removeSelectionListener(this.comboSelectionListener);
        }
        this.selectedItemHolder.removePropertyChangeListener("value", this.selectedItemChangeListener);
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.listHolder);
    }

    public void addDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListenerList.add(listener);
    }

    public void removeDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListenerList.remove(listener);
    }

    public void addSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListenerList.add(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListenerList.remove(listener);
    }

    protected static interface ComboHolder {
        public void add(String var1, int var2);

        public void addDisposeListener(DisposeListener var1);

        public void addModifyListener(ModifyListener var1);

        public void addSelectionListener(SelectionListener var1);

        public void deselectAll();

        public int getItemCount();

        public String[] getItems();

        public int getSelectionIndex();

        public String getText();

        public boolean isDisposed();

        public boolean isEditable();

        public boolean isPopulating();

        public void removeDisposeListener(DisposeListener var1);

        public void removeModifyListener(ModifyListener var1);

        public void removeSelectionListener(SelectionListener var1);

        public void setItem(int var1, String var2);

        public void setItems(String[] var1);

        public void setPopulating(boolean var1);

        public void setText(String var1);

        public void remove(int var1, int var2);

        public void removeAll();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleClickEvent<E>
    extends EventObject {
        private final E selection;
        private static final long serialVersionUID = 1L;

        protected DoubleClickEvent(AbstractComboModelAdapter<E> source, E selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public AbstractComboModelAdapter<E> getSource() {
            return (AbstractComboModelAdapter)super.getSource();
        }

        public E selection() {
            return this.selection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleClickListener<E>
    extends EventListener {
        public void doubleClick(DoubleClickEvent<E> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectionChangeEvent<E>
    extends EventObject {
        private final E selectedItem;
        private static final long serialVersionUID = 1L;

        protected SelectionChangeEvent(AbstractComboModelAdapter<E> source, E selectedItem) {
            super(source);
            this.selectedItem = selectedItem;
        }

        @Override
        public AbstractComboModelAdapter<E> getSource() {
            return (AbstractComboModelAdapter)super.getSource();
        }

        public E selectedItem() {
            return this.selectedItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectionChangeListener<E>
    extends EventListener {
        public void selectionChanged(SelectionChangeEvent<E> var1);
    }
}

