/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.ui.view;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.aesh.core.console.Console;
import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.ui.internal.document.DocumentImpl;
import org.jboss.tools.aesh.ui.internal.viewer.CursorListenerImpl;
import org.jboss.tools.aesh.ui.internal.viewer.DocumentListenerImpl;
import org.jboss.tools.aesh.ui.internal.viewer.TextWidget;
import org.jboss.tools.aesh.ui.internal.viewer.VerifyKeyListenerImpl;

public abstract class AbstractTextViewer
extends TextViewer {
    Console console;
    DocumentImpl document;
    TextWidget textWidget;

    public AbstractTextViewer(Composite parent) {
        super(parent, 832);
        this.initialize();
    }

    public AbstractTextViewer(Composite parent, int styles) {
        super(parent, styles);
        this.initialize();
    }

    public void startConsole() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractTextViewer.this.console.connect((Document)AbstractTextViewer.this.document);
                AbstractTextViewer.this.setDocument((IDocument)AbstractTextViewer.this.document.getDelegate());
                AbstractTextViewer.this.console.start();
            }
        });
    }

    public void stopConsole() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractTextViewer.this.console.stop();
                AbstractTextViewer.this.console.disconnect();
                AbstractTextViewer.this.document.reset();
                AbstractTextViewer.this.setDocument(null);
            }
        });
    }

    protected abstract Console createConsole();

    protected StyledText createTextWidget(Composite parent, int styles) {
        this.textWidget = new TextWidget(parent, styles);
        return this.textWidget;
    }

    protected void handleVerifyEvent(VerifyEvent e) {
        this.console.sendInput(e.text);
        e.doit = false;
    }

    private void initialize() {
        this.initializeConsole();
        this.initializeDocument();
        this.initializeTextWidget();
    }

    private void initializeConsole() {
        this.console = this.createConsole();
    }

    private void initializeDocument() {
        this.document = new DocumentImpl();
        this.document.setCursorListener(new CursorListenerImpl(this.textWidget, this.document));
        this.document.setDocumentListener(new DocumentListenerImpl(this.textWidget, this.document));
    }

    private void initializeTextWidget() {
        this.textWidget.setConsole(this.console);
        this.textWidget.setFont(JFaceResources.getFont((String)"org.jboss.tools.aesh.ui.font"));
        this.textWidget.addVerifyKeyListener(new VerifyKeyListenerImpl(this.console));
    }
}

