/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIMessages;
import tern.eclipse.ide.tools.internal.ui.wizards.TernWizardPage;
import tern.eclipse.ide.tools.internal.ui.wizards.repository.InstallTernModulesOptions;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.eclipse.ide.ui.viewers.TernRepositoryLabelProvider;
import tern.repository.ITernRepository;
import tern.repository.TernRepositoryHelper;
import tern.server.ITernModule;

public class InstallTernModulesSelectionWizardPage
extends TernWizardPage<InstallTernModulesOptions> {
    private static final String PAGE = "DownloadTernModulesSelectionWizardPage";
    private TernModulesBlock modulesBlock;
    private Button refreshButton;
    private ComboViewer repositoryViewer;
    private Text repositoryURL;

    public InstallTernModulesSelectionWizardPage() {
        super(PAGE);
        this.setTitle(TernToolsUIMessages.InstallTernModulesSelectionWizardPage_title);
        this.setDescription(TernToolsUIMessages.InstallTernModulesSelectionWizardPage_description);
    }

    @Override
    protected Composite createUI(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.createLocalRepository(container);
        this.createRepositoryURL(container);
        this.createModules(container);
        return container;
    }

    protected void createModules(Composite container) {
        this.modulesBlock = new TernModulesBlock(null, null);
        Control control = this.modulesBlock.createControl(container);
        this.modulesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstallTernModulesSelectionWizardPage.this.dialogChanged();
            }
        });
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
    }

    private void createLocalRepository(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label repositoryNameLabel = new Label(container, 0);
        repositoryNameLabel.setText(TernToolsUIMessages.InstallTernModulesSelectionWizardPage_localRespositoryName_text);
        this.repositoryViewer = new ComboViewer(container, 12);
        this.repositoryViewer.getControl().setLayoutData((Object)new GridData(768));
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)TernRepositoryLabelProvider.getInstance());
        this.repositoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Collection repositories = TernCorePlugin.getTernRepositoryManager().getRepositories();
        this.repositoryViewer.setInput((Object)repositories);
        final Text repositoryPath = new Text(container, 72);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        repositoryPath.setLayoutData((Object)data);
        this.repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITernRepository repository = (ITernRepository)((IStructuredSelection)event.getSelection()).getFirstElement();
                repositoryPath.setText(repository.getTernBaseDirAsString());
                ((InstallTernModulesOptions)InstallTernModulesSelectionWizardPage.this.getModel()).setRepository(repository);
            }
        });
        ITernRepository defaultRepository = TernCorePlugin.getTernRepositoryManager().getRepository("default");
        if (defaultRepository != null) {
            this.repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)defaultRepository));
            repositoryPath.setText(defaultRepository.getTernBaseDirAsString());
        }
    }

    protected void createRepositoryURL(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label repositoryURLLabel = new Label(container, 0);
        repositoryURLLabel.setText(TernToolsUIMessages.InstallTernModulesSelectionWizardPage_repositoryURL_text);
        this.repositoryURL = new Text(container, 2048);
        this.repositoryURL.setText("https://raw.githubusercontent.com/paulvi/tern-plugins/master/plugins.json");
        this.repositoryURL.setLayoutData((Object)new GridData(768));
        this.refreshButton = new Button(container, 8);
        this.refreshButton.setText(TernToolsUIMessages.Button_refresh);
        this.repositoryURL.setLayoutData((Object)new GridData(768));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallTernModulesSelectionWizardPage.this.refreshButton.setEnabled(false);
                InstallTernModulesSelectionWizardPage.this.refreshModules();
            }
        });
    }

    @Override
    protected void initialize() {
        this.refreshModules();
    }

    protected void refreshModules() {
        this.modulesBlock.setEnabled(false);
        this.modulesBlock.setTernModules(ITernModule.EMPTY_MODULE);
        RefreshRepositoryJob refreshJob = new RefreshRepositoryJob(this.repositoryURL.getText());
        refreshJob.schedule();
    }

    @Override
    protected String validate() {
        Collection objModules = this.modulesBlock.getCheckedModules();
        if (objModules.size() == 0) {
            return TernToolsUIMessages.InstallTernModulesSelectionWizardPage_modules_selection_validation;
        }
        return null;
    }

    @Override
    protected void updateModel(InstallTernModulesOptions model) {
        ITernModule[] modules = this.modulesBlock.getCheckedModules().toArray(ITernModule.EMPTY_MODULE);
        model.setRepository((ITernRepository)((IStructuredSelection)this.repositoryViewer.getSelection()).getFirstElement());
        model.setTernModules(modules);
    }

    private class RefreshRepositoryJob
    extends Job {
        private final String url;

        public RefreshRepositoryJob(String url) {
            super(TernToolsUIMessages.RefreshRepositoryJob_name);
            this.url = url;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(NLS.bind((String)TernToolsUIMessages.RefreshRepositoryJob_loading, (Object)this.url), 1);
            try {
                List modules = TernRepositoryHelper.loadModules((String)this.url);
                monitor.worked(1);
                this.refreshModules(modules, null);
            }
            catch (Throwable e) {
                this.refreshModules(Collections.EMPTY_LIST, e);
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private void refreshModules(final List<ITernModule> modules, final Throwable e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InstallTernModulesSelectionWizardPage.this.refreshButton.setEnabled(true);
                    InstallTernModulesSelectionWizardPage.this.modulesBlock.setTernModules(modules.toArray(ITernModule.EMPTY_MODULE));
                    if (e != null) {
                        Status status = new Status(4, "tern.eclipse.ide.tools.ui", 4, NLS.bind((String)TernToolsUIMessages.InstallTernModulesSelectionWizardPage_errorMessage, (Object)RefreshRepositoryJob.this.url), e);
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)TernToolsUIMessages.InstallTernModulesSelectionWizardPage_errorTitle, (String)NLS.bind((String)TernToolsUIMessages.InstallTernModulesSelectionWizardPage_errorMessage, (Object)RefreshRepositoryJob.this.url), (IStatus)status);
                    } else {
                        InstallTernModulesSelectionWizardPage.this.modulesBlock.setEnabled(true);
                    }
                }
            });
        }
    }
}

