/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards.repository;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import tern.eclipse.ide.server.nodejs.core.IDENodejsProcessHelper;
import tern.eclipse.ide.tools.internal.ui.console.TernRepositoryConsoleHelper;
import tern.eclipse.ide.tools.internal.ui.wizards.IOperation;
import tern.eclipse.ide.tools.internal.ui.wizards.repository.InstallTernModulesOptions;
import tern.eclipse.ide.ui.console.LineType;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.server.nodejs.npm.INPMProcessListener;
import tern.server.nodejs.npm.NPMProcess;

public class InstallTernModulesOperation
implements IOperation<InstallTernModulesOptions>,
INPMProcessListener {
    @Override
    public void init() {
    }

    @Override
    public void run(IProgressMonitor monitor, InstallTernModulesOptions options) throws CoreException {
        ITernRepository repository = options.getRepository();
        ITernModule[] modules = options.getTernModules();
        int i = 0;
        while (i < modules.length) {
            this.download(modules[i], repository, options, monitor);
            ++i;
        }
    }

    private void download(ITernModule module, ITernRepository repository, InstallTernModulesOptions options, IProgressMonitor monitor) {
        try {
            String npmPath = IDENodejsProcessHelper.getNPMPath();
            NPMProcess process = new NPMProcess(npmPath, repository.getTernBaseDir());
            process.addProcessListener((INPMProcessListener)this);
            process.install(module);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getTotal() {
        return 1;
    }

    public void onCreate(NPMProcess process, List<String> commands, File projectDir) {
        StringBuilder commandsAsString = new StringBuilder();
        int i = 0;
        for (String cmd : commands) {
            if (i > 0) {
                commandsAsString.append(" ");
            }
            if (i <= 1) {
                commandsAsString.append("\"");
            }
            commandsAsString.append(cmd);
            if (i <= 1) {
                commandsAsString.append("\"");
            }
            ++i;
        }
        TernRepositoryConsoleHelper.doAppendLine(LineType.PROCESS_INFO, commandsAsString.toString());
    }

    public void onStart(NPMProcess process) {
        String line = "start npm process";
        TernRepositoryConsoleHelper.doAppendLine(LineType.PROCESS_INFO, line);
    }

    public void onData(NPMProcess process, String line) {
        TernRepositoryConsoleHelper.doAppendLine(LineType.DATA, line);
    }

    public void onStop(NPMProcess process) {
        String line = "end npm process";
        TernRepositoryConsoleHelper.doAppendLine(LineType.PROCESS_INFO, line);
    }

    public void onError(NPMProcess process, String line) {
        TernRepositoryConsoleHelper.doAppendLine(LineType.PROCESS_ERROR, line);
    }
}

