/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.model;

import com.ocpsoft.pretty.time.PrettyTime;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;

public class FeedsEntry {
    private String title;
    private String link;
    private String description;
    private String author;
    private Date date;
    private Type type;

    public FeedsEntry() {
    }

    public FeedsEntry(String title, String link, String description, String author, Date date) {
        this(title, link, description, author, date, Type.BLOG);
    }

    public FeedsEntry(String title, String link, String description, String author, Date date, Type type) {
        this.title = title;
        this.link = link;
        this.description = description;
        this.author = author;
        this.date = date;
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public Type getType() {
        return this.type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getFormString(boolean escapeXml) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form><p>");
        buffer.append("<img href=\"image\"/> ");
        if (this.link != null && !this.link.isEmpty()) {
            buffer.append("<a href=\"");
            buffer.append(this.link);
            buffer.append("\">");
            buffer.append(this.escapeXml(this.title, escapeXml));
            buffer.append("</a>");
        } else {
            buffer.append(this.escapeXml(this.title, escapeXml));
        }
        boolean cr = false;
        if (this.date != null) {
            buffer.append("<b>");
            PrettyTime prettyTime = new PrettyTime(new Date());
            buffer.append("&#160;" + prettyTime.format(this.date));
            buffer.append("</b>");
            cr = true;
        }
        if (this.author != null && !this.author.isEmpty() && !"(author unknown)".equalsIgnoreCase(this.author)) {
            buffer.append(" ");
            buffer.append("<span font=\"default\">");
            buffer.append(" by");
            buffer.append("</span>");
            buffer.append(" ");
            buffer.append("<span color=\"author\" font=\"author\">");
            buffer.append(this.escapeXml(this.author, escapeXml));
            buffer.append("</span>");
            cr = true;
        }
        if (cr) {
            buffer.append("<br/>");
        }
        String shortDescription = this.getShortDescription();
        cr = false;
        if (shortDescription != null && !shortDescription.isEmpty()) {
            buffer.append("<span font=\"description\">");
            buffer.append(this.escapeXml(shortDescription, escapeXml));
            buffer.append("</span>");
            cr = true;
        }
        if (cr) {
            buffer.append("<br/><br/>");
        }
        buffer.append("</p></form>");
        return buffer.toString();
    }

    public String getShortString(boolean escapeXml) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form><p>");
        buffer.append("<img href=\"image\"/> ");
        if (this.link != null && !this.link.isEmpty()) {
            buffer.append("<a href=\"");
            buffer.append(this.link);
            buffer.append("\">");
            buffer.append(this.escapeXml(this.title, escapeXml));
            buffer.append("</a>");
        } else {
            buffer.append(this.escapeXml(this.title, escapeXml));
        }
        if (this.date != null) {
            buffer.append("<b>");
            PrettyTime prettyTime = new PrettyTime(new Date());
            buffer.append("&#160;" + prettyTime.format(this.date));
            buffer.append("</b>");
        }
        if (this.author != null && !this.author.isEmpty() && !"(author unknown)".equalsIgnoreCase(this.author)) {
            buffer.append(" ");
            buffer.append("<span font=\"default\">");
            buffer.append(" by");
            buffer.append("</span>");
            buffer.append(" ");
            buffer.append("<span color=\"author\" font=\"author\">");
            buffer.append(this.escapeXml(this.author, escapeXml));
            buffer.append("</span>");
        }
        buffer.append("</p></form>");
        return buffer.toString();
    }

    protected String escapeXml(String text, boolean escape) {
        text = StringEscapeUtils.unescapeHtml((String)text);
        if (escape) {
            text = StringEscapeUtils.escapeXml((String)text);
        }
        text = text.replaceAll("&nbsp;", "&#160;");
        text = text.replaceAll("& ", "&#38; ");
        return text;
    }

    public String getShortDescription() {
        if (this.description == null) {
            return null;
        }
        boolean tagStarted = false;
        StringBuilder buffer = new StringBuilder();
        char[] cArray = this.description.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '<') {
                tagStarted = true;
            }
            if (c == '>') {
                tagStarted = false;
            } else if (!tagStarted) {
                buffer.append(c);
            }
            ++n2;
        }
        char[] chars = StringEscapeUtils.unescapeHtml((String)buffer.toString().trim()).toCharArray();
        buffer = new StringBuilder();
        int i = 0;
        char[] cArray2 = chars;
        int n3 = chars.length;
        int n4 = 0;
        while (n4 < n3) {
            char c = cArray2[n4];
            if (i++ < 180) {
                buffer.append(c);
            } else {
                if (!(c == '_' || c >= 'a' && c <= 'z' || c >= 'a' && c <= 'Z') && (c < '0' || c > '9')) break;
                buffer.append(c);
            }
            ++n4;
        }
        if (buffer.length() > 0) {
            buffer.append("...");
        }
        return buffer.toString();
    }

    public String toString() {
        return "FeedsEntry [title=" + this.title + ", link=" + this.link + ", description=" + this.description + ", author=" + this.author + ", date=" + this.date + "]";
    }

    public static enum Type {
        BLOG,
        TWITTER;

    }
}

