/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.central.wizards.AbstractJBossCentralProjectWizard;
import org.osgi.framework.Bundle;

public class WizardSupport {
    private static final String CLASS_ATTRIBUTE = "class";

    private WizardSupport() {
    }

    public static Map<String, IConfigurationElement> getInstalledWizards() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.ui.newWizards");
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, IConfigurationElement> installedWizards = new HashMap<String, IConfigurationElement>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                boolean isProjectWizard = Boolean.parseBoolean(element.getAttribute("project"));
                if (isProjectWizard) {
                    String id = element.getAttribute("id");
                    installedWizards.put(id, element);
                }
                ++n4;
            }
            ++n2;
        }
        return installedWizards;
    }

    public static void openWizard(IConfigurationElement element) throws CoreException {
        Object object = WizardSupport.createExtension(element);
        if (object instanceof INewWizard) {
            INewWizard wizard = (INewWizard)object;
            wizard.init(PlatformUI.getWorkbench(), null);
            if (wizard instanceof AbstractJBossCentralProjectWizard && ((AbstractJBossCentralProjectWizard)wizard).getProjectExample() == null) {
                return;
            }
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static Object createExtension(final IConfigurationElement element) throws CoreException {
        if (element == null) {
            return null;
        }
        try {
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            if (WizardSupport.isActive(bundle)) {
                return element.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(WizardSupport.CLASS_ATTRIBUTE);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (InvalidRegistryObjectException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.central", 4, "Cannot create extension", (Throwable)e));
        }
    }

    private static boolean isActive(Bundle bundle) {
        return bundle != null && bundle.getState() == 32;
    }
}

