/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.TitleRegion;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.actions.OpenWithBrowserHandler;
import org.jboss.tools.central.editors.AbstractJBossCentralPage;
import org.jboss.tools.central.editors.GettingStartedHtmlPage;
import org.jboss.tools.central.editors.JBossCentralEditorInput;
import org.jboss.tools.central.editors.SoftwarePage;
import org.jboss.tools.central.editors.xpl.TextSearchControl;
import org.jboss.tools.central.installation.InstallationChecker;

public class JBossCentralEditor
extends SharedHeaderFormEditor {
    private static final String COMMANDS_GROUP = "commands";
    private static final String UTF_8_ENCODING = "UTF-8";
    public static final String JBOSS_CENTRAL = "JBoss Central";
    public static final String ID = "org.jboss.tools.central.editors.JBossCentralEditor";
    private Color colorLightYellow;
    public static final String COLOR_LIGHTYELLOW = "lightyellow";
    private AbstractJBossCentralPage gettingStartedPage;
    private SoftwarePage softwarePage;
    private Image gettingStartedImage;
    private Image softwareImage;
    private Composite settingsComposite;
    private Composite toolbarComposite;
    private Composite searchComposite;
    static boolean useDefaultColors;

    public JBossCentralEditor() {
        useDefaultColors = true;
    }

    public void dispose() {
        this.gettingStartedPage = null;
        this.softwarePage = null;
        if (this.gettingStartedImage != null) {
            this.gettingStartedImage.dispose();
            this.gettingStartedImage = null;
        }
        if (this.softwareImage != null) {
            this.softwareImage.dispose();
            this.softwareImage = null;
        }
        Job.getJobManager().cancel(JBossCentralActivator.JBOSS_CENTRAL_FAMILY);
        try {
            Job.getJobManager().join(JBossCentralActivator.JBOSS_CENTRAL_FAMILY, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof JBossCentralEditorInput)) {
            editorInput = JBossCentralEditorInput.INSTANCE;
        }
        super.init(site, editorInput);
        this.initializeColors();
        this.setPartName(JBOSS_CENTRAL);
    }

    private void initializeColors() {
        if (this.colorLightYellow == null) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_LIGHTYELLOW)) {
                colorRegistry.put(COLOR_LIGHTYELLOW, new RGB(255, 255, 160));
            }
            this.colorLightYellow = colorRegistry.get(COLOR_LIGHTYELLOW);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void addPages() {
        try {
            this.gettingStartedPage = new GettingStartedHtmlPage((FormEditor)this);
            int index = this.addPage((IFormPage)this.gettingStartedPage);
            if (this.gettingStartedImage == null) {
                this.gettingStartedImage = JBossCentralActivator.getImageDescriptor("/icons/gettingStarted.png").createImage();
            }
            this.setPageImage(index, this.gettingStartedImage);
            this.softwarePage = new SoftwarePage((FormEditor)this);
            index = this.addPage((IFormPage)this.softwarePage);
            if (this.softwareImage == null) {
                this.softwareImage = JBossCentralActivator.getImageDescriptor("/icons/software.png").createImage();
            }
            this.setPageImage(index, this.softwareImage);
        }
        catch (PartInitException e) {
            JBossCentralActivator.log(e, "Error adding page");
        }
    }

    public boolean isDirty() {
        return false;
    }

    protected void _createHeaderContents(IManagedForm headerForm) {
        String[] commandIds;
        final ScrolledForm form = headerForm.getForm();
        new HeaderText(form);
        form.setToolTipText("Welcome to JBoss");
        form.setImage(this.getHeaderImage());
        this.getToolkit().decorateFormHeading(form.getForm());
        final IToolBarManager toolbar = form.getToolBarManager();
        ControlContribution searchControl = new ControlContribution("Search"){

            protected Control createControl(Composite parent) {
                return JBossCentralEditor.this.createSearchControl(parent);
            }
        };
        toolbar.add((IContributionItem)searchControl);
        toolbar.add((IContributionItem)new GroupMarker(COMMANDS_GROUP));
        String[] stringArray = commandIds = JBossCentralActivator.getDefault().getConfigurator().getMainToolbarCommandIds();
        int n = commandIds.length;
        int n2 = 0;
        while (n2 < n) {
            String commandId = stringArray[n2];
            CommandContributionItem item = JBossCentralActivator.createContributionItem((IServiceLocator)this.getSite(), commandId);
            toolbar.appendToGroup(COMMANDS_GROUP, (IContributionItem)item);
            ++n2;
        }
        toolbar.update(true);
        form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (toolbar instanceof ToolBarManager) {
                    ((ToolBarManager)toolbar).dispose();
                } else {
                    toolbar.removeAll();
                }
                form.removeDisposeListener((DisposeListener)this);
            }
        });
        form.layout(true, true);
    }

    protected Composite createPageContainer(Composite parent) {
        Composite composite = super.createPageContainer(parent);
        JBossCentralActivator.initDropTarget((Control)parent);
        return composite;
    }

    protected Control createSearchControl(Composite parent) {
        this.toolbarComposite = parent;
        this.searchComposite = this.getToolkit().createComposite(parent);
        GridData gd = new GridData(1, 4, true, true);
        gd.widthHint = 200;
        this.searchComposite.setLayoutData((Object)gd);
        this.searchComposite.setBackground(null);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 10;
        this.searchComposite.setLayout((Layout)gridLayout);
        ImageHyperlink menuLink = this.getToolkit().createImageHyperlink(this.searchComposite, 0);
        gd = new GridData(4, 128, false, false);
        menuLink.setLayoutData((Object)gd);
        menuLink.setBackground(null);
        menuLink.setImage(JBossCentralActivator.getDefault().getImage("/icons/toolbar-arrow-down.gif"));
        menuLink.setToolTipText("Search Menu");
        final TextSearchControl searchControl = new TextSearchControl(this.searchComposite, false);
        gd = new GridData(0x1000008, 128, true, true);
        gd.widthHint = 200;
        searchControl.setLayoutData(gd);
        searchControl.setBackground(null);
        this.getToolkit().adapt((Composite)searchControl);
        SelectionAdapter searchControlListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    searchControl.getTextControl().setText("");
                    searchControl.setInitialMessage(searchControl.getInitialMessage());
                } else {
                    try {
                        final StringBuilder url = new StringBuilder();
                        String initialMessage = searchControl.getInitialMessage();
                        if ("Search Red Hat Customer Portal ".equals(initialMessage)) {
                            url.append("https://access.redhat.com/search/#/?p=1&srch=any&language=en&q=");
                            url.append(URLEncoder.encode(searchControl.getText(), JBossCentralEditor.UTF_8_ENCODING));
                        } else {
                            url.append("http://community.jboss.org/search.jspa?searchArea=");
                            url.append(URLEncoder.encode(initialMessage, JBossCentralEditor.UTF_8_ENCODING));
                            url.append("&as_sitesearch=jboss.org&q=");
                            url.append(URLEncoder.encode(searchControl.getText(), JBossCentralEditor.UTF_8_ENCODING));
                        }
                        OpenWithBrowserHandler handler = new OpenWithBrowserHandler(){

                            @Override
                            public String getLocation() {
                                return url.toString();
                            }
                        };
                        handler.execute(new ExecutionEvent());
                    }
                    catch (UnsupportedEncodingException e1) {
                        JBossCentralActivator.log(e1);
                    }
                    catch (ExecutionException e1) {
                        JBossCentralActivator.log(e1);
                    }
                }
            }
        };
        searchControl.addSelectionListener((SelectionListener)searchControlListener);
        searchControl.addDisposeListener(new DisposeListener((SelectionListener)searchControlListener){
            private final /* synthetic */ SelectionListener val$searchControlListener;
            {
                this.val$searchControlListener = selectionListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                searchControl.removeSelectionListener(this.val$searchControlListener);
                searchControl.removeDisposeListener(this);
            }
        });
        final Menu menu = new Menu((Control)menuLink);
        final MenuItem searchCommunityPortal = new MenuItem(menu, 32);
        searchCommunityPortal.setText("Search Red Hat Customer Portal ");
        final MenuItem searchCommunity = new MenuItem(menu, 32);
        searchCommunity.setText("Search JBoss Community");
        String initialMessage = searchControl.getInitialMessage();
        if ("Search Red Hat Customer Portal ".equals(initialMessage)) {
            searchCommunityPortal.setSelection(true);
        } else {
            searchCommunity.setSelection(true);
        }
        SelectionAdapter searchCommunityListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                searchCommunity.setSelection(true);
                searchCommunityPortal.setSelection(false);
                searchControl.setInitialMessage("Search JBoss Community");
            }
        };
        searchCommunity.addSelectionListener((SelectionListener)searchCommunityListener);
        searchCommunity.addDisposeListener(new DisposeListener((SelectionListener)searchCommunityListener){
            private final /* synthetic */ SelectionListener val$searchCommunityListener;
            {
                this.val$searchCommunityListener = selectionListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                searchCommunity.removeSelectionListener(this.val$searchCommunityListener);
                searchCommunity.removeDisposeListener((DisposeListener)this);
            }
        });
        SelectionAdapter searchCommunityPortalListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                searchCommunity.setSelection(false);
                searchCommunityPortal.setSelection(true);
                searchControl.setInitialMessage("Search Red Hat Customer Portal ");
            }
        };
        searchCommunityPortal.addSelectionListener((SelectionListener)searchCommunityPortalListener);
        searchCommunityPortal.addDisposeListener(new DisposeListener((SelectionListener)searchCommunityPortalListener){
            private final /* synthetic */ SelectionListener val$searchCommunityPortalListener;
            {
                this.val$searchCommunityPortalListener = selectionListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                searchCommunityPortal.removeSelectionListener(this.val$searchCommunityPortalListener);
                searchCommunityPortal.removeDisposeListener((DisposeListener)this);
            }
        });
        menuLink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                menu.setVisible(false);
            }

            public void mouseDown(MouseEvent e) {
                menu.setVisible(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.searchComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
                JBossCentralEditor.this.searchComposite.removeDisposeListener((DisposeListener)this);
            }
        });
        return this.searchComposite;
    }

    private Image getHeaderImage() {
        return JBossCentralActivator.getDefault().getConfigurator().getHeaderImage();
    }

    public AbstractJBossCentralPage getGettingStartedPage() {
        return this.gettingStartedPage;
    }

    public SoftwarePage getSoftwarePage() {
        return this.softwarePage;
    }

    private class HeaderText {
        private StyledText titleLabel;
        private BusyIndicator busyLabel;
        private TitleRegion titleRegion;
        private ScrolledForm form;
        private InstallationChecker installChecker;

        public HeaderText(ScrolledForm form) {
            this.form = form;
            final FormHeading heading = (FormHeading)form.getForm().getHead();
            heading.setBusy(true);
            heading.setBusy(false);
            try {
                Field field = FormHeading.class.getDeclaredField("titleRegion");
                field.setAccessible(true);
                this.titleRegion = (TitleRegion)field.get(heading);
                Control[] controlArray = this.titleRegion.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child instanceof BusyIndicator) {
                        this.busyLabel = (BusyIndicator)child;
                        break;
                    }
                    ++n2;
                }
                if (this.busyLabel == null) {
                    throw new IllegalArgumentException();
                }
                TextViewer titleViewer = new TextViewer((Composite)this.titleRegion, 8);
                titleViewer.setDocument((IDocument)new Document());
                this.titleLabel = titleViewer.getTextWidget();
                this.updateTitle(heading);
                final IPropertyChangeListener updateTitleOnEAChange = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getProperty().equals("enableEarlyAccess")) {
                            if (heading.isDisposed()) {
                                return;
                            }
                            heading.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    HeaderText.this.updateTitle(heading);
                                }
                            });
                        }
                    }
                };
                JBossCentralActivator.getDefault().getPreferenceStore().addPropertyChangeListener(updateTitleOnEAChange);
                this.form.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        JBossCentralActivator.getDefault().getPreferenceStore().removePropertyChangeListener(updateTitleOnEAChange);
                    }
                });
                Job checkEarlyAccessJob = new Job("Check installation for Early Access"){
                    private Display display;
                    {
                        super($anonymous0);
                        this.display = formHeading.getDisplay();
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        try {
                            HeaderText.this.installChecker = InstallationChecker.getInstance();
                        }
                        catch (ProvisionException ex) {
                            JBossCentralActivator.log(ex);
                        }
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                HeaderText.this.updateTitle(heading);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                checkEarlyAccessJob.schedule();
                Font font = new Font((Device)heading.getDisplay(), "Lucida Sans Unicode", 14, 0);
                this.titleLabel.setFont(font);
                this.titleLabel.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        HeaderText.this.titleLabel.setSelection(0);
                        Event selectionEvent = new Event();
                        selectionEvent.x = 0;
                        selectionEvent.y = 0;
                        HeaderText.this.titleLabel.notifyListeners(13, selectionEvent);
                    }
                });
                Point size = this.titleLabel.computeSize(-1, -1);
                final Image emptyImage = new Image((Device)heading.getDisplay(), size.x, size.y);
                this.busyLabel.setImage(emptyImage);
                this.titleLabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        emptyImage.dispose();
                    }
                });
                this.busyLabel.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlMoved(ControlEvent e) {
                        HeaderText.this.updateSizeAndLocations();
                    }
                });
                this.titleLabel.moveAbove((Control)this.busyLabel);
                this.titleRegion.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        HeaderText.this.updateSizeAndLocations();
                    }
                });
                this.updateSizeAndLocations();
            }
            catch (Exception e) {
                JBossCentralActivator.log(e);
            }
        }

        private void updateTitle(FormHeading heading) {
            if (heading.isDisposed() || this.titleLabel.isDisposed()) {
                return;
            }
            Color foreground = null;
            foreground = useDefaultColors ? heading.getForeground() : heading.getDisplay().getSystemColor(2);
            this.titleLabel.setForeground(foreground);
            boolean isEarlyAccessEnabled = JBossCentralActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false);
            boolean showEarlyAccessInstalled = this.installChecker != null && this.installChecker.hasEarlyAccess();
            String title = "Welcome to JBoss";
            String earlyAccessSuffix = "(Early Access ";
            if (isEarlyAccessEnabled) {
                earlyAccessSuffix = String.valueOf(earlyAccessSuffix) + "enabled";
            }
            if (isEarlyAccessEnabled && showEarlyAccessInstalled) {
                earlyAccessSuffix = String.valueOf(earlyAccessSuffix) + "/";
            }
            if (showEarlyAccessInstalled) {
                earlyAccessSuffix = String.valueOf(earlyAccessSuffix) + "installed";
            }
            earlyAccessSuffix = String.valueOf(earlyAccessSuffix) + ")";
            if (isEarlyAccessEnabled || showEarlyAccessInstalled) {
                this.titleLabel.setText(String.valueOf(title) + " " + earlyAccessSuffix);
                Color background = JBossCentralEditor.this.colorLightYellow;
                StyleRange range = new StyleRange(title.length() + 1, earlyAccessSuffix.length(), foreground, background);
                range.fontStyle = 2;
                this.titleLabel.setStyleRange(range);
            } else {
                this.titleLabel.setText(title);
            }
            heading.layout(true);
        }

        private void updateSizeAndLocations() {
            if (this.busyLabel == null || this.busyLabel.isDisposed()) {
                return;
            }
            if (this.titleLabel == null || this.titleLabel.isDisposed()) {
                return;
            }
            Point size = this.titleLabel.computeSize(-1, -1, true);
            int y = (this.titleLabel.getParent().getSize().y - size.y) / 2;
            this.titleLabel.setBounds(this.busyLabel.getLocation().x + 20, y, size.x, size.y);
            this.titleRegion.setBounds(5, 0, size.x + 40, size.y + 8);
            if (JBossCentralEditor.this.toolbarComposite != null && !JBossCentralEditor.this.toolbarComposite.isDisposed() && JBossCentralEditor.this.searchComposite != null && !JBossCentralEditor.this.searchComposite.isDisposed()) {
                int width = size.x + 40 + ((JBossCentralEditor)JBossCentralEditor.this).toolbarComposite.getSize().x;
                int formWidth = this.form.getSize().x;
                if (width > formWidth) {
                    JBossCentralEditor.this.searchComposite.setVisible(false);
                } else {
                    JBossCentralEditor.this.searchComposite.setVisible(true);
                }
            }
        }
    }
}

