/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.editors.AbstractJBossCentralPage;
import org.jboss.tools.central.installation.InstallationChecker;
import org.jboss.tools.central.internal.CentralHelper;
import org.jboss.tools.central.internal.JsonUtil;
import org.jboss.tools.central.internal.WizardSupport;
import org.jboss.tools.central.internal.browser.CentralBrowserErrorWrapper;
import org.jboss.tools.central.internal.browser.VersionedBrowser;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizard;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizardManager;
import org.jboss.tools.central.internal.dnd.JBossCentralDropTarget;
import org.jboss.tools.central.jobs.RefreshBuzzJob;
import org.jboss.tools.central.model.FeedsEntry;
import org.jboss.tools.discovery.core.internal.connectors.DiscoveryUtil;
import org.jboss.tools.discovery.core.internal.connectors.JBossDiscoveryUi;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.project.examples.FavoriteItem;
import org.jboss.tools.project.examples.IFavoriteExampleManager;
import org.jboss.tools.project.examples.IProjectExampleManager;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;

public class GettingStartedHtmlPage
extends AbstractJBossCentralPage
implements ProxyWizardManager.ProxyWizardManagerListener,
IPropertyChangeListener {
    public static final String ID = "org.jboss.tools.central.editors.GettingStartedPage";
    private ScrolledForm form;
    private VersionedBrowser browser;
    private Collection<ProxyWizard> allWizards;
    private Collection<FavoriteItem> favorites;
    private Map<String, ProjectExample> examples;
    private Map<String, ProxyWizard> displayedWizardsMap;
    private RefreshBuzzJobChangeListener buzzlistener;
    private boolean showOnStartup;

    public GettingStartedHtmlPage(FormEditor editor) {
        super(editor, ID, "Getting Started");
        ProxyWizardManager.INSTANCE.registerListener(this);
        JBossCentralActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        RefreshBuzzJob buzzjob = RefreshBuzzJob.INSTANCE;
        this.buzzlistener = new RefreshBuzzJobChangeListener();
        buzzjob.addJobChangeListener((IJobChangeListener)this.buzzlistener);
        buzzjob.schedule();
        RefreshQuickstartsJob job = new RefreshQuickstartsJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                GettingStartedHtmlPage.this.examples = ((RefreshQuickstartsJob)event.getJob()).getExamples();
                GettingStartedHtmlPage.this.browserExec(GettingStartedHtmlPage.this.getLoadQuickstartsScript());
                GettingStartedHtmlPage.this.browserExec(GettingStartedHtmlPage.this.getLoadFavoritesScript());
            }
        });
        job.schedule();
        super.createFormContent(managedForm);
        this.showOnStartup = CentralHelper.isShowOnStartup();
        this.form = managedForm.getForm();
        Composite body = this.form.getBody();
        GridLayoutFactory.fillDefaults().applyTo(body);
        this.createBrowserSection(body);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GettingStartedHtmlPage.this.form.removeDisposeListener((DisposeListener)this);
            }
        });
        this.createSettingsListener(body);
    }

    private void createBrowserSection(final Composite parent) {
        try {
            this.browser = new VersionedBrowser(parent, 0);
            GridData layoutData = new GridData(1808);
            layoutData.horizontalSpan = 1;
            layoutData.verticalSpan = 1;
            this.browser.setLayoutData(new GridData(4, 4, true, true));
            new BrowserFunction(this.browser, "openInIDE"){

                public Object function(Object[] browserArgs) {
                    String function = browserArgs[0].toString();
                    String arg = browserArgs[1].toString();
                    switch (function) {
                        case "quickstart": {
                            GettingStartedHtmlPage.this.openQuickstart(arg);
                            break;
                        }
                        case "wizard": {
                            GettingStartedHtmlPage.this.openProxyWizard(arg);
                            break;
                        }
                        case "openlink": {
                            JBossCentralActivator.openUrl(arg, parent.getShell());
                            break;
                        }
                        case "openpage": {
                            GettingStartedHtmlPage.this.getEditor().setActivePage(arg);
                            break;
                        }
                        case "showonstartup": {
                            GettingStartedHtmlPage.this.showOnStartup = Boolean.parseBoolean(arg);
                            CentralHelper.setShowOnStartup(GettingStartedHtmlPage.this.showOnStartup);
                            break;
                        }
                        case "drop": {
                            GettingStartedHtmlPage.this.drop(arg);
                            break;
                        }
                        default: {
                            System.err.println("Function " + function + "(" + arg + ") is not supported");
                        }
                    }
                    return null;
                }
            };
            new BrowserFunction(this.browser, "initialize"){

                public Object function(Object[] browserArgs) {
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getSetIntegrationStackSupportScript());
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getLoadBuzzScript());
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getLoadProxyWizardsScript());
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getLoadQuickstartsScript());
                    GettingStartedHtmlPage.this.scheduleEarlyAccess();
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getSetShowOnStartupScript());
                    GettingStartedHtmlPage.this.browser.execute(GettingStartedHtmlPage.this.getLoadFavoritesScript());
                    return null;
                }
            };
            String loadingUrl = CentralHelper.getLoadingPageUrl();
            if (loadingUrl != null) {
                this.browser.setUrl(loadingUrl);
            }
            Job centralJob = new Job("Extract Central page"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        final String url = CentralHelper.getCentralUrl(monitor);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GettingStartedHtmlPage.this.browser != null && !GettingStartedHtmlPage.this.browser.isDisposed()) {
                                    GettingStartedHtmlPage.this.browser.setUrl(url);
                                }
                            }
                        });
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Job job = new Job("Update project wizard list"){

                        protected IStatus run(IProgressMonitor monitor) {
                            ProxyWizardManager proxyWizardManager = ProxyWizardManager.INSTANCE;
                            List<ProxyWizard> wizards = proxyWizardManager.getProxyWizards(true, monitor);
                            try {
                                GettingStartedHtmlPage.this.favorites = this.collectFavorites(monitor);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            GettingStartedHtmlPage.this.resetWizards(wizards);
                            return Status.OK_STATUS;
                        }

                        private List<FavoriteItem> collectFavorites(IProgressMonitor monitor) throws CoreException {
                            IFavoriteExampleManager favoriteExampleManager = ProjectExamplesActivator.getDefault().getFavoriteExampleManager();
                            return favoriteExampleManager.getFavoriteItems(10, monitor);
                        }

                        public boolean belongsTo(Object family) {
                            return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
                        }
                    };
                    job.schedule();
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
                }
            };
            centralJob.schedule();
        }
        catch (Throwable t) {
            CentralBrowserErrorWrapper errorWrapper = new CentralBrowserErrorWrapper();
            errorWrapper.showError(parent, t);
        }
    }

    protected void scheduleEarlyAccess() {
        Job checkEarlyAccessJob = new Job("Check installation for Early Access"){
            private Display display;
            {
                this.display = Display.getDefault();
            }

            public IStatus run(IProgressMonitor monitor) {
                InstallationChecker installChecker;
                try {
                    installChecker = InstallationChecker.getInstance();
                }
                catch (ProvisionException ex) {
                    JBossCentralActivator.log(ex);
                    return Status.CANCEL_STATUS;
                }
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GettingStartedHtmlPage.this.updateEarlyAccess(installChecker);
                    }
                });
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
            }
        };
        checkEarlyAccessJob.schedule();
    }

    private void updateEarlyAccess(InstallationChecker installChecker) {
        boolean isEarlyAccessEnabled = JBossCentralActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false);
        boolean showEarlyAccessInstalled = installChecker != null && installChecker.hasEarlyAccess();
        String earlyAccess = "<em class=\"highlight\">Early Access ";
        if (isEarlyAccessEnabled) {
            earlyAccess = String.valueOf(earlyAccess) + "enabled";
        }
        if (isEarlyAccessEnabled && showEarlyAccessInstalled) {
            earlyAccess = String.valueOf(earlyAccess) + "/";
        }
        if (showEarlyAccessInstalled) {
            earlyAccess = String.valueOf(earlyAccess) + "installed";
        }
        earlyAccess = String.valueOf(earlyAccess) + "</em>";
        boolean earlyAccessEnabled = isEarlyAccessEnabled || showEarlyAccessInstalled;
        String script = "handleEarlyAccess(" + earlyAccessEnabled + ",'" + earlyAccess + "');";
        this.browser.execute(script);
    }

    protected void drop(String arg) {
        JBossCentralDropTarget.install(arg);
    }

    protected void openQuickstart(final String quickstartId) {
        final ProjectExample pe = this.examples.get(quickstartId);
        if (pe == null) {
            System.err.println(String.valueOf(quickstartId) + " is not a valid quickstart");
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewProjectExamplesWizard2 wizard = new NewProjectExamplesWizard2(pe);
                WizardDialog dialog = new WizardDialog(GettingStartedHtmlPage.this.getSite().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    GettingStartedHtmlPage.this.favorite(quickstartId);
                }
            }
        });
    }

    protected void favorite(final String itemId) {
        Job job = new Job("Adding " + itemId + " to favorites"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFavoriteExampleManager favoriteExampleManager = ProjectExamplesActivator.getDefault().getFavoriteExampleManager();
                    favoriteExampleManager.favorite(itemId, monitor);
                    GettingStartedHtmlPage.this.favorites = favoriteExampleManager.getFavoriteItems(10, monitor);
                    GettingStartedHtmlPage.this.browserExec(GettingStartedHtmlPage.this.getLoadFavoritesScript());
                }
                catch (CoreException e) {
                    JBossCentralActivator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void openProxyWizard(String proxyWizardId) {
        final ProxyWizard proxyWizard = this.displayedWizardsMap.get(proxyWizardId);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IConfigurationElement element = GettingStartedHtmlPage.this.findWizard(proxyWizard);
                    if (element == null) {
                        GettingStartedHtmlPage.this.installMissingWizard(proxyWizard.getRequiredComponentIds());
                    } else {
                        WizardSupport.openWizard(element);
                    }
                }
                catch (CoreException e1) {
                    JBossCentralActivator.log(e1);
                }
                catch (InvocationTargetException e1) {
                    JBossCentralActivator.log(e1);
                }
                catch (InterruptedException e1) {
                    JBossCentralActivator.log(e1);
                }
            }
        });
    }

    private IConfigurationElement findWizard(ProxyWizard proxyWizard) {
        IConfigurationElement element = WizardSupport.getInstalledWizards().get(proxyWizard.getWizardId());
        if (element == null) {
            return null;
        }
        List<String> pluginIds = proxyWizard.getRequiredPluginIds();
        if (pluginIds != null) {
            for (String id : pluginIds) {
                if (Platform.getBundle((String)id) != null) continue;
                return null;
            }
        }
        return element;
    }

    protected void installMissingWizard(Collection<String> connectorIds) throws InvocationTargetException, InterruptedException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!MessageDialog.openQuestion((Shell)shell, (String)"Information", (String)"The required features to use this wizard need to be installed. Do you want to proceed?")) {
            return;
        }
        final IStatus[] results = new IStatus[1];
        final ConnectorDiscovery[] connectorDiscoveries = new ConnectorDiscovery[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                connectorDiscoveries[0] = DiscoveryUtil.createConnectorDiscovery();
                connectorDiscoveries[0].setEnvironment(JBossCentralActivator.getEnvironment());
                results[0] = connectorDiscoveries[0].performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    results[0] = Status.CANCEL_STATUS;
                }
            }
        };
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        context.run(true, true, runnable);
        if (results[0] == null) {
            return;
        }
        if (results[0].isOK()) {
            List connectors = connectorDiscoveries[0].getConnectors();
            ArrayList<DiscoveryConnector> installableConnectors = new ArrayList<DiscoveryConnector>();
            for (DiscoveryConnector connector : connectors) {
                if (!connectorIds.contains(connector.getId())) continue;
                installableConnectors.add(connector);
            }
            JBossDiscoveryUi.install(installableConnectors, (IRunnableContext)context);
        } else {
            String message = results[0].toString();
            switch (results[0].getSeverity()) {
                case 4: {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)message);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("enableEarlyAccess".equals(event.getProperty())) {
            this.scheduleEarlyAccess();
            this.resetWizards(this.allWizards);
        }
    }

    private void resetWizards(Collection<ProxyWizard> proxyWizards) {
        this.allWizards = proxyWizards;
        if (proxyWizards == null) {
            this.displayedWizardsMap = Collections.emptyMap();
            return;
        }
        boolean earlyAccessEnabled = JBossCentralActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false);
        LinkedHashMap<String, ProxyWizard> newWizards = new LinkedHashMap<String, ProxyWizard>(proxyWizards.size());
        for (ProxyWizard proxyWizard : proxyWizards) {
            if (!earlyAccessEnabled && proxyWizard.hasTag("earlyaccess")) continue;
            newWizards.put(proxyWizard.getId(), proxyWizard);
        }
        this.displayedWizardsMap = newWizards;
        this.browserExec(this.getLoadProxyWizardsScript());
    }

    @Override
    public void onProxyWizardUpdate(ProxyWizardManager.UpdateEvent event) throws CoreException {
        this.resetWizards(event.getProxyWizards());
    }

    private void browserExec(final String script) {
        if (this.browser != null && !this.browser.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GettingStartedHtmlPage.this.browser != null && !GettingStartedHtmlPage.this.browser.isDisposed()) {
                        GettingStartedHtmlPage.this.browser.execute(script);
                    }
                }
            });
        }
    }

    private String getLoadBuzzScript() {
        List<FeedsEntry> buzz = RefreshBuzzJob.INSTANCE.getEntries();
        buzz = buzz.size() > 5 ? buzz.subList(0, 5) : buzz;
        String json = JsonUtil.jsonifyBuzz(buzz);
        String script = "loadBuzz(" + json + ");";
        return script;
    }

    private String getLoadProxyWizardsScript() {
        Collection<ProxyWizard> proxyWizards = this.displayedWizardsMap.values();
        String wizardsJson = JsonUtil.jsonifyWizards(proxyWizards);
        String script = "loadWizards(" + wizardsJson + ");";
        return script;
    }

    private String getLoadFavoritesScript() {
        ArrayList<ProjectExample> favoriteExamples;
        ArrayList<ProjectExample> arrayList = favoriteExamples = this.favorites == null ? Collections.emptyList() : new ArrayList<ProjectExample>(this.favorites.size());
        if (this.examples != null && this.favorites != null) {
            for (FavoriteItem fi : this.favorites) {
                ProjectExample example = this.examples.get(fi.getId());
                if (example == null) continue;
                favoriteExamples.add(example);
            }
        }
        String favoritesJson = JsonUtil.jsonifyExamples(favoriteExamples);
        String script = "loadFavorites(" + favoritesJson + ");";
        return script;
    }

    private String getLoadQuickstartsScript() {
        String json = JsonUtil.jsonifyExamples(this.examples == null ? Collections.emptyList() : this.examples.values());
        String script = "loadQuickstarts(" + json + ");";
        return script;
    }

    private String getSetShowOnStartupScript() {
        String script = "setShowOnStartup('" + this.showOnStartup + "');";
        return script;
    }

    private String getSetIntegrationStackSupportScript() {
        boolean integrationStackAvailable = StringUtils.isNotEmpty((String)PropertiesHelper.getPropertiesProvider().getValue("jboss.discovery.site.integration-stack.url"));
        String script = "setIntegrationStackSupport(" + integrationStackAvailable + ");";
        return script;
    }

    public void dispose() {
        JBossCentralActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ProxyWizardManager.INSTANCE.unRegisterListener(this);
        if (this.buzzlistener != null) {
            RefreshBuzzJob.INSTANCE.removeJobChangeListener((IJobChangeListener)this.buzzlistener);
        }
        if (this.browser != null) {
            this.browser.dispose();
            this.browser = null;
        }
        super.dispose();
    }

    public void createSettingsListener(final Composite parent) {
        final IEclipsePreferences.IPreferenceChangeListener prefChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                boolean show;
                Object value;
                if ("showJBossCentralOnStartup".equals(event.getKey()) && (value = event.getNewValue()) instanceof String && !GettingStartedHtmlPage.this.browser.isDisposed() && (show = Boolean.parseBoolean((String)value)) != GettingStartedHtmlPage.this.showOnStartup) {
                    GettingStartedHtmlPage.this.showOnStartup = show;
                    GettingStartedHtmlPage.this.browserExec(GettingStartedHtmlPage.this.getSetShowOnStartupScript());
                }
            }
        };
        JBossCentralActivator.getDefault().getPreferences().addPreferenceChangeListener(prefChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JBossCentralActivator.getDefault().getPreferences().removePreferenceChangeListener(prefChangeListener);
                parent.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    private class RefreshBuzzJobChangeListener
    extends JobChangeAdapter {
        private RefreshBuzzJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            GettingStartedHtmlPage.this.browserExec(GettingStartedHtmlPage.this.getLoadBuzzScript());
        }
    }

    public static class RefreshQuickstartsJob
    extends Job {
        private Map<String, ProjectExample> examples;

        public RefreshQuickstartsJob() {
            super("Download quickstarts list");
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProjectExampleManager manager = ProjectExamplesActivator.getDefault().getProjectExampleManager();
            try {
                Collection examplesList = manager.getExamples(monitor);
                this.examples = new HashMap<String, ProjectExample>(examplesList.size());
                for (ProjectExample example : examplesList) {
                    String id = example.getId();
                    if (this.examples.containsKey(id)) {
                        JBossCentralActivator.log("Found duplicate quickstart " + id);
                        continue;
                    }
                    this.examples.put(id, example);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == JBossCentralActivator.JBOSS_CENTRAL_FAMILY;
        }

        public Map<String, ProjectExample> getExamples() {
            return this.examples;
        }
    }
}

