/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import com.kenai.constantine.platform.ProtocolFamily;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

abstract class SockAddrUnix
extends Struct {
    public static final int ADDR_LENGTH = 108;

    protected abstract Struct.UTF8String getPathField();

    protected abstract Struct.NumberField getFamilyField();

    public SockAddrUnix() {
        super(Runtime.getSystemRuntime());
    }

    public final void setFamily(ProtocolFamily family) {
        this.getFamilyField().set((Number)family.value());
    }

    public final ProtocolFamily getFamily() {
        return ProtocolFamily.valueOf((int)this.getFamilyField().intValue());
    }

    public final void setPath(String path) {
        this.getPathField().set(path);
    }

    public final String getPath() {
        return this.getPathField().get();
    }

    public int getMaximumLength() {
        return 2 + this.getPathField().length();
    }

    public int length() {
        return 2 + SockAddrUnix.strlen(this.getPathField());
    }

    static SockAddrUnix create() {
        return Platform.getPlatform().isBSD() ? new BSDSockAddrUnix() : new DefaultSockAddrUnix();
    }

    private static final int strlen(Struct.UTF8String str) {
        int end = str.getMemory().indexOf(str.offset(), (byte)0);
        return end >= 0 ? end : str.length();
    }

    static final class BSDSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned8 sun_len = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 sun_family = new Struct.Unsigned8((Struct)this);
        public final Struct.UTF8String sun_addr = new Struct.UTF8String((Struct)this, 108);

        BSDSockAddrUnix() {
        }

        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }

    static final class DefaultSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned16 sun_family = new Struct.Unsigned16((Struct)this);
        public final Struct.UTF8String sun_addr = new Struct.UTF8String((Struct)this, 108);

        DefaultSockAddrUnix() {
        }

        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }
}

