/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanField;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.refactoring.ValuedQualifier;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.util.BeanUtil;

public class CDIMarkerResolutionUtils
extends MarkerResolutionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addQualifier(String qualifiedName, String value, ICompilationUnit compilationUnit, IJavaElement element, MultiTextEdit rootEdit) throws JavaModelException {
        if (!(element instanceof ISourceReference)) {
            return;
        }
        IAnnotation annotation = CDIMarkerResolutionUtils.findAnnotation((IJavaElement)element, (String)qualifiedName);
        if (annotation != null && annotation.exists()) {
            return;
        }
        boolean duplicateShortName = CDIMarkerResolutionUtils.addImport((String)qualifiedName, (ICompilationUnit)compilationUnit, (MultiTextEdit)rootEdit);
        String lineDelim = " ";
        IBuffer buffer = compilationUnit.getBuffer();
        String shortName = CDIMarkerResolutionUtils.getShortName((String)qualifiedName);
        if (!value.isEmpty()) {
            value = "(" + value + ")";
        }
        if (duplicateShortName) {
            shortName = qualifiedName;
        }
        annotation = CDIMarkerResolutionUtils.findAnnotation((IJavaElement)element, (String)"javax.inject.Inject");
        if (rootEdit != null) {
            if (annotation != null && annotation.exists()) {
                InsertEdit edit = new InsertEdit(annotation.getSourceRange().getOffset() + annotation.getSourceRange().getLength(), String.valueOf(lineDelim) + "@" + shortName + value);
                rootEdit.addChild((TextEdit)edit);
            } else {
                InsertEdit edit = new InsertEdit(((ISourceReference)element).getSourceRange().getOffset(), "@" + shortName + value + lineDelim);
                rootEdit.addChild((TextEdit)edit);
            }
        } else {
            if (annotation != null && annotation.exists()) {
                buffer.replace(annotation.getSourceRange().getOffset() + annotation.getSourceRange().getLength(), 0, String.valueOf(lineDelim) + "@" + shortName + value);
            } else {
                buffer.replace(((ISourceReference)element).getSourceRange().getOffset(), 0, "@" + shortName + value + lineDelim);
            }
            ICompilationUnit iCompilationUnit = compilationUnit;
            synchronized (iCompilationUnit) {
                compilationUnit.reconcile(0, true, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateQualifier(String qualifiedName, String value, ICompilationUnit compilationUnit, IJavaElement element, MultiTextEdit rootEdit) throws JavaModelException {
        if (!(element instanceof ISourceReference)) {
            return;
        }
        IAnnotation annotation = CDIMarkerResolutionUtils.findAnnotation((IJavaElement)element, (String)qualifiedName);
        if (annotation == null || !annotation.exists()) {
            return;
        }
        boolean duplicateShortName = CDIMarkerResolutionUtils.addImport((String)qualifiedName, (ICompilationUnit)compilationUnit, (MultiTextEdit)rootEdit);
        IBuffer buffer = compilationUnit.getBuffer();
        String shortName = CDIMarkerResolutionUtils.getShortName((String)qualifiedName);
        if (!value.isEmpty()) {
            value = "(" + value + ")";
        }
        if (duplicateShortName) {
            shortName = qualifiedName;
        }
        String newValue = "@" + shortName + value;
        if (!annotation.getSource().equals(newValue)) {
            if (rootEdit != null) {
                ReplaceEdit edit = new ReplaceEdit(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength(), newValue);
                rootEdit.addChild((TextEdit)edit);
            } else {
                buffer.replace(annotation.getSourceRange().getOffset(), annotation.getSourceRange().getLength(), newValue);
                ICompilationUnit iCompilationUnit = compilationUnit;
                synchronized (iCompilationUnit) {
                    compilationUnit.reconcile(0, true, null, null);
                }
            }
        }
    }

    private static boolean contains(IQualifierDeclaration declaration, List<ValuedQualifier> declarations) {
        for (ValuedQualifier d : declarations) {
            if (!declaration.getQualifier().getSourceType().getFullyQualifiedName().equals(d.getQualifier().getSourceType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static List<IQualifier> findQualifiersToDelete(IInjectionPoint injectionPoint, List<ValuedQualifier> qualifiers) {
        ArrayList<IQualifier> list = new ArrayList<IQualifier>();
        for (IQualifierDeclaration declaration : injectionPoint.getQualifierDeclarations()) {
            if (CDIMarkerResolutionUtils.contains(declaration, qualifiers)) continue;
            list.add(declaration.getQualifier());
        }
        return list;
    }

    public static ISourceRange getParameterRegion(IInjectionPointParameter injectionParameter) {
        try {
            String paramName = injectionParameter.getName();
            IMethod method = injectionParameter.getBeanMethod().getMethod();
            ILocalVariable[] iLocalVariableArray = method.getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable parameter = iLocalVariableArray[n2];
                if (parameter.getElementName().equals(paramName)) {
                    return parameter.getSourceRange();
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            CDICorePlugin.getDefault().logError(ex);
        }
        return null;
    }

    public static void addQualifiersToInjectionPoint(List<ValuedQualifier> deployed, IInjectionPoint injectionPoint, ICompilationUnit compilationUnit, MultiTextEdit edit) {
        try {
            IJavaElement element = CDIMarkerResolutionUtils.getInjectedJavaElement(compilationUnit, injectionPoint);
            if (element == null || !element.exists()) {
                return;
            }
            List<IQualifier> toDelete = CDIMarkerResolutionUtils.findQualifiersToDelete(injectionPoint, deployed);
            for (IQualifier qualifier : toDelete) {
                CDIMarkerResolutionUtils.deleteAnnotation((String)qualifier.getSourceType().getFullyQualifiedName(), (ICompilationUnit)compilationUnit, (IJavaElement)element, (MultiTextEdit)edit);
            }
            for (ValuedQualifier declaration : deployed) {
                String qualifierName = declaration.getQualifier().getSourceType().getFullyQualifiedName();
                String value = declaration.getValue();
                if (qualifierName.equals("javax.enterprise.inject.Any") || qualifierName.equals("javax.enterprise.inject.Default")) continue;
                CDIMarkerResolutionUtils.addQualifier(qualifierName, value, compilationUnit, element, edit);
                CDIMarkerResolutionUtils.updateQualifier(qualifierName, value, compilationUnit, element, edit);
            }
        }
        catch (CoreException ex) {
            CDICorePlugin.getDefault().logError(ex);
        }
    }

    public static void addQualifiersToBean(List<ValuedQualifier> deployed, IBean bean, ICompilationUnit compilationUnit, MultiTextEdit edit) {
        Object beanElement = null;
        beanElement = bean instanceof IBeanField ? ((IBeanField)((Object)bean)).getField() : (bean instanceof IBeanMethod ? ((IBeanMethod)((Object)bean)).getMethod() : bean.getBeanClass());
        try {
            for (IQualifierDeclaration declaration : bean.getQualifierDeclarations()) {
                IQualifier qualifier = declaration.getQualifier();
                String qualifierName = qualifier.getSourceType().getFullyQualifiedName();
                if (CDIMarkerResolutionUtils.isQualifierNeeded(deployed, qualifier)) continue;
                CDIMarkerResolutionUtils.deleteAnnotation((String)qualifierName, (ICompilationUnit)compilationUnit, (IJavaElement)beanElement, (MultiTextEdit)edit);
            }
            for (ValuedQualifier vq : deployed) {
                String qualifierName = vq.getQualifier().getSourceType().getFullyQualifiedName();
                String value = vq.getValue();
                String elName = "\"" + CDIMarkerResolutionUtils.getELName(bean) + "\"";
                value = !value.isEmpty() && (!value.equals(elName) || !qualifierName.equals("javax.inject.Named")) ? "(" + value + ")" : "";
                if (qualifierName.equals("javax.enterprise.inject.Any") || qualifierName.equals("javax.enterprise.inject.Default")) continue;
                CDIMarkerResolutionUtils.addAnnotation((String)qualifierName, (ICompilationUnit)compilationUnit, (IJavaElement)beanElement, (String)value, (MultiTextEdit)edit);
                CDIMarkerResolutionUtils.updateAnnotation((String)qualifierName, (ICompilationUnit)compilationUnit, (IJavaElement)beanElement, (String)value, (MultiTextEdit)edit);
            }
        }
        catch (CoreException ex) {
            CDICorePlugin.getDefault().logError(ex);
        }
    }

    private static boolean isQualifierNeeded(List<ValuedQualifier> vQualifiers, IQualifier qualifier) {
        for (ValuedQualifier vq : vQualifiers) {
            if (!vq.getQualifier().equals(qualifier)) continue;
            return true;
        }
        return false;
    }

    private static IJavaElement getInjectedJavaElement(ICompilationUnit compilationUnit, IInjectionPoint injectionPoint) throws JavaModelException {
        if (injectionPoint instanceof IInjectionPointField) {
            IField field = ((IInjectionPointField)injectionPoint).getField();
            IType type = field.getDeclaringType();
            IType t = compilationUnit.getType(type.getElementName());
            IField f = t.getField(field.getElementName());
            return f;
        }
        if (injectionPoint instanceof IInjectionPointParameter) {
            IMethod method = ((IInjectionPointParameter)injectionPoint).getBeanMethod().getMethod();
            IType type = method.getDeclaringType();
            IType t = compilationUnit.getType(type.getElementName());
            IMethod m = t.getMethod(method.getElementName(), method.getParameterTypes());
            ILocalVariable[] iLocalVariableArray = m.getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable parameter = iLocalVariableArray[n2];
                if (parameter.getElementName().equals(((IInjectionPointParameter)injectionPoint).getName())) {
                    return parameter;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean checkBeanQualifiers(IBean selectedBean, IBean bean, Collection<IQualifier> qualifiers) {
        ArrayList<ValuedQualifier> valuedQualifiers = new ArrayList<ValuedQualifier>();
        for (IQualifier qualifier : qualifiers) {
            valuedQualifiers.add(new ValuedQualifier(qualifier));
        }
        return CDIMarkerResolutionUtils.checkValuedQualifiers(selectedBean, bean, valuedQualifiers);
    }

    public static boolean checkValuedQualifiers(IBean selectedBean, IBean bean, Collection<ValuedQualifier> qualifiers) {
        for (ValuedQualifier qualifier : qualifiers) {
            if (CDIMarkerResolutionUtils.isBeanContainQualifier(bean, qualifier)) continue;
            return false;
        }
        return bean.getQualifiers().size() == qualifiers.size() && bean.getQualifiers().size() != 0;
    }

    private static boolean isBeanContainQualifier(IBean bean, ValuedQualifier valuedQualifier) {
        for (IQualifier q : bean.getQualifiers()) {
            IQualifierDeclaration declaration = CDIMarkerResolutionUtils.findQualifierDeclaration(bean, q);
            ValuedQualifier vq = null;
            vq = declaration != null ? new ValuedQualifier(q, declaration) : new ValuedQualifier(q);
            if (!vq.fullyEquals(valuedQualifier)) continue;
            return true;
        }
        return false;
    }

    public static IQualifierDeclaration findQualifierDeclaration(IBean bean, IQualifier qualifier) {
        Collection<IQualifierDeclaration> declarations = bean.getQualifierDeclarations();
        if (declarations == null) {
            return null;
        }
        for (IQualifierDeclaration declaration : declarations) {
            if (!declaration.getQualifier().getSourceType().getFullyQualifiedName().equals(qualifier.getSourceType().getFullyQualifiedName())) continue;
            return declaration;
        }
        return null;
    }

    public static String getELName(IBean bean) {
        String name;
        if (bean instanceof IBeanField) {
            name = ((IBeanField)((Object)bean)).getField().getElementName();
        } else if (bean instanceof IBeanMethod) {
            name = ((IBeanMethod)((Object)bean)).getMethod().getElementName();
            if (BeanUtil.isGetter((IMethod)((IBeanMethod)((Object)bean)).getMethod())) {
                return BeanUtil.getPropertyName((String)name);
            }
        } else {
            name = BeanUtil.getDefaultBeanName((IType)bean.getBeanClass());
        }
        return name;
    }
}

