/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IBuiltInBean;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDICache;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IExcluded;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IObserverMethod;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerField;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.extension.feature.IAmbiguousBeanResolverFeature;
import org.jboss.tools.cdi.core.extension.feature.IBeanStoreFeature;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.event.CDIProjectChangeEvent;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeansXMLData;
import org.jboss.tools.cdi.internal.core.impl.BuiltInBeanFactory;
import org.jboss.tools.cdi.internal.core.impl.CDIAnnotationElement;
import org.jboss.tools.cdi.internal.core.impl.CDICache;
import org.jboss.tools.cdi.internal.core.impl.CDIElement;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.DecoratorBean;
import org.jboss.tools.cdi.internal.core.impl.EventBean;
import org.jboss.tools.cdi.internal.core.impl.Excluded;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBean;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBindingElement;
import org.jboss.tools.cdi.internal.core.impl.NewBean;
import org.jboss.tools.cdi.internal.core.impl.QualifierElement;
import org.jboss.tools.cdi.internal.core.impl.ScopeElement;
import org.jboss.tools.cdi.internal.core.impl.SessionBean;
import org.jboss.tools.cdi.internal.core.impl.StereotypeElement;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeansXMLDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.ImplementationCollector;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.INodeReference;

public class CDIProject
extends CDIElement
implements ICDIProject,
Cloneable {
    CDICoreNature n;
    private ICDIProject declaringProject = this;
    private CDICache cache = new CDICache();
    private ICDICache dbCache;
    BeansXMLData allBeansXMLData = new BeansXMLData();
    BeansXMLData projectBeansXMLData = new BeansXMLData();
    static int q = 0;
    private boolean cleanClassCacheWhenRebuildBeans = true;

    @Override
    public CDIVersion getVersion() {
        return this.n.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDIProject getModifiedCopy(IFile file, Collection<IBean> beans) {
        CDIProject p = null;
        try {
            p = (CDIProject)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            p.cache = this.cache.getModifiedCopy(file, beans);
        }
        p.declaringProject = this;
        return p;
    }

    @Override
    public CDICoreNature getNature() {
        return this.n;
    }

    @Override
    public void setNature(CDICoreNature n) {
        this.n = n;
    }

    @Override
    public boolean exists() {
        return this.n != null && this.n.getProject() != null && this.n.getProject().isAccessible();
    }

    @Override
    public IBean[] getBeans() {
        return this.cache.getBeans();
    }

    public Collection<IBean> getDeclaredBeans() {
        return this.cache.getDeclaredBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getAlternativeClasses() {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            result.addAll(this.allBeansXMLData.getTypeAlternatives());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getAlternativeStereotypes() {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            result.addAll(this.allBeansXMLData.getStereotypeAlternatives());
        }
        return result;
    }

    @Override
    public boolean isClassAlternativeActivated(String fullQualifiedTypeName) {
        return this.allBeansXMLData.getTypeAlternativeTypes().contains(fullQualifiedTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getAlternatives(String fullQualifiedTypeName) {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            Collection<INodeReference> typeAlternatives = this.allBeansXMLData.getTypeAlternatives();
            Collection<INodeReference> stereotypeAlternatives = this.allBeansXMLData.getStereotypeAlternatives();
            for (INodeReference r : typeAlternatives) {
                if (!fullQualifiedTypeName.equals(r.getValue())) continue;
                result.add(r);
            }
            for (INodeReference r : stereotypeAlternatives) {
                if (!fullQualifiedTypeName.equals(r.getValue())) continue;
                result.add(r);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassBean getBeanClass(IType type) {
        IPath path = type.getPath();
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            Collection<IBean> bs = this.cache.getBeans(path);
            for (IBean b : bs) {
                if (!(b instanceof IClassBean)) continue;
                IClassBean result = (IClassBean)b;
                if (!type.getFullyQualifiedName().equals(result.getBeanClass().getFullyQualifiedName())) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IBean> getBeans(String name, boolean attemptToResolveAmbiguousNames) {
        HashSet<IBean> result = new HashSet<IBean>();
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            Collection<IBean> beans = this.cache.getBeans(name);
            if (beans.isEmpty()) {
                return result;
            }
            result.addAll(beans);
        }
        return this.getResolvedBeans(result, attemptToResolveAmbiguousNames);
    }

    public Collection<IBean> getResolvedBeans(Collection<IBean> result, boolean attemptToResolveAmbiguousness) {
        IBean b;
        Iterator<IBean> it;
        if (result.size() > 1) {
            it = result.iterator();
            IBean bib = null;
            int c = 0;
            while (it.hasNext()) {
                b = it.next();
                if (!(b instanceof IBuiltInBean)) continue;
                bib = b;
                ++c;
            }
            if (bib != null && c == 1) {
                result.remove(bib);
            }
        }
        if (result.isEmpty() || !attemptToResolveAmbiguousness) {
            return result;
        }
        it = result.iterator();
        HashSet<IBean> disabled = null;
        HashSet<IBean> alternatives = null;
        while (it.hasNext()) {
            IBean bean;
            IBeanMember p;
            b = it.next();
            if (!b.isEnabled() || b instanceof IDecorator || b instanceof IInterceptor) {
                it.remove();
                continue;
            }
            if (b.isAlternative()) {
                if (b.isSelectedAlternative()) {
                    if (alternatives == null) {
                        alternatives = new HashSet();
                    }
                    alternatives.add(b);
                } else {
                    it.remove();
                }
            }
            if (b instanceof IProducer && b instanceof IBeanMember && (p = (IBeanMember)((Object)b)).getClassBean() != null && p.getClassBean().isAlternative()) {
                if (alternatives == null) {
                    alternatives = new HashSet();
                }
                alternatives.add(b);
            }
            if ((bean = b.getSpecializedBean()) == null || !b.isEnabled()) continue;
            if (disabled == null) {
                disabled = new HashSet<IBean>();
            }
            disabled.add(bean);
        }
        if (disabled != null) {
            result.removeAll(disabled);
        }
        if (result.size() < 2) {
            return result;
        }
        if (alternatives != null) {
            result = alternatives;
            if (result.size() < 2) {
                return result;
            }
            alternatives = new HashSet<IBean>();
            Integer maxPriority = null;
            for (IBean b2 : result) {
                Integer priority = null;
                if (b2 instanceof IClassBean) {
                    priority = ((IClassBean)b2).getPriority();
                } else if (b2 instanceof IProducer && b2 instanceof IBeanMember) {
                    priority = ((IBeanMember)((Object)b2)).getClassBean().getPriority();
                }
                if (priority == null) {
                    maxPriority = null;
                    break;
                }
                if (maxPriority == null) {
                    maxPriority = priority;
                    alternatives.add(b2);
                    continue;
                }
                if (priority > maxPriority) {
                    maxPriority = priority;
                    alternatives.clear();
                    alternatives.add(b2);
                    continue;
                }
                if (priority.intValue() != maxPriority.intValue()) continue;
                alternatives.add(b2);
            }
            if (maxPriority != null) {
                result = alternatives;
            }
        }
        if (result.size() > 1) {
            Set<IAmbiguousBeanResolverFeature> extensions = this.getExtensionManager().getAmbiguousBeanResolverFeatures();
            for (IAmbiguousBeanResolverFeature e : extensions) {
                result = e.getResolvedBeans(result);
                if (result.size() >= 2) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IParametedType beanType, IQualifierDeclaration ... qualifiers) {
        int n;
        int n2;
        Object[] objectArray;
        HashSet<IBean> result = new HashSet<IBean>();
        IParametedType type = beanType;
        if (type == null) {
            return result;
        }
        HashSet<IQualifierDeclaration> qs = new HashSet<IQualifierDeclaration>();
        if (qualifiers != null) {
            objectArray = qualifiers;
            n2 = qualifiers.length;
            n = 0;
            while (n < n2) {
                Object d = objectArray[n];
                qs.add((IQualifierDeclaration)d);
                ++n;
            }
        }
        objectArray = this.cache.getBeansByLegalType(type);
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object b = objectArray[n];
            if (CDIProject.containsType(b.getLegalTypes(), type)) {
                try {
                    Collection<IQualifierDeclaration> qsb = b.getQualifierDeclarations(true);
                    if (CDIProject.areMatchingQualifiers(qsb, qs)) {
                        result.add((IBean)b);
                    }
                }
                catch (CoreException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
            ++n;
        }
        return this.getResolvedBeans(result, attemptToResolveAmbiguousDependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IInjectionPoint injectionPoint) {
        List ps;
        boolean isObjectType;
        if (injectionPoint.getDeclaringProject() != this.getDeclaringProject()) {
            return injectionPoint.getDeclaringProject().getBeans(attemptToResolveAmbiguousDependency, injectionPoint);
        }
        HashSet<IBean> result = new HashSet<IBean>();
        IParametedType type = injectionPoint.getType();
        if (type == null) {
            return result;
        }
        IType jType = type.getType();
        boolean bl = isObjectType = jType != null && "java.lang.Object".equals(jType.getFullyQualifiedName());
        if (isObjectType && injectionPoint.getAnnotation("javax.enterprise.inject.Any") != null) {
            CDICache cDICache = this.cache;
            synchronized (cDICache) {
                result.addAll(this.cache.getAllBeans());
            }
            return this.getResolvedBeans(result, attemptToResolveAmbiguousDependency);
        }
        if (jType != null && "javax.enterprise.event.Event".equals(jType.getFullyQualifiedName()) && (ps = type.getParameters()).size() == 1) {
            EventBean eventBean = new EventBean(type, injectionPoint);
            eventBean.setParent(this);
            eventBean.setSourcePath(injectionPoint.getSourcePath());
            result.add(eventBean);
            return result;
        }
        if (jType != null && ("javax.enterprise.inject.Instance".equals(jType.getFullyQualifiedName()) || "javax.inject.Provider".equals(jType.getFullyQualifiedName())) && (ps = type.getParameters()).size() == 1) {
            type = (IParametedType)ps.get(0);
        }
        Collection<IQualifierDeclaration> qs = injectionPoint.getQualifierDeclarations();
        for (IQualifierDeclaration d : qs) {
            if (!"javax.enterprise.inject.New".equals(d.getTypeName())) continue;
            IBean b = this.createNewBean(type, d);
            if (b != null && CDIProject.containsType(b.getLegalTypes(), type)) {
                result.add(b);
            }
            return result;
        }
        boolean delegateInjectionPoint = injectionPoint.isDelegate();
        String injectionPointName = injectionPoint.getBeanName();
        if (this.dbCache != null && type.getType() != null) {
            this.dbCache.getBeansByLegalType(this, type.getType().getFullyQualifiedName());
        }
        IBean[] iBeanArray = this.cache.getBeansByLegalType(type);
        int n = iBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBean b = iBeanArray[n2];
            if (isObjectType || CDIProject.containsType(b.getLegalTypes(), type)) {
                try {
                    Collection<IQualifierDeclaration> qsb;
                    if (!(delegateInjectionPoint && b == injectionPoint.getClassBean() || injectionPointName != null && !injectionPointName.equals(b.getName()) || !CDIProject.areMatchingQualifiers(qsb = b.getQualifierDeclarations(true), qs))) {
                        result.add(b);
                    }
                }
                catch (CoreException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
            ++n2;
        }
        return this.getResolvedBeans(result, attemptToResolveAmbiguousDependency);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBean createNewBean(IParametedType type, IAnnotationDeclaration newDeclaration) {
        IType t = type.getType();
        if (t == null || !t.exists()) {
            return null;
        }
        try {
            IAnnotationDeclaration[] as;
            if (newDeclaration.getJavaAnnotation() == null) {
                return null;
            }
            IJavaElement dType = newDeclaration.getJavaAnnotation().getAncestor(7);
            if (!(dType instanceof IType)) {
                return null;
            }
            Object value = newDeclaration.getMemberValue(null);
            if (value != null && value.toString().length() > 0) {
                String s;
                ParametedType p = this.getNature().getTypeFactory().getParametedType((IMember)((IType)dType), "Q" + value.toString() + ";");
                if (p != null && p.getType() != null && p.getType().getTypeParameters().length > 0 && (s = type.getSignature()).indexOf("<") >= 0 && s.lastIndexOf(62) > 0) {
                    String cls = String.valueOf(value.toString()) + s.substring(s.indexOf(60), s.lastIndexOf(62) + 1);
                    ParametedType p1 = this.getNature().getTypeFactory().getParametedType((IMember)((IType)dType), "Q" + cls + ";");
                    if (p1 != null) {
                        p = p1;
                    }
                }
                if (p == null) {
                    return null;
                }
                p.getAllTypes();
                type = p;
                t = p.getType();
            }
            if (t.isInterface()) {
                return null;
            }
            TypeDefinition def = new TypeDefinition();
            def.setType(type.getType(), this.getNature().getDefinitions(), 0);
            def.setParametedType(type);
            if (!def.hasBeanConstructor()) {
                return null;
            }
            Iterator<MethodDefinition> ms = def.getMethods().iterator();
            while (ms.hasNext()) {
                MethodDefinition m = ms.next();
                if (!m.isObserver() && !m.isDisposer() && !m.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
                ms.remove();
            }
            Iterator<FieldDefinition> fs = def.getFields().iterator();
            while (fs.hasNext()) {
                FieldDefinition f = fs.next();
                if (!f.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
                fs.remove();
            }
            IAnnotationDeclaration[] iAnnotationDeclarationArray = as = def.getAnnotations().toArray(new IAnnotationDeclaration[0]);
            int n = as.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationDeclaration a = iAnnotationDeclarationArray[n2];
                if (a instanceof IQualifierDeclaration || a instanceof IStereotypeDeclaration) {
                    def.removeAnnotation(a);
                }
                ++n2;
            }
            def.addAnnotation(((AnnotationDeclaration)newDeclaration).getDeclaration(), this.getNature().getDefinitions());
            NewBean cb = new NewBean();
            cb.setParent(this);
            cb.setDefinition(def);
            return cb;
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
            return null;
        }
    }

    public static boolean containsType(Collection<IParametedType> types, IParametedType type) {
        if (type == null) {
            return false;
        }
        IType jType = type.getType();
        if (jType == null) {
            return false;
        }
        String typeName = jType.getFullyQualifiedName();
        for (IParametedType t : types) {
            IType jType1 = t.getType();
            if (jType1 == null || !jType.getElementName().equals(jType1.getElementName()) || !typeName.equals(jType1.getFullyQualifiedName()) || ((ParametedType)t).getArrayIndex() != ((ParametedType)type).getArrayIndex() || !((ParametedType)t).isAssignableTo((ParametedType)type, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean areMatchingQualifiers(Collection<IQualifierDeclaration> beanQualifiers, Collection<IQualifierDeclaration> injectionQualifiers) throws CoreException {
        if (beanQualifiers.isEmpty() && injectionQualifiers.isEmpty()) {
            return true;
        }
        HashSet<String> keys = new HashSet<String>();
        for (IQualifierDeclaration d : injectionQualifiers) {
            keys.add(CDIProject.getAnnotationDeclarationKey(d));
        }
        if (keys.contains("javax.enterprise.inject.Any")) {
            return true;
        }
        if (keys.isEmpty()) {
            keys.add("javax.enterprise.inject.Default");
        }
        if (beanQualifiers.isEmpty()) {
            keys.remove("javax.enterprise.inject.Default");
        } else {
            int beanKeySize = 0;
            String beanKey = null;
            for (IQualifierDeclaration d : beanQualifiers) {
                ++beanKeySize;
                beanKey = CDIProject.getAnnotationDeclarationKey(d);
                keys.remove(beanKey);
            }
            if (beanKeySize == 1 && beanKey.startsWith("javax.inject.Named")) {
                keys.remove("javax.enterprise.inject.Default");
            }
        }
        return keys.isEmpty();
    }

    public static boolean areMatchingQualifiers(Collection<IQualifierDeclaration> beanQualifiers, IType ... injectionQualifiers) throws CoreException {
        if (beanQualifiers.isEmpty() && injectionQualifiers.length == 0) {
            return true;
        }
        HashSet<String> keys = new HashSet<String>();
        IType[] iTypeArray = injectionQualifiers;
        int n = injectionQualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            IType d = iTypeArray[n2];
            keys.add(d.getFullyQualifiedName().replace('$', '.'));
            ++n2;
        }
        if (keys.contains("javax.enterprise.inject.Any")) {
            return true;
        }
        if (keys.isEmpty()) {
            keys.add("javax.enterprise.inject.Default");
        }
        if (beanQualifiers.isEmpty()) {
            keys.remove("javax.enterprise.inject.Default");
        } else {
            int beanKeySize = 0;
            String beanKey = null;
            for (IAnnotationDeclaration iAnnotationDeclaration : beanQualifiers) {
                ++beanKeySize;
                beanKey = iAnnotationDeclaration.getTypeName().replace('$', '.');
                keys.remove(beanKey);
            }
            if (beanKeySize == 1 && beanKey.startsWith("javax.inject.Named")) {
                keys.remove("javax.enterprise.inject.Default");
            }
        }
        return keys.isEmpty();
    }

    public static boolean areMatchingEventQualifiers(Collection<IQualifierDeclaration> eventQualifiers, Collection<IQualifierDeclaration> paramQualifiers) throws CoreException {
        if (!paramQualifiers.isEmpty()) {
            TreeSet<String> paramKeys = new TreeSet<String>();
            for (IQualifierDeclaration d : paramQualifiers) {
                paramKeys.add(CDIProject.getAnnotationDeclarationKey(d));
            }
            TreeSet<String> eventKeys = new TreeSet<String>();
            for (IAnnotationDeclaration iAnnotationDeclaration : eventQualifiers) {
                eventKeys.add(CDIProject.getAnnotationDeclarationKey(iAnnotationDeclaration));
            }
            if (!eventKeys.contains("javax.enterprise.inject.Any")) {
                eventKeys.add("javax.enterprise.inject.Any");
            }
            for (String string : paramKeys) {
                if (eventKeys.contains(string)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getAnnotationDeclarationKey(IAnnotationDeclaration d) throws CoreException {
        ICDIAnnotation annotation = (ICDIAnnotation)d.getAnnotation();
        HashSet<IMethod> nb = annotation == null ? new HashSet() : annotation.getNonBindingMethods();
        return CDIProject.getAnnotationDeclarationKey(d, nb);
    }

    private static String getAnnotationDeclarationKey(IAnnotationDeclaration d, Collection<IMethod> ignoredMembers) throws CoreException {
        ArrayList nb = ignoredMembers == null ? new ArrayList() : ignoredMembers;
        StringBuffer result = new StringBuffer();
        result.append(d.getTypeName());
        if ("javax.inject.Named".equals(d.getTypeName())) {
            return result.toString();
        }
        IType type = d.getType();
        if (type == null) {
            return "";
        }
        IMethod[] ms = type.getMethods();
        if (ms.length > 0) {
            String n;
            int n2;
            int n3;
            IMemberValuePair[] iMemberValuePairArray;
            TreeMap<String, String> values = new TreeMap<String, String>();
            IMemberValuePair[] ps = d.getMemberValuePairs();
            if (ps != null) {
                iMemberValuePairArray = ps;
                n3 = ps.length;
                n2 = 0;
                while (n2 < n3) {
                    IMemberValuePair p = iMemberValuePairArray[n2];
                    n = p.getMemberName();
                    Object o = null;
                    if (d instanceof AnnotationDeclaration) {
                        o = ((AnnotationDeclaration)d).getMemberConstantValue(n);
                    }
                    if (o == null) {
                        o = d.getMemberValue(n);
                    }
                    values.put(n, o == null ? "" : o.toString());
                    ++n2;
                }
            }
            iMemberValuePairArray = ms;
            n3 = ms.length;
            n2 = 0;
            while (n2 < n3) {
                IMemberValuePair p;
                IMemberValuePair m = iMemberValuePairArray[n2];
                n = m.getElementName();
                if (nb.contains(m)) {
                    values.remove(n);
                } else if (!values.containsKey(n) && (p = m.getDefaultValue()) != null) {
                    n = p.getMemberName();
                    Object o = p.getValue();
                    if (o == null) {
                        o = ((AnnotationDeclaration)d).getMemberDefaultValue(n);
                    }
                    if (!values.containsKey(n) && o != null) {
                        values.put(n, o.toString());
                    }
                }
                ++n2;
            }
            for (String n4 : values.keySet()) {
                result.append(';').append(n4).append('=').append((String)values.get(n4));
            }
        }
        return result.toString();
    }

    @Override
    public Collection<IBean> getBeans(IPath path) {
        return this.cache.getBeans(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IBean> getBeans(IJavaElement element) {
        HashSet<IBean> result = new HashSet<IBean>();
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            for (IBean bean : this.cache.getAllBeans()) {
                if (!(bean instanceof IJavaReference) || !((IJavaReference)bean).getSourceMember().equals(element)) continue;
                result.add(bean);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getDecoratorClasses() {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            result.addAll(this.allBeansXMLData.getDecorators());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getDecoratorClasses(String fullQualifiedTypeName) {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            for (INodeReference r : this.allBeansXMLData.getDecorators()) {
                if (!fullQualifiedTypeName.equals(r.getValue())) continue;
                result.add(r);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getInterceptorClasses() {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            result.addAll(this.allBeansXMLData.getInterceptors());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INodeReference> getInterceptorClasses(String fullQualifiedTypeName) {
        ArrayList<INodeReference> result = new ArrayList<INodeReference>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            for (INodeReference r : this.allBeansXMLData.getInterceptors()) {
                if (!fullQualifiedTypeName.equals(r.getValue())) continue;
                result.add(r);
            }
        }
        return result;
    }

    @Override
    public boolean isTypeAlternative(String qualifiedName) {
        return this.projectBeansXMLData.getTypeAlternativeTypes().contains(qualifiedName);
    }

    @Override
    public boolean isStereotypeAlternative(String qualifiedName) {
        return this.projectBeansXMLData.getStereotypeAlternativeTypes().contains(qualifiedName);
    }

    public Set<IType> getQualifierTypes() {
        HashSet<IType> result = new HashSet<IType>();
        List<AnnotationDefinition> ds = this.n.getDefinitions().getAllAnnotations();
        for (AnnotationDefinition d : ds) {
            if ((d.getKind() & 4) <= 0) continue;
            result.add(d.getType());
        }
        return result;
    }

    @Override
    public IQualifier[] getQualifiers() {
        return this.cache.getQualifiers();
    }

    @Override
    public IStereotype[] getStereotypes() {
        return this.cache.getStereotypes();
    }

    @Override
    public IBean[] getAlternatives() {
        return this.cache.getAlternatives();
    }

    @Override
    public IDecorator[] getDecorators() {
        return this.cache.getDecorators();
    }

    @Override
    public IInterceptor[] getInterceptors() {
        return this.cache.getInterceptors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNormalScope(IType annotationType) {
        try {
            AnnotationDeclaration aa;
            IAnnotationDeclaration a;
            if (!annotationType.isAnnotation()) return false;
            AnnotationDefinition d = this.n.getDefinitions().getAnnotation(annotationType);
            List<IAnnotationDeclaration> ds = d.getAnnotations();
            Iterator<IAnnotationDeclaration> iterator = ds.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((a = iterator.next()) instanceof AnnotationDeclaration) || !"javax.enterprise.context.NormalScope".equals((aa = (AnnotationDeclaration)a).getTypeName()));
            return true;
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return false;
    }

    @Override
    public boolean isPassivatingScope(IType annotationType) {
        try {
            if (annotationType.isAnnotation()) {
                AnnotationDefinition d = this.n.getDefinitions().getAnnotation(annotationType);
                List<IAnnotationDeclaration> ds = d.getAnnotations();
                for (IAnnotationDeclaration a : ds) {
                    AnnotationDeclaration aa;
                    if (!(a instanceof AnnotationDeclaration) || !"javax.enterprise.context.NormalScope".equals((aa = (AnnotationDeclaration)a).getTypeName())) continue;
                    Object o = a.getMemberValue("passivating");
                    return o != null && "true".equalsIgnoreCase(o.toString());
                }
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return false;
    }

    @Override
    public boolean isQualifier(IType annotationType) {
        boolean result = false;
        try {
            if (annotationType.isAnnotation()) {
                int k = this.n.getDefinitions().getAnnotationKind(annotationType);
                result = k > 0 && (k & 4) > 0;
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return result;
    }

    @Override
    public boolean isScope(IType annotationType) {
        boolean result = false;
        try {
            if (annotationType.isAnnotation()) {
                int k = this.n.getDefinitions().getAnnotationKind(annotationType);
                result = k > 0 && (k & 0x20) > 0;
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return result;
    }

    @Override
    public boolean isStereotype(IType annotationType) {
        boolean result = false;
        try {
            if (annotationType.isAnnotation()) {
                int k = this.n.getDefinitions().getAnnotationKind(annotationType);
                result = k > 0 && (k & 8) > 0;
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return result;
    }

    @Override
    public Collection<IBean> resolve(Collection<IBean> beans) {
        if (beans.size() <= 1) {
            return beans;
        }
        HashSet<IBean> result = new HashSet<IBean>();
        for (IBean bean : beans) {
            if (!bean.isAlternative()) continue;
            bean.getBeanClass();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IObserverMethod> resolveObserverMethods(IInjectionPoint injectionPoint) {
        ArrayList<IObserverMethod> result = new ArrayList<IObserverMethod>();
        IParametedType eventType = this.getEventType(injectionPoint);
        if (eventType != null) {
            CDICoreNature[] ns;
            CDICache cDICache = this.cache;
            synchronized (cDICache) {
                for (IBean b : this.cache.getAllBeans()) {
                    if (!(b instanceof IClassBean)) continue;
                    this.collectObserverMethods((IClassBean)b, eventType, injectionPoint, result);
                }
            }
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int b = 0;
            while (b < n) {
                IProject p = iProjectArray[b];
                if (p.isAccessible()) {
                    CDICorePlugin.getCDI(p, true);
                }
                ++b;
            }
            CDICoreNature[] cDICoreNatureArray = ns = this.getNature().getAllDependentProjects(true);
            int n2 = ns.length;
            n = 0;
            while (n < n2) {
                CDICoreNature n3 = cDICoreNatureArray[n];
                if (n3.getDelegate() instanceof CDIProject) {
                    CDIProject p = (CDIProject)n3.getDelegate();
                    for (IBean b2 : p.getDeclaredBeans()) {
                        if (!(b2 instanceof IClassBean)) continue;
                        this.collectObserverMethods((IClassBean)b2, eventType, injectionPoint, result);
                    }
                }
                ++n;
            }
        }
        return result;
    }

    private void collectObserverMethods(IClassBean b, IParametedType eventType, IInjectionPoint injectionPoint, Collection<IObserverMethod> result) {
        for (IObserverMethod m : b.getObserverMethods()) {
            IParameter param;
            IParametedType paramType;
            Collection<IParameter> params = m.getObservedParameters();
            if (params.isEmpty() || !((ParametedType)eventType).isAssignableTo((ParametedType)(paramType = (param = params.iterator().next()).getType()), true) || !this.areMatchingEventQualifiers(param, injectionPoint)) continue;
            result.add(m);
        }
    }

    private IParametedType getEventType(IInjectionPoint p) {
        IParametedType t = p.getType();
        if (t == null || t.getType() == null || !"javax.enterprise.event.Event".equals(t.getType().getFullyQualifiedName())) {
            return null;
        }
        List ps = t.getParameters();
        return ps.isEmpty() ? null : (IParametedType)ps.get(0);
    }

    private boolean areMatchingEventQualifiers(IParameter observerParam, IInjectionPoint event) {
        try {
            return CDIProject.areMatchingEventQualifiers(event.getQualifierDeclarations(), observerParam.getQualifierDeclarations());
        }
        catch (CoreException err) {
            CDICorePlugin.getDefault().logError(err);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IInjectionPoint> findObservedEvents(IParameter observedEventParameter) {
        HashMap<IField, IInjectionPoint> result = new HashMap<IField, IInjectionPoint>();
        if (observedEventParameter.getBeanMethod() instanceof IObserverMethod) {
            CDICoreNature[] ns;
            CDICache cDICache = this.cache;
            synchronized (cDICache) {
                for (IBean b : this.cache.getAllBeans()) {
                    if (!(b instanceof IClassBean)) continue;
                    this.collectObserverEvents((IClassBean)b, observedEventParameter, result);
                }
            }
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int b = 0;
            while (b < n) {
                IProject p = iProjectArray[b];
                if (p.isAccessible()) {
                    CDICorePlugin.getCDI(p, true);
                }
                ++b;
            }
            CDICoreNature[] cDICoreNatureArray = ns = this.getNature().getAllDependentProjects(true);
            int n2 = ns.length;
            n = 0;
            while (n < n2) {
                CDICoreNature n3 = cDICoreNatureArray[n];
                if (n3.getDelegate() instanceof CDIProject) {
                    CDIProject p = (CDIProject)n3.getDelegate();
                    for (IBean b2 : p.getDeclaredBeans()) {
                        if (!(b2 instanceof IClassBean)) continue;
                        this.collectObserverEvents((IClassBean)b2, observedEventParameter, result);
                    }
                }
                ++n;
            }
        }
        return new HashSet<IInjectionPoint>(result.values());
    }

    private void collectObserverEvents(IClassBean b, IParameter observedEventParameter, Map<IField, IInjectionPoint> result) {
        Collection<IInjectionPoint> ps = b.getInjectionPoints();
        for (IInjectionPoint p : ps) {
            IParametedType eventType;
            if (!(p instanceof IInjectionPointField) || (eventType = this.getEventType(p)) == null || !((ParametedType)eventType).isAssignableTo((ParametedType)observedEventParameter.getType(), true) || !this.areMatchingEventQualifiers(observedEventParameter, p)) continue;
            result.put(((IInjectionPointField)p).getField(), p);
        }
    }

    public Set<IBeanMethod> resolveDisposers(IProducerMethod producer) {
        return this.resolveDisposersInternal(producer);
    }

    public Set<IBeanMethod> resolveDisposers(IProducer producer) {
        if (this.getCDIProject().getVersion() == CDIVersion.CDI_1_0 && producer instanceof IProducerField) {
            return Collections.emptySet();
        }
        return this.resolveDisposersInternal(producer);
    }

    private Set<IBeanMethod> resolveDisposersInternal(IProducer producer) {
        HashSet<IBeanMethod> result = new HashSet<IBeanMethod>();
        IClassBean cb = producer.getClassBean();
        if (cb != null) {
            Collection<IParametedType> types = producer.getLegalTypes();
            Collection<IQualifierDeclaration> qs = producer.getQualifierDeclarations(true);
            for (IBeanMethod m : cb.getDisposers()) {
                List<IParameter> ps = m.getParameters();
                IParameter match = null;
                for (IParameter p : ps) {
                    IParametedType type;
                    if (!p.isAnnotationPresent("javax.enterprise.inject.Disposes") || !CDIProject.containsType(types, type = p.getType())) continue;
                    try {
                        if (!CDIProject.areMatchingQualifiers(qs, p.getQualifierDeclarations())) continue;
                        match = p;
                        break;
                    }
                    catch (CoreException e) {
                        CDICorePlugin.getDefault().logError(e);
                    }
                }
                if (match == null) continue;
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public CDIProject getCDIProject() {
        return this;
    }

    @Override
    public ICDIProject getDeclaringProject() {
        return this.declaringProject;
    }

    @Override
    public IResource getResource() {
        return this.n.getProject();
    }

    @Override
    public IPath getSourcePath() {
        return this.n.getProject().getFullPath();
    }

    @Override
    public StereotypeElement getStereotype(String qualifiedName) {
        return this.cache.getStereotype(qualifiedName);
    }

    @Override
    public StereotypeElement getStereotype(IPath path) {
        return this.cache.getStereotype(path);
    }

    @Override
    public StereotypeElement getStereotype(IType type) {
        return this.getStereotype(type.getPath());
    }

    @Override
    public IInterceptorBinding[] getInterceptorBindings() {
        return this.cache.getInterceptorBindings();
    }

    @Override
    public InterceptorBindingElement getInterceptorBinding(String qualifiedName) {
        return this.cache.getInterceptorBinding(qualifiedName);
    }

    @Override
    public IInterceptorBinding getInterceptorBinding(IPath path) {
        return this.cache.getInterceptorBinding(path);
    }

    @Override
    public QualifierElement getQualifier(String qualifiedName) {
        return this.cache.getQualifier(qualifiedName);
    }

    @Override
    public QualifierElement getQualifier(IPath path) {
        return this.cache.getQualifier(path);
    }

    public Set<String> getScopeNames() {
        return this.cache.getScopeNames();
    }

    @Override
    public ScopeElement getScope(String qualifiedName) {
        return this.cache.getScope(qualifiedName);
    }

    @Override
    public IScope getScope(IPath path) {
        return this.cache.getScope(path);
    }

    public void updateIncremental(boolean updateDependent) {
        this.cleanClassCacheWhenRebuildBeans = false;
        try {
            this.update(false);
            if (updateDependent) {
                CDICoreNature[] ps;
                CDICoreNature[] cDICoreNatureArray = ps = this.n.getAllDependentProjects();
                int n = ps.length;
                int n2 = 0;
                while (n2 < n) {
                    CDICoreNature p = cDICoreNatureArray[n2];
                    if (p.getProject() != null && p.getProject().isAccessible() && p.getDelegate() != null) {
                        ((CDIProject)p.getDelegate()).updateIncremental(false);
                    }
                    ++n2;
                }
            }
        }
        finally {
            this.cleanClassCacheWhenRebuildBeans = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(boolean updateDependent) {
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            this.rebuildXML();
            this.rebuildAnnotationTypes();
            this.rebuildBeans();
            Set<IBuildParticipantFeature> buildParticipants = this.n.getExtensionManager().getBuildParticipantFeatures();
            for (IBuildParticipantFeature p : buildParticipants) {
                p.buildBeans(this);
            }
            Set<CDICoreNature> ds = this.n.getCDIProjects(true);
            for (CDICoreNature c : ds) {
                Set<IBuildParticipantFeature> bs = c.getExtensionManager().getBuildParticipantFeatures();
                Iterator<IBuildParticipantFeature> iterator = bs.iterator();
                while (iterator.hasNext()) {
                    IBuildParticipantFeature bp = iterator.next();
                    bp.buildBeans(this);
                }
            }
            if (this.dbCache != null) {
                this.dbCache.rebuild(this, this.cache.getAllBeans());
            }
            Set<IBeanStoreFeature> beanStores = this.n.getExtensionManager().getFeatures(IBeanStoreFeature.class);
            for (IBeanStoreFeature bp : beanStores) {
                bp.updateCaches(this);
            }
            if (updateDependent) {
                CDICoreNature[] ps;
                CDICoreNature[] cDICoreNatureArray = ps = this.n.getAllDependentProjects();
                int n = ps.length;
                int n2 = 0;
                while (n2 < n) {
                    CDICoreNature p = cDICoreNatureArray[n2];
                    if (p.getProject() != null && p.getProject().isAccessible() && p.getDelegate() != null) {
                        p.getDelegate().update(false);
                    }
                    ++n2;
                }
            }
            CDICorePlugin.fire(new CDIProjectChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildAnnotationTypes() {
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            this.cache.cleanAnnotations();
            List<AnnotationDefinition> ds = this.n.getAllAnnotations();
            for (AnnotationDefinition d : ds) {
                CDIAnnotationElement s;
                if ((d.getKind() & 8) > 0) {
                    s = new StereotypeElement();
                    this.initAnnotationElement(s, d);
                    this.cache.add((StereotypeElement)s);
                }
                if ((d.getKind() & 0x10) > 0) {
                    s = new InterceptorBindingElement();
                    this.initAnnotationElement(s, d);
                    this.cache.add((InterceptorBindingElement)s);
                }
                if ((d.getKind() & 4) > 0) {
                    s = new QualifierElement();
                    this.initAnnotationElement(s, d);
                    this.cache.add((QualifierElement)s);
                }
                if ((d.getKind() & 0x20) <= 0) continue;
                s = new ScopeElement();
                this.initAnnotationElement(s, d);
                this.cache.add((ScopeElement)s);
            }
        }
    }

    private void initAnnotationElement(CDIAnnotationElement s, AnnotationDefinition d) {
        s.setDefinition(d);
        s.setParent(this);
        IPath r = d.getType().getPath();
        if (r != null) {
            s.setSourcePath(r);
        }
    }

    void rebuildBeans() {
        List<TypeDefinition> typeDefinitions = this.n.getAllTypeDefinitions();
        Set<String> vetoedTypes = this.n.getAllVetoedTypes();
        Collection<IExcluded> excluded = this.getEnabledExcluded();
        ArrayList<IBean> beans = new ArrayList<IBean>();
        HashSet<IType> newAllTypes = new HashSet<IType>();
        for (TypeDefinition d : typeDefinitions) {
            newAllTypes.add(d.getType());
        }
        HashMap<TypeDefinition, ClassBean> newDefinitionToClassbeans = new HashMap<TypeDefinition, ClassBean>();
        HashMap<IType, IClassBean> newClassBeans = new HashMap<IType, IClassBean>();
        int updateLevel = this.getUpdateLevel(newAllTypes);
        ImplementationCollector ic = new ImplementationCollector(typeDefinitions);
        for (TypeDefinition typeDefinition : typeDefinitions) {
            ClassBean bean = this.cache.definitionToClassbeans.get(typeDefinition);
            if (bean != null && bean.getDefinition() == typeDefinition && (updateLevel == 0 || updateLevel == 1 && typeDefinition.getType().isBinary())) {
                if (this.cleanClassCacheWhenRebuildBeans) {
                    bean.cleanCache();
                }
            } else {
                bean = typeDefinition.getInterceptorAnnotation() != null || ic.isInterceptor(typeDefinition.getType()) ? new InterceptorBean() : (typeDefinition.getDecoratorAnnotation() != null || ic.isDecorator(typeDefinition.getType()) ? new DecoratorBean() : (typeDefinition.getStatefulAnnotation() != null || typeDefinition.getStatelessAnnotation() != null || typeDefinition.getSingletonAnnotation() != null ? new SessionBean() : new ClassBean()));
                bean.setParent(this);
                bean.setDefinition(typeDefinition);
            }
            newDefinitionToClassbeans.put(typeDefinition, bean);
            String typeName = typeDefinition.getType().getFullyQualifiedName();
            boolean vetoed = typeDefinition.isVetoed();
            IPath isexcludedBy = null;
            if (!vetoed && (isexcludedBy = this.isExcludedBy(typeName, excluded)) != null) {
                this.getNature().getDefinitions().addDependency(isexcludedBy, typeDefinition.getType().getPath());
            }
            if (vetoed || isexcludedBy != null || vetoedTypes.contains(typeName) && this.getNature().getDefinitions().getTypeDefinition(typeName) == null && typeDefinition.getOriginalDefinition() == null) continue;
            if (typeDefinition.hasBeanConstructor()) {
                beans.add(bean);
                newClassBeans.put(typeDefinition.getType(), bean);
            } else {
                beans.add(bean);
            }
            for (IProducer producer : bean.getProducers()) {
                beans.add(producer);
            }
        }
        for (String builtin : BuiltInBeanFactory.BUILT_IN) {
            IType type = this.n.getType(builtin);
            if (type == null || !type.exists() || newClassBeans.containsKey(type)) continue;
            TypeDefinition t = new TypeDefinition();
            t.setType(type, this.n.getDefinitions(), TypeDefinition.FLAG_NO_ANNOTATIONS);
            t.setBeanConstructor(true);
            ClassBean bean = BuiltInBeanFactory.newClassBean(this, t);
            newClassBeans.put(t.getType(), bean);
            beans.add(bean);
        }
        for (IClassBean bean : newClassBeans.values()) {
            ParametedType s = ((ClassBean)bean).getSuperType();
            if (s == null || s.getType() == null) continue;
            IClassBean superClassBean = (IClassBean)newClassBeans.get(s.getType());
            if (!(bean instanceof ClassBean)) continue;
            ((ClassBean)bean).setSuperClassBean(superClassBean);
        }
        this.cache.clean();
        int beansByTypeSize = typeDefinitions.size() / 10;
        if (beansByTypeSize < 10) {
            beansByTypeSize = 10;
        }
        if (beansByTypeSize > 367) {
            beansByTypeSize = 367;
        }
        this.cache.setBeansByTypeSize(beansByTypeSize);
        this.cache.classBeans = newClassBeans;
        this.cache.definitionToClassbeans = newDefinitionToClassbeans;
        this.cache.allTypes = newAllTypes;
        for (IBean bean : beans) {
            this.addBean(bean);
        }
    }

    private IPath isExcludedBy(String typeName, Collection<IExcluded> excluded) {
        for (IExcluded e : excluded) {
            if (!e.isExcluded(typeName)) continue;
            return e.getSource();
        }
        return null;
    }

    private int getUpdateLevel(Set<IType> newAllTypes) {
        int result = 0;
        for (IType t : this.cache.getAllTypes()) {
            if (t.exists() && newAllTypes.contains(t)) continue;
            if (t.isBinary()) {
                return 2;
            }
            result = 1;
        }
        for (IType t : newAllTypes) {
            if (this.cache.containsType(t)) continue;
            if (t.isBinary()) {
                return 2;
            }
            result = 1;
        }
        return result;
    }

    public void addBean(IBean bean) {
        if (((CDIElement)((Object)bean)).getDeclaringProject() != this && this.getNature().getClassPath().hasPath(bean.getSourcePath())) {
            return;
        }
        this.cache.addBean(bean, bean.getDeclaringProject() == this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildXML() {
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            this.allBeansXMLData.clean();
            this.projectBeansXMLData.clean();
            Set<BeansXMLDefinition> beanXMLs = this.n.getAllBeanXMLDefinitions();
            for (BeansXMLDefinition b : beanXMLs) {
                IPath p = b.getPath();
                boolean t = !p.lastSegment().endsWith(".jar") && p.segment(0).equals(this.getNature().getProject().getName());
                for (INodeReference r : b.getInterceptors()) {
                    this.allBeansXMLData.addInterceptor(r);
                    if (!t) continue;
                    this.projectBeansXMLData.addInterceptor(r);
                }
                for (INodeReference r : b.getDecorators()) {
                    this.allBeansXMLData.addDecorator(r);
                    if (!t) continue;
                    this.projectBeansXMLData.addDecorator(r);
                }
                for (INodeReference r : b.getStereotypeAlternatives()) {
                    this.allBeansXMLData.addStereotypeAlternative(r);
                    if (!t) continue;
                    this.projectBeansXMLData.addStereotypeAlternative(r);
                }
                for (INodeReference r : b.getTypeAlternatives()) {
                    this.allBeansXMLData.addTypeAlternative(r);
                    if (!t) continue;
                    this.projectBeansXMLData.addTypeAlternative(r);
                }
                this.allBeansXMLData.addExcluded(b.getExcluded());
                if (!t) continue;
                this.projectBeansXMLData.addExcluded(b.getExcluded());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IExcluded> getEnabledExcluded() {
        ArrayList<IExcluded> result = new ArrayList<IExcluded>();
        BeansXMLData beansXMLData = this.allBeansXMLData;
        synchronized (beansXMLData) {
            Collection<Excluded> excluded = this.allBeansXMLData.getExcluded();
            for (Excluded e : excluded) {
                if (!e.isEnabled(this)) continue;
                result.add(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IBean> getNamedBeans(boolean attemptToResolveAmbiguousNames) {
        HashSet<IBean> result = new HashSet<IBean>();
        CDICache cDICache = this.cache;
        synchronized (cDICache) {
            if (attemptToResolveAmbiguousNames) {
                HashSet<String> names = new HashSet<String>();
                for (IBean bean : this.cache.getNamedBeans()) {
                    if (names.contains(bean.getName())) continue;
                    Collection<IBean> beans = this.getBeans(bean.getName(), attemptToResolveAmbiguousNames);
                    if (beans.isEmpty()) {
                        result.add(bean);
                        continue;
                    }
                    result.addAll(beans);
                    names.add(bean.getName());
                }
            } else {
                result.addAll(this.cache.getNamedBeans());
            }
        }
        return result;
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IParametedType beanType, IType ... qualifiers) {
        HashSet<IBean> result = new HashSet<IBean>();
        IParametedType type = beanType;
        IBean[] iBeanArray = this.cache.getBeansByLegalType(type);
        int n = iBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBean b = iBeanArray[n2];
            if (CDIProject.containsType(b.getLegalTypes(), type)) {
                try {
                    Collection<IQualifierDeclaration> qsb = b.getQualifierDeclarations(true);
                    if (CDIProject.areMatchingQualifiers(qsb, qualifiers)) {
                        result.add(b);
                    }
                }
                catch (CoreException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
            ++n2;
        }
        return this.getResolvedBeans(result, attemptToResolveAmbiguousDependency);
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, String fullyQualifiedBeanType, String ... fullyQualifiedQualifiersTypes) {
        IType type = this.getNature().getType(fullyQualifiedBeanType);
        ParametedType beanType = this.getNature().getTypeFactory().newParametedType(type);
        ArrayList<IType> qualifiers = new ArrayList<IType>();
        if (fullyQualifiedQualifiersTypes != null) {
            String[] stringArray = fullyQualifiedQualifiersTypes;
            int n = fullyQualifiedQualifiersTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                type = this.getNature().getType(s);
                if (type != null) {
                    qualifiers.add(type);
                }
                ++n2;
            }
        }
        return this.getBeans(attemptToResolveAmbiguousDependency, (IParametedType)beanType, qualifiers.toArray(new IType[0]));
    }

    public Set<IInjectionPoint> getInjections(String fullyQualifiedTypeName) {
        return this.cache.getInjections(fullyQualifiedTypeName);
    }

    public Set<IPath> replaceBeanXML(Set<IPath> paths) {
        this.getNature().getDefinitions().newWorkingCopy(false);
        DefinitionContext context = this.getNature().getDefinitions().getWorkingCopy();
        Set<BeansXMLDefinition> beanXMLs = context.getBeansXMLDefinitions();
        HashSet<IPath> old = new HashSet<IPath>();
        for (BeansXMLDefinition d : beanXMLs) {
            IPath p = d.getPath();
            if (p == null || !"beans.xml".equals(p.lastSegment())) continue;
            old.add(p);
        }
        for (IPath p : old) {
            context.clean(p);
        }
        for (IPath path : paths) {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (f == null || !f.exists()) continue;
            XModelObject beansXML = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (beansXML == null) {
                beansXML = EclipseResourceUtil.createObjectForResource((IResource)f);
            }
            if (beansXML == null) continue;
            BeansXMLDefinition def = new BeansXMLDefinition();
            def.setPath(f.getFullPath());
            def.setBeansXML(beansXML);
            context.addBeanXML(f.getFullPath(), def);
        }
        context.applyWorkingCopy();
        return old;
    }

    @Override
    public String getElementName() {
        return this.getNature().getProject().getName();
    }
}

