/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanMember;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointParameter;
import org.jboss.tools.cdi.internal.core.impl.Parameter;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;

public class BeanMethod
extends BeanMember
implements IBeanMethod {
    protected IMethod method;
    protected AnnotationDeclaration inject;
    List<IParameter> parameters = new ArrayList<IParameter>();

    public void setDefinition(MethodDefinition definition) {
        super.setDefinition(definition);
        this.setMethod(definition.getMethod());
        this.inject = definition.getInjectAnnotation();
        List<ParameterDefinition> ps = definition.getParameters();
        for (ParameterDefinition p : ps) {
            Parameter parameter = this.newParameter(p);
            parameter.setBeanMethod(this);
            parameter.setDefinition(p);
            this.parameters.add(parameter);
        }
    }

    protected Parameter newParameter(ParameterDefinition p) {
        return ((MethodDefinition)this.definition).parametersAreInjectionPoints() ? new InjectionPointParameter() : new Parameter();
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    public void setMethod(IMethod method) {
        this.method = method;
        this.setMember((IJavaElement)method);
    }

    public IMember getSourceMember() {
        return this.getMethod();
    }

    @Override
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public MethodDefinition getDefinition() {
        return (MethodDefinition)this.definition;
    }

    @Override
    public boolean isDisposer() {
        for (IParameter p : this.parameters) {
            if (!p.isAnnotationPresent("javax.enterprise.inject.Disposes")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isObserver() {
        for (IParameter p : this.parameters) {
            if (!p.isAnnotationPresent("javax.enterprise.event.Observes")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLifeCycleCallbackMethod() {
        return this.definition.getAnnotation("javax.annotation.PreDestroy") != null || this.definition.getAnnotation("javax.annotation.PostConstruct") != null;
    }

    @Override
    public Collection<IInterceptorBinding> getInterceptorBindings() {
        return CDIUtil.getAllInterceptorBindings(this);
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.getClassBean().getBeanClass().getElementName()) + "." + this.getMethod().getElementName() + "()";
    }

    @Override
    public boolean isDeclaredFor(IJavaElement element) {
        if (this.getMethod() == element) {
            return true;
        }
        if (element instanceof IMethod) {
            IMethod other = (IMethod)element;
            return this.getMethod().getElementName().equals(other.getElementName()) && this.getMethod().getDeclaringType().getFullyQualifiedName().equals(other.getDeclaringType().getFullyQualifiedName()) && this.equalArrays(this.getMethod().getParameterTypes(), other.getParameterTypes());
        }
        return false;
    }

    private boolean equalArrays(String[] a1, String[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (!a1[i].equals(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

