/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.el;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.common.el.core.ca.DefaultJavaRelevanceCheck;

class BeanRelevanceCheck
extends DefaultJavaRelevanceCheck {
    Set<String> names = new HashSet<String>();

    public BeanRelevanceCheck(IJavaElement element) {
        super(element);
        IProject project = element.getJavaProject().getProject();
        ICDIProject cdi = CDICorePlugin.getCDIProject(project, true);
        if (cdi != null) {
            for (IBean b : cdi.getBeans(element)) {
                if (b.getName() == null) continue;
                this.names.add(b.getName());
            }
        }
    }

    public boolean isRelevant(String content) {
        if (super.isRelevant(content)) {
            return true;
        }
        for (String name : this.names) {
            if (!content.contains(name)) continue;
            return true;
        }
        return false;
    }
}

