/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenerationTime;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GeneratedAnnotation;

public class GeneratedAnnotationImpl
extends SourceAnnotation
implements GeneratedAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.Generated");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = GeneratedAnnotationImpl.buildValueAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private final AnnotationElementAdapter<String> valueAdapter = this.buildAdapter(VALUE_ADAPTER);
    private GenerationTime value;
    private CompilationUnit astRoot;

    protected GeneratedAnnotationImpl(JavaResourceModel parent, Attribute attribute) {
        super(parent, (AnnotatedElement)attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.value = this.buildValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncValue(this.buildValue(astRoot));
    }

    @Override
    public GenerationTime getValue() {
        return this.value;
    }

    @Override
    public void setValue(GenerationTime value) {
        if (ObjectTools.notEquals((Object)((Object)this.value), (Object)((Object)value))) {
            this.value = value;
            this.valueAdapter.setValue((Object)GenerationTime.toJavaAnnotationValue(value));
        }
    }

    private void syncValue(GenerationTime value) {
        GenerationTime old = this.value;
        this.value = value;
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private GenerationTime buildValue(CompilationUnit astRoot) {
        return GenerationTime.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange() {
        return this.getElementTextRange(VALUE_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Generated";
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return new EnumDeclarationAnnotationElementAdapter(adapter, "value");
    }

    public static class GeneratedAnnotationDefinition
    implements AnnotationDefinition {
        private static final GeneratedAnnotationDefinition INSTANCE = new GeneratedAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private GeneratedAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement attribute) {
            return new GeneratedAnnotationImpl((JavaResourceModel)parent, (Attribute)attribute);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.Generated";
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent) {
            throw new UnsupportedOperationException();
        }
    }
}

