/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpUtil {
    private static IProxyService proxyService;

    @Deprecated
    public static InputStream getInputStreamFromUrlByGetMethod(String url) throws IOException {
        return HttpUtil.getInputStreamFromUrlByGetMethod(url, false);
    }

    @Deprecated
    public static InputStream getInputStreamFromUrlByGetMethod(String url, boolean checkStatusCode) throws IOException {
        InputStream is = null;
        GetMethod method = HttpUtil.executeGetMethod(url);
        if (!checkStatusCode || method.getStatusCode() == 200) {
            is = method.getResponseBodyAsStream();
        }
        return is;
    }

    public static InputStreamReader getInputStreamReader(String httpUrl, int timeout) throws IOException {
        HttpURLConnection connection = HttpUtil.createHttpURLConnection(httpUrl, timeout);
        if (connection != null) {
            return HttpUtil.getInputStreamReader(connection);
        }
        return null;
    }

    public static InputStreamReader getInputStreamReader(HttpURLConnection connection) throws IOException {
        return HttpUtil.getInputStreamReader(connection, 0);
    }

    public static HttpURLConnection createHttpURLConnection(String urlString, int timeout) throws IOException {
        URL url = new URL(urlString);
        URLConnection connetion = url.openConnection();
        HttpURLConnection httpConnection = null;
        if (connetion instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setInstanceFollowRedirects(true);
            httpConnection.setRequestMethod("GET");
            httpConnection.setConnectTimeout(timeout);
        }
        return httpConnection;
    }

    private static InputStreamReader getInputStreamReader(HttpURLConnection connection, int redirectAttemptCount) throws IOException {
        String redirectLocation;
        InputStreamReader responseReader = null;
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            Matcher matcher;
            String contentTypeCharset = null;
            String contentType = connection.getContentType();
            if (contentType != null && (matcher = Pattern.compile("charset=(.+)").matcher(contentType)).find()) {
                contentTypeCharset = matcher.group(1);
            }
            InputStream inputStream = connection.getInputStream();
            responseReader = contentTypeCharset != null && contentTypeCharset.length() > 0 ? new InputStreamReader((InputStream)new BufferedInputStream(inputStream), contentTypeCharset) : new InputStreamReader(new BufferedInputStream(inputStream));
        } else if (responseCode >= 300 && responseCode < 400 && (redirectLocation = connection.getHeaderField("location")) != null && !connection.getURL().toString().equalsIgnoreCase(redirectLocation.trim()) && ++redirectAttemptCount > 1) {
            HttpURLConnection redirectConnection = HttpUtil.createHttpURLConnection(redirectLocation, connection.getConnectTimeout());
            redirectConnection.setIfModifiedSince(connection.getIfModifiedSince());
            return HttpUtil.getInputStreamReader(redirectConnection, redirectAttemptCount);
        }
        return responseReader;
    }

    public static InputStream getInputStreamFromUrlByGetMethod(String url, IProxyService proxyService) throws IOException {
        InputStream is = HttpUtil.executeGetMethod(url, proxyService).getResponseBodyAsStream();
        return is;
    }

    public static int getStatusCodeFromUrlByGetMethod(String url, IProxyService proxyService) throws IOException {
        int code = HttpUtil.executeGetMethod(url, proxyService).getStatusCode();
        return code;
    }

    public static int getStatusCodeFromUrlByGetMethod(String url) throws IOException {
        int code = HttpUtil.executeGetMethod(url).getStatusCode();
        return code;
    }

    public static InputStream getInputStreamFromUrlByPostMethod(String url) throws IOException {
        InputStream is = HttpUtil.executePostMethod(url).getResponseBodyAsStream();
        return is;
    }

    public static int getStatusCodeFromUrlByPostMethod(String url, IProxyService proxyService) throws IOException {
        int code = HttpUtil.executePostMethod(url, proxyService).getStatusCode();
        return code;
    }

    public static int getStatusCodeFromUrlByPostMethod(String url) throws IOException {
        int code = HttpUtil.executePostMethod(url).getStatusCode();
        return code;
    }

    private static GetMethod executeGetMethod(String url) throws IOException {
        IProxyService proxyService = HttpUtil.getProxyService();
        return HttpUtil.executeGetMethod(url, proxyService);
    }

    private static PostMethod executePostMethod(String url) throws IOException {
        IProxyService proxyService = HttpUtil.getProxyService();
        return HttpUtil.executePostMethod(url, proxyService);
    }

    public static GetMethod executeGetMethod(String url, IProxyService proxyService) throws IOException {
        GetMethod httpGet = new GetMethod(url);
        HttpClient httpClient = HttpUtil.createHttpClient(url, proxyService);
        httpClient.executeMethod((HttpMethod)httpGet);
        return httpGet;
    }

    private static PostMethod executePostMethod(String url, IProxyService proxyService) throws IOException {
        PostMethod httpPost = new PostMethod(url);
        HttpClient httpClient = HttpUtil.createHttpClient(url, proxyService);
        httpClient.executeMethod((HttpMethod)httpPost);
        return httpPost;
    }

    public static HttpClient createHttpClient(String url) throws IOException {
        return HttpUtil.createHttpClient(url, HttpUtil.getProxyService());
    }

    public static HttpClient createHttpClient(String url, int connectionTimeout) throws IOException {
        return HttpUtil.createHttpClient(url, HttpUtil.getProxyService(), connectionTimeout);
    }

    private static HttpClient createHttpClient(String url, IProxyService proxyService) throws IOException {
        return HttpUtil.createHttpClient(url, proxyService, 30000);
    }

    private static HttpClient createHttpClient(String url, IProxyService proxyService, int connectionTimeout) throws IOException {
        HttpClient httpClient = new HttpClient();
        if (proxyService.isProxiesEnabled()) {
            IProxyData[] proxyData = proxyService.getProxyData();
            URL netUrl = new URL(url);
            String hostName = netUrl.getHost();
            String[] nonProxiedHosts = proxyService.getNonProxiedHosts();
            boolean nonProxiedHost = false;
            int i = 0;
            while (i < nonProxiedHosts.length) {
                String nonProxiedHostName = nonProxiedHosts[i];
                if (nonProxiedHostName.equalsIgnoreCase(hostName)) {
                    nonProxiedHost = true;
                    break;
                }
                ++i;
            }
            if (!nonProxiedHost) {
                i = 0;
                while (i < proxyData.length) {
                    IProxyData proxy = proxyData[i];
                    if ("HTTP".equals(proxy.getType())) {
                        String userName;
                        String proxyHostName = proxy.getHost();
                        if (proxyHostName == null) break;
                        int portNumber = proxy.getPort();
                        if (portNumber == -1) {
                            portNumber = 80;
                        }
                        httpClient.getHostConfiguration().setProxy(proxyHostName, portNumber);
                        if (!proxy.isRequiresAuthentication() || (userName = proxy.getUserId()) == null) break;
                        String password = proxy.getPassword();
                        httpClient.getState().setProxyCredentials(new AuthScope(null, -1, null, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(userName, password));
                        break;
                    }
                    ++i;
                }
            }
        }
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        return httpClient;
    }

    private static IProxyService getProxyService() {
        if (proxyService == null) {
            BundleContext bundleContext = CommonCorePlugin.getInstance().getBundle().getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(IProxyService.class.getName());
            proxyService = (IProxyService)bundleContext.getService(serviceReference);
        }
        return proxyService;
    }
}

