/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.java.TypeDeclaration;

public class ParametedType
implements IParametedType {
    protected ParametedTypeFactory typeFactory = null;
    protected IType type;
    protected int arrayIndex = 0;
    protected String signature;
    protected List<ParametedType> parameterTypes = new ArrayList<ParametedType>(1);
    protected boolean primitive;
    protected boolean isUpper = false;
    protected boolean isLower = false;
    protected boolean isVariable = false;
    boolean inheritanceIsBuilt = false;
    protected ParametedType superType = null;
    protected Collection<IParametedType> inheritedTypes = new ArrayList<IParametedType>(1);
    Set<IParametedType> allInheritedTypes = null;
    protected long inheritanceHashcode = -1L;
    PositionProvider provider = null;
    static String[] PREFIXES = new String[4];
    Map<String, String> signaturesByName = null;
    Map<String, ParametedType> parametersBySignature = null;
    static Map<String, String> primitives;

    static {
        ParametedType.PREFIXES[0] = "";
        int i = 1;
        while (i < PREFIXES.length) {
            ParametedType.PREFIXES[i] = String.valueOf(PREFIXES[i - 1]) + '[';
            ++i;
        }
        primitives = new HashMap<String, String>();
        primitives.put("Integer", "int");
        primitives.put("Short", "short");
        primitives.put("Long", "long");
        primitives.put("Character", "char");
        primitives.put("Float", "float");
        primitives.put("Double", "double");
        primitives.put("Boolean", "boolean");
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public boolean isUpper() {
        return this.isUpper;
    }

    public void setUpper(boolean b) {
        this.isUpper = b;
    }

    public boolean isLower() {
        return this.isLower;
    }

    public void setLower(boolean b) {
        this.isLower = b;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public void setVariable(boolean b) {
        this.isVariable = b;
    }

    public ParametedTypeFactory getFactory() {
        return this.typeFactory;
    }

    public void setFactory(ParametedTypeFactory typefactory) {
        this.typeFactory = typefactory;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public String getArrayPrefix() {
        return ParametedType.toArrayPrefix(this.arrayIndex);
    }

    private static String toArrayPrefix(int arrayIndex) {
        return arrayIndex < PREFIXES.length ? PREFIXES[arrayIndex] : String.valueOf(PREFIXES[3]) + ParametedType.toArrayPrefix(arrayIndex - 3);
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public void setSignature(String signature) {
        this.signature = signature;
        this.arrayIndex = 0;
        if (signature != null) {
            while (this.arrayIndex < signature.length() && signature.charAt(this.arrayIndex) == '[') {
                ++this.arrayIndex;
            }
        }
    }

    public void addParameter(ParametedType p) {
        this.parameterTypes.add(p);
    }

    @Override
    public List<? extends IParametedType> getParameters() {
        return this.parameterTypes;
    }

    public void setPositionProvider(PositionProvider p) {
        this.provider = p;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParametedType)) {
            return false;
        }
        ParametedType other = (ParametedType)object;
        if (this.signature != null && this.signature.equals(other.signature)) {
            return true;
        }
        if (this.type == null || other.type == null || !this.type.getFullyQualifiedName().equals(other.type.getFullyQualifiedName())) {
            return false;
        }
        if (this.parameterTypes.size() != other.parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.size()) {
            if (!this.parameterTypes.get(i).equals(other.parameterTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return this.arrayIndex == other.arrayIndex;
    }

    void buildInheritance() {
        if (this.type == null) {
            return;
        }
        this.inheritanceHashcode = 0L;
        ArrayList<IParametedType> inheritedTypes = new ArrayList<IParametedType>(2);
        try {
            String[] is;
            if (!this.type.isInterface() && !this.type.isAnnotation()) {
                String sc = this.type.getSuperclassTypeSignature();
                boolean objectArray = false;
                if (sc != null) {
                    sc = this.resolveParameters(sc);
                } else if (!"java.lang.Object".equals(this.type.getFullyQualifiedName())) {
                    sc = ParametedTypeFactory.OBJECT;
                } else if ("java.lang.Object".equals(this.type.getFullyQualifiedName()) && this.arrayIndex > 0) {
                    objectArray = true;
                    sc = ParametedTypeFactory.OBJECT;
                }
                if (!objectArray && this.arrayIndex > 0) {
                    sc = String.valueOf(this.getArrayPrefix()) + sc;
                }
                this.superType = this.getFactory().getParametedType((IMember)this.type, this, sc);
                if (this.superType != null) {
                    String scn;
                    this.inheritanceHashcode = this.superType.getType().getFullyQualifiedName().hashCode();
                    if (this.provider != null && (scn = this.type.getSuperclassName()) != null) {
                        if (this.provider.isLoaded() && this.provider.getRange(scn) != null) {
                            ISourceRange r = this.provider.getRange(scn);
                            this.superType = new TypeDeclaration(this.superType, this.type.getResource(), r.getOffset(), r.getLength());
                        } else if (!this.provider.isLoaded()) {
                            TypeDeclaration.Lazy lazy = new TypeDeclaration.Lazy(){

                                @Override
                                public void init(TypeDeclaration d) {
                                    ISourceRange r = ParametedType.this.provider.getRange(scn);
                                    if (r != null) {
                                        d.init(r.getOffset(), r.getLength());
                                    }
                                }
                            };
                            this.superType = new TypeDeclaration(this.superType, this.type.getResource(), lazy);
                        }
                    }
                    inheritedTypes.add(this.superType);
                }
            }
            if ((is = this.type.getSuperInterfaceTypeSignatures()) != null) {
                int i = 0;
                while (i < is.length) {
                    ParametedType t;
                    String p = this.resolveParameters(is[i]);
                    if (this.arrayIndex > 0) {
                        p = String.valueOf(this.getArrayPrefix()) + p;
                    }
                    if ((t = this.getFactory().getParametedType((IMember)this.type, this, p)) != null) {
                        String scn;
                        this.inheritanceHashcode = this.inheritanceHashcode * 773L + (long)t.getType().getFullyQualifiedName().hashCode();
                        if (this.provider != null && (scn = this.type.getSuperInterfaceNames()[i]) != null) {
                            if (this.provider.isLoaded() && this.provider.getRange(scn) != null) {
                                ISourceRange r = this.provider.getRange(scn);
                                t = new TypeDeclaration(t, this.type.getResource(), r.getOffset(), r.getLength());
                            } else if (!this.provider.isLoaded()) {
                                TypeDeclaration.Lazy lazy = new TypeDeclaration.Lazy(){

                                    @Override
                                    public void init(TypeDeclaration d) {
                                        ISourceRange r = ParametedType.this.provider.getRange(scn);
                                        if (r != null) {
                                            d.init(r.getOffset(), r.getLength());
                                        }
                                    }
                                };
                                t = new TypeDeclaration(t, this.type.getResource(), lazy);
                            }
                        }
                        inheritedTypes.add(t);
                    }
                    ++i;
                }
            }
            if (this.type.getCompilationUnit() != null) {
                IImportDeclaration[] iImportDeclarationArray = this.type.getCompilationUnit().getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IImportDeclaration d = iImportDeclarationArray[n2];
                    String n3 = d.getElementName();
                    this.inheritanceHashcode = this.inheritanceHashcode * 773L + (long)n3.hashCode();
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        this.inheritedTypes = inheritedTypes;
        this.inheritanceIsBuilt = true;
    }

    public ParametedType getSuperType() {
        if (!this.inheritanceIsBuilt) {
            this.buildInheritance();
        }
        return this.superType;
    }

    public Collection<IParametedType> getInheritedTypes() {
        if (!this.inheritanceIsBuilt) {
            this.buildInheritance();
        }
        return this.inheritedTypes;
    }

    public String resolveParameters(String typeSignature) {
        String[] ps;
        if (typeSignature == null) {
            return typeSignature;
        }
        int i = typeSignature.indexOf(60);
        if (i < 0) {
            char e;
            char c = typeSignature.length() == 0 ? (char)'\u0000' : typeSignature.charAt(0);
            char c2 = e = typeSignature.length() == 0 ? (char)'\u0000' : typeSignature.charAt(typeSignature.length() - 1);
            if ((c == 'T' || c == 'Q' || c == 'L') && e == ';') {
                String param = typeSignature.substring(1, typeSignature.length() - 1);
                String s = this.findParameterSignature(param);
                return s == null ? typeSignature : s;
            }
            return typeSignature;
        }
        int j = typeSignature.lastIndexOf(62);
        if (j < i) {
            return typeSignature;
        }
        boolean replaced = false;
        StringBuffer newParams = new StringBuffer();
        String[] stringArray = ps = Signature.getTypeArguments((String)typeSignature);
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String newParam = this.resolveParameters(param);
            if (!param.equals(newParam)) {
                replaced = true;
            }
            newParams.append(newParam);
            ++n2;
        }
        if (replaced) {
            typeSignature = String.valueOf(typeSignature.substring(0, i)) + '<' + newParams.toString() + '>' + ';';
        }
        return typeSignature;
    }

    public String findParameterSignature(String paramName) {
        this.buildParameters();
        return this.signaturesByName.get(paramName);
    }

    void buildParameters() {
        if (this.signaturesByName == null && this.type != null) {
            HashMap<String, String> sbn = new HashMap<String, String>();
            HashMap<String, ParametedType> pbs = new HashMap<String, ParametedType>();
            ITypeParameter[] ps = null;
            try {
                ps = this.type.getTypeParameters();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (ps != null) {
                int i = 0;
                while (i < ps.length) {
                    String paramName = ps[i].getElementName();
                    if (this.parameterTypes.size() > i) {
                        ParametedType p = this.parameterTypes.get(i);
                        sbn.put(paramName, p.getSignature());
                        pbs.put(p.getSignature(), p);
                    }
                    ++i;
                }
            }
            this.signaturesByName = sbn;
            this.parametersBySignature = pbs;
        }
    }

    public ParametedType findParameter(String signature) {
        this.buildParameters();
        return this.parametersBySignature.get(signature);
    }

    public Collection<IParametedType> getAllTypes() {
        if (this.allInheritedTypes == null) {
            this.allInheritedTypes = this.buildAllTypes(new HashSet<String>(), this, new HashSet<IParametedType>());
        }
        return this.allInheritedTypes;
    }

    Set<IParametedType> buildAllTypes(Set<String> processed, ParametedType p, Set<IParametedType> types) {
        String key;
        IType t = p.getType();
        if (t != null && !processed.contains(key = String.valueOf(p.getArrayPrefix()) + t.getFullyQualifiedName())) {
            processed.add(key);
            types.add(p);
            Collection<IParametedType> ts = p.getInheritedTypes();
            if (ts != null) {
                for (IParametedType pp : ts) {
                    this.buildAllTypes(processed, (ParametedType)pp, types);
                }
            }
        }
        return types;
    }

    public String toString() {
        return String.valueOf(this.signature) + ":" + super.toString();
    }

    public boolean isAssignableTo(ParametedType other, boolean checkInheritance) {
        return this.isAssignableTo(other, checkInheritance, new HashMap<String, IType>());
    }

    boolean isAssignableTo(ParametedType other, boolean checkInheritance, Map<String, IType> resolvedVars) {
        if (this.equals(other)) {
            return true;
        }
        if ("*".equals(other.getSignature())) {
            return true;
        }
        if (this.type == null) {
            return this.isVariable && other.isVariable && other.type == null;
        }
        if (other.isVariable && other.type == null) {
            if (this.type != null) {
                if (resolvedVars.get(other.getSignature()) != null) {
                    return resolvedVars.get(other.getSignature()) == this.type;
                }
                resolvedVars.put(other.getSignature(), this.type);
            }
            return true;
        }
        if (this.type.equals(other.type) && this.areTypeParametersAssignableTo(other, resolvedVars)) {
            return true;
        }
        if (checkInheritance) {
            for (IParametedType t : this.getInheritedTypes()) {
                if (!((ParametedType)t).isAssignableTo(other, false, resolvedVars)) continue;
                return true;
            }
        }
        return false;
    }

    boolean areTypeParametersAssignableTo(ParametedType other, Map<String, IType> resolvedVars) {
        if (other.parameterTypes.isEmpty()) {
            return true;
        }
        if (this.parameterTypes.isEmpty()) {
            for (ParametedType p2 : other.parameterTypes) {
                if ("*".equals(p2.getSignature()) || "Ljava.lang.Object;".equals(p2.getSignature()) || "+Ljava.lang.Object;".equals(p2.getSignature()) || p2.isVariable() && !p2.isLower() && !p2.isUpper()) continue;
                return false;
            }
            return true;
        }
        if (this.parameterTypes.size() != other.parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.size()) {
            ParametedType p1 = this.parameterTypes.get(i);
            ParametedType p2 = other.parameterTypes.get(i);
            if (p1.isLower() || p1.isUpper() && !p1.isVariable) {
                return false;
            }
            if (!(p1.isVariable() ? (p2.isVariable() ? p2.isAssignableTo(p1, true, resolvedVars) : (p2.isLower() ? p2.isAssignableTo(p1, true, resolvedVars) : (p2.isUpper() ? p2.isAssignableTo(p1, true, resolvedVars) || p1.isAssignableTo(p2, true, resolvedVars) : p2.isAssignableTo(p1, true, resolvedVars)))) : (p2.isLower() ? p2.isAssignableTo(p1, true, resolvedVars) : p1.isAssignableTo(p2, true, resolvedVars)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getSimpleName() {
        if (this.getSignature() != null) {
            if (this.isPrimitive()) {
                int array = this.arrayIndex;
                StringBuilder result = new StringBuilder(primitives.get(Signature.getSignatureSimpleName((String)this.getSignature().substring(array))));
                if (array > 0) {
                    int i = 0;
                    while (i < array) {
                        result.append("[]");
                        ++i;
                    }
                }
                return result.toString();
            }
            return Signature.getSignatureSimpleName((String)this.getSignature());
        }
        return "";
    }

    public long getInheritanceCode() {
        if (!this.inheritanceIsBuilt) {
            this.buildInheritance();
        }
        return this.inheritanceHashcode;
    }

    public static interface PositionProvider {
        public ISourceRange getRange(String var1);

        public boolean isLoaded();
    }
}

