/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportWizard;
import org.eclipse.ui.internal.wizards.datatransfer.Messages;

public class OpenFolderCommand
extends AbstractHandler {
    private Shell shell;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String res;
        File selectedFile;
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        DirectoryDialog directoryDialog = new DirectoryDialog(this.shell);
        directoryDialog.setText(Messages.selectFolderToImport);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        directoryDialog.setFilterPath(workspaceRoot.getLocation().toFile().toString());
        ISelection sel = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
        IStructuredSelection structuredSel = null;
        if (sel != null && sel instanceof IStructuredSelection && !(structuredSel = (IStructuredSelection)sel).isEmpty() && (selectedFile = EasymportWizard.toFile(structuredSel.getFirstElement())) != null) {
            directoryDialog.setFilterPath(selectedFile.getAbsolutePath());
        }
        if ((res = directoryDialog.open()) == null) {
            return null;
        }
        EasymportWizard wizard = new EasymportWizard();
        File directory = new File(res);
        wizard.setInitialDirectory(directory);
        Path asPath = new Path(directory.getAbsolutePath());
        IProject parentProject = null;
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().isPrefixOf((IPath)asPath) && (parentProject == null || parentProject.getLocation().isPrefixOf(project.getLocation()))) {
                parentProject = project;
            }
            ++n2;
        }
        HashSet<IWorkingSet> initialWorkingSets = new HashSet<IWorkingSet>();
        if (parentProject != null) {
            IWorkingSet[] iWorkingSetArray = workbench.getWorkingSetManager().getAllWorkingSets();
            int n3 = iWorkingSetArray.length;
            n = 0;
            while (n < n3) {
                IWorkingSet workingSet = iWorkingSetArray[n];
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n4 = iAdaptableArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IAdaptable element = iAdaptableArray[n5];
                    if (element.equals(parentProject)) {
                        initialWorkingSets.add(workingSet);
                    }
                    ++n5;
                }
                ++n;
            }
        }
        if (initialWorkingSets.isEmpty()) {
            wizard.init(workbench, structuredSel);
        } else {
            wizard.setInitialWorkingSets(initialWorkingSets);
        }
        return new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard).open();
    }
}

