/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.CouldNotImportProjectException;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseProjectConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseWorkspaceConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.Messages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.RecursiveImportListener;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class EasymportJob
extends Job {
    private File rootDirectory;
    private boolean discardRootProject;
    private boolean deepChildrenDetection;
    private boolean configureProjects;
    private boolean reconfigureEclipseProjects;
    private IWorkingSet[] workingSets;
    private IProject rootProject;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private ProjectConfiguratorExtensionManager configurationManager;
    private RecursiveImportListener listener;
    private Map<IProject, List<ProjectConfigurator>> report;
    private boolean isRootANewProject;
    private Map<IPath, Exception> errors;
    private JobGroup crawlerJobGroup;

    public EasymportJob(File rootDirectory, Set<IWorkingSet> workingSets, boolean configureProjects, boolean recuriveChildrenDetection) {
        super(rootDirectory.getAbsolutePath());
        this.rootDirectory = rootDirectory;
        this.workingSets = workingSets != null ? workingSets.toArray(new IWorkingSet[workingSets.size()]) : new IWorkingSet[0];
        this.configureProjects = configureProjects;
        this.deepChildrenDetection = recuriveChildrenDetection;
        this.report = new HashMap<IProject, List<ProjectConfigurator>>();
        this.crawlerJobGroup = new JobGroup("Detecting and configurating nested projects", 0, 1);
        this.errors = new HashMap<IPath, Exception>();
    }

    @Deprecated
    public EasymportJob(File rootDirectory, Set<IWorkingSet> workingSets, boolean configureAndDetectNestedProject) {
        this(rootDirectory, workingSets, configureAndDetectNestedProject, configureAndDetectNestedProject);
    }

    public void setListener(RecursiveImportListener listener) {
        this.listener = listener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.isRootANewProject = !new File(this.rootDirectory, ".project").isFile();
            this.rootProject = this.toExistingOrNewProject(this.rootDirectory, monitor, 0);
            if (this.configureProjects) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceDescription description = workspace.getDescription();
                boolean isAutoBuilding = workspace.isAutoBuilding();
                if (isAutoBuilding) {
                    description.setAutoBuilding(false);
                    workspace.setDescription(description);
                }
                this.importProjectAndChildrenRecursively((IContainer)this.rootProject, this.deepChildrenDetection, true, monitor);
                if (isAutoBuilding) {
                    description.setAutoBuilding(true);
                    workspace.setDescription(description);
                }
                if (this.rootProjectWorthBeingRemoved()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            EasymportJob.this.discardRootProject = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.discardRootProject_title, (String)Messages.discardRootProject_description);
                        }
                    });
                    if (this.discardRootProject) {
                        this.rootProject.delete(false, true, monitor);
                        this.report.remove(this.rootProject);
                    }
                }
            }
        }
        catch (Exception ex) {
            return new Status(4, "org.eclipse.e4.ui.importer", ex.getMessage(), (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    protected boolean rootProjectWorthBeingRemoved() {
        if (this.isRootANewProject) {
            return false;
        }
        if (this.report.size() == 1) {
            return false;
        }
        List<ProjectConfigurator> rootProjectConfigurators = this.report.get(this.rootProject);
        if (rootProjectConfigurators.isEmpty()) {
            return true;
        }
        boolean areOnlyDummyConfigurators = true;
        for (ProjectConfigurator configurator : rootProjectConfigurators) {
            areOnlyDummyConfigurators &= configurator instanceof EclipseProjectConfigurator || configurator instanceof EclipseWorkspaceConfigurator;
        }
        return areOnlyDummyConfigurators;
    }

    private Set<IProject> searchAndImportChildrenProjectsRecursively(IContainer parentContainer, Set<IPath> directoriesToExclude, IProgressMonitor progressMonitor) throws Exception {
        parentContainer.refreshLocal(1, progressMonitor);
        HashSet<IFolder> childrenToProcess = new HashSet<IFolder>();
        Set<IProject> res = Collections.synchronizedSet(new HashSet());
        IResource[] iResourceArray = parentContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource childResource = iResourceArray[n2];
            if (childResource.getType() == 2 && !childResource.isDerived()) {
                boolean excluded = false;
                if (directoriesToExclude != null) {
                    for (IPath excludedPath : directoriesToExclude) {
                        if (!excludedPath.isPrefixOf(childResource.getLocation())) continue;
                        excluded = true;
                    }
                }
                if (!excluded) {
                    childrenToProcess.add((IFolder)childResource);
                }
            }
            ++n2;
        }
        HashSet<CrawlFolderJob> jobs = new HashSet<CrawlFolderJob>();
        for (IFolder childFolder : childrenToProcess) {
            CrawlFolderJob crawlerJob = new CrawlFolderJob("Crawling " + childFolder.getLocation().toString(), childFolder, res);
            if (this.crawlerJobGroup.getMaxThreads() == 0 || this.crawlerJobGroup.getActiveJobs().size() < this.crawlerJobGroup.getMaxThreads()) {
                crawlerJob.setJobGroup(this.crawlerJobGroup);
                jobs.add(crawlerJob);
                crawlerJob.schedule();
                continue;
            }
            crawlerJob.run(progressMonitor);
        }
        for (CrawlFolderJob job : jobs) {
            job.join();
        }
        return res;
    }

    private Set<IProject> importProjectAndChildrenRecursively(IContainer container, boolean deepDetectChildren, boolean isRootProject, IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor.isCanceled()) {
            return null;
        }
        progressMonitor.setTaskName("Inspecting " + container.getLocation().toFile().getAbsolutePath());
        HashSet<IProject> projectFromCurrentContainer = new HashSet<IProject>();
        EclipseProjectConfigurator eclipseProjectConfigurator = new EclipseProjectConfigurator();
        boolean isAlreadyAnEclipseProject = false;
        HashSet<ProjectConfigurator> mainProjectConfigurators = new HashSet<ProjectConfigurator>();
        HashSet<IPath> excludedPaths = new HashSet<IPath>();
        IProject project = null;
        container.refreshLocal(2, progressMonitor);
        if (eclipseProjectConfigurator.shouldBeAnEclipseProject(container, progressMonitor) && (container != this.rootProject || !this.isRootANewProject)) {
            isAlreadyAnEclipseProject = true;
        }
        if (this.configurationManager == null) {
            this.configurationManager = new ProjectConfiguratorExtensionManager();
        }
        Collection<ProjectConfigurator> activeConfigurators = this.configurationManager.getAllActiveProjectConfigurators(container);
        HashSet<ProjectConfigurator> potentialSecondaryConfigurators = new HashSet<ProjectConfigurator>();
        for (ProjectConfigurator configurator : activeConfigurators) {
            if (progressMonitor.isCanceled()) {
                return null;
            }
            if (configurator.shouldBeAnEclipseProject(container, progressMonitor)) {
                mainProjectConfigurators.add(configurator);
                if (project == null) {
                    try {
                        project = this.toExistingOrNewProject(container.getLocation().toFile(), progressMonitor, 128);
                    }
                    catch (CouldNotImportProjectException ex) {
                        this.errors.put(container.getLocation(), ex);
                        if (this.listener != null) {
                            this.listener.errorHappened(container.getLocation(), ex);
                        }
                        return projectFromCurrentContainer;
                    }
                    if (this.listener != null) {
                        this.listener.projectCreated(project);
                    }
                    projectFromCurrentContainer.add(project);
                }
            } else {
                potentialSecondaryConfigurators.add(configurator);
            }
            progressMonitor.worked(1);
        }
        if (!mainProjectConfigurators.isEmpty()) {
            project.refreshLocal(2, progressMonitor);
        }
        for (ProjectConfigurator configurator : mainProjectConfigurators) {
            if (configurator instanceof EclipseProjectConfigurator || !isAlreadyAnEclipseProject || this.reconfigureEclipseProjects) {
                configurator.configure(project, excludedPaths, progressMonitor);
                this.report.get(project).add(configurator);
                if (this.listener != null) {
                    this.listener.projectConfigured(project, configurator);
                }
            }
            excludedPaths.addAll(this.toPathSet(configurator.getDirectoriesToIgnore(project, progressMonitor)));
        }
        HashSet<IProject> allNestedProjects = new HashSet<IProject>();
        if (this.deepChildrenDetection) {
            allNestedProjects.addAll(this.searchAndImportChildrenProjectsRecursively(container, excludedPaths, progressMonitor));
            excludedPaths.addAll(this.toPathSet(allNestedProjects));
            projectFromCurrentContainer.addAll(allNestedProjects);
        }
        if (allNestedProjects.isEmpty() && isRootProject) {
            progressMonitor.beginTask("Configuring 'leaf' of project at " + container.getLocation().toFile().getAbsolutePath(), activeConfigurators.size());
            try {
                project = this.toExistingOrNewProject(container.getLocation().toFile(), progressMonitor, 128);
            }
            catch (CouldNotImportProjectException ex) {
                this.errors.put(container.getLocation(), ex);
                if (this.listener != null) {
                    this.listener.errorHappened(container.getLocation(), ex);
                }
                return projectFromCurrentContainer;
            }
            if (this.listener != null) {
                this.listener.projectCreated(project);
            }
            projectFromCurrentContainer.add(project);
        }
        if (!(project == null || isAlreadyAnEclipseProject && !this.reconfigureEclipseProjects || potentialSecondaryConfigurators.isEmpty())) {
            project.refreshLocal(1, progressMonitor);
            progressMonitor.beginTask("Continue configuration of project at " + container.getLocation().toFile().getAbsolutePath(), potentialSecondaryConfigurators.size());
            for (ProjectConfigurator additionalConfigurator : potentialSecondaryConfigurators) {
                if (additionalConfigurator.canConfigure(project, excludedPaths, progressMonitor)) {
                    additionalConfigurator.configure(project, excludedPaths, progressMonitor);
                    this.report.get(project).add(additionalConfigurator);
                    if (this.listener != null) {
                        this.listener.projectConfigured(project, additionalConfigurator);
                    }
                    excludedPaths.addAll(this.toPathSet(additionalConfigurator.getDirectoriesToIgnore(project, progressMonitor)));
                }
                progressMonitor.worked(1);
            }
        }
        return projectFromCurrentContainer;
    }

    private Set<IPath> toPathSet(Set<? extends IContainer> resources) {
        if (resources == null || resources.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IPath> res = new HashSet<IPath>();
        for (IContainer iContainer : resources) {
            res.add(iContainer.getLocation());
        }
        return res;
    }

    private IProject toExistingOrNewProject(File directory, IProgressMonitor progressMonitor, int refreshMode) throws CouldNotImportProjectException {
        IProject project;
        block5: {
            try {
                progressMonitor.setTaskName("Import project at " + directory.getAbsolutePath());
                project = this.projectAlreadyExistsInWorkspace(directory);
                if (project == null) {
                    project = this.createOrImportProject(directory, progressMonitor);
                }
                if (!progressMonitor.isCanceled()) break block5;
                return null;
            }
            catch (Exception ex) {
                throw new CouldNotImportProjectException(directory, ex);
            }
        }
        project.open(refreshMode, progressMonitor);
        if (!this.report.containsKey(project)) {
            this.report.put(project, new ArrayList());
        }
        return project;
    }

    private IProject projectAlreadyExistsInWorkspace(File directory) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().toFile().getAbsoluteFile().equals(directory.getAbsoluteFile())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private IProject createOrImportProject(File directory, IProgressMonitor progressMonitor) throws Exception {
        IProjectDescription desc = null;
        File expectedProjectDescriptionFile = new File(directory, ".project");
        if (expectedProjectDescriptionFile.exists()) {
            desc = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(expectedProjectDescriptionFile.getAbsolutePath()));
            String expectedName = desc.getName();
            IProject projectWithSameName = this.workspaceRoot.getProject(expectedName);
            if (projectWithSameName.exists() && projectWithSameName.getLocation().toFile().equals(directory)) {
                throw new Exception(NLS.bind((String)Messages.anotherProjectWithSameNameExists_description, (Object)expectedName));
            }
        } else {
            StringBuilder currentName = new StringBuilder(directory.getName());
            while (this.workspaceRoot.getProject(currentName.toString()).exists()) {
                currentName.append('_');
            }
            desc = ResourcesPlugin.getWorkspace().newProjectDescription(currentName.toString());
        }
        desc.setLocation((IPath)new Path(directory.getAbsolutePath()));
        IProject res = this.workspaceRoot.getProject(desc.getName());
        res.create(desc, progressMonitor);
        PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)res, this.workingSets);
        return res;
    }

    public IProject getRootProject() {
        return this.rootProject;
    }

    public Map<IProject, List<ProjectConfigurator>> getConfiguredProjects() {
        return this.report;
    }

    public Map<IPath, Exception> getErrors() {
        return this.errors;
    }

    private final class CrawlFolderJob
    extends Job {
        private final IFolder childFolder;
        private final Set<IProject> res;

        private CrawlFolderJob(String name, IFolder childFolder, Set<IProject> res) {
            super(name);
            this.childFolder = childFolder;
            this.res = res;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            try {
                Set projectFromCurrentContainer = EasymportJob.this.importProjectAndChildrenRecursively((IContainer)this.childFolder, true, false, progressMonitor);
                this.res.addAll(projectFromCurrentContainer);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.e4.ui.importer", ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

