/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordovasim.internal.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.jboss.tools.cordovasim.eclipse.launch.CordovaSimLaunchShortcut;
import org.jboss.tools.feedhenry.ui.FHPlugin;

public abstract class FHLaunchShortcut
extends CordovaSimLaunchShortcut {
    public abstract String getLaunchPrefix();

    protected abstract void setConfigAttributes(ILaunchConfigurationWorkingCopy var1, IProject var2);

    protected void launch(IProject project, String mode) {
        try {
            ILaunchConfigurationType cordovaSimLaunchConfiguraionType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.jboss.tools.cordovasim.eclipse.cordovaSimLaunchConfigurationType");
            ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(cordovaSimLaunchConfiguraionType);
            ILaunchConfiguration existingConfiguraion = this.chooseLaunchConfiguration(configurations, project);
            if (existingConfiguraion != null) {
                DebugUITools.launch((ILaunchConfiguration)existingConfiguraion, (String)mode);
            } else if (project != null) {
                ILaunchConfigurationWorkingCopy newConfiguration = this.createEmptyLaunchConfiguration(String.valueOf(project.getName()) + this.getLaunchPrefix());
                this.setConfigAttributes(newConfiguration, project);
                newConfiguration.doSave();
                DebugUITools.launch((ILaunchConfiguration)newConfiguration, (String)mode);
            }
        }
        catch (CoreException e) {
            FHPlugin.log(4, e.getMessage(), e);
        }
    }

    private ILaunchConfiguration chooseLaunchConfiguration(ILaunchConfiguration[] configurations, IProject project) {
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                String projectName = configuration.getAttribute(".PROJECT", null);
                String fh = configuration.getAttribute("org.jboss.tools.cordovasim.eclipse.FH", null);
                if (fh != null && fh.equals(this.getLaunchPrefix()) && projectName != null && projectName.equals(project.getName())) {
                    return configuration;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            FHPlugin.log(4, e.getMessage(), e);
        }
        return null;
    }
}

