/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.cordova.internal.preferences.FHPreferences;
import org.jboss.tools.feedhenry.ui.cordova.internal.wizards.FHProjectSelectionPage;
import org.jboss.tools.feedhenry.ui.internal.FHErrorHandler;
import org.jboss.tools.feedhenry.ui.internal.IntegrateFeedhenrySDKOperation;
import org.jboss.tools.feedhenry.ui.internal.util.GitUtil;
import org.jboss.tools.feedhenry.ui.model.FeedHenry;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryException;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public class NewApplicationWizard
extends Wizard
implements INewWizard {
    private static final String DIALOG_SETTINGS_KEY = "FeedHenryNewApplicationWizard";
    public static final String WIZARD_ID = "org.jboss.tools.feedhenry.ui.newApplication";
    private FHProjectSelectionPage page;
    private IStructuredSelection initialSelection;

    public NewApplicationWizard() {
        this.setWindowTitle("Create FeedHenry Application");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", "/icons/wizban/fh_wizban.png"));
        IDialogSettings wbSettings = FHPlugin.getDefault().getDialogSettings();
        IDialogSettings section = wbSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public void addPages() {
        super.addPages();
        this.page = new FHProjectSelectionPage(this.initialSelection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        HybridProject project = this.page.getHybridProject();
        final FeedHenryProject FHProject = this.page.getFeedHenryProject();
        final String applicationName = this.page.getApplicationName();
        final String remoteName = this.page.getRemoteName();
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)FHProject);
        Assert.isNotNull((Object)remoteName);
        Assert.isNotNull((Object)applicationName);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new IntegrateFeedhenrySDKOperation(project.getProject()));
            this.getContainer().run(false, true, (IRunnableWithProgress)new CreateRemoteApplicationTask(FHProject, project, remoteName, applicationName));
        }
        catch (Exception e) {
            FHErrorHandler.handle(e);
            return false;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] messages = new String[]{applicationName, FHProject.getTitle(), remoteName};
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)parent, (String)"Almost done!", (String)NLS.bind((String)"Application \"{0}\" for project \"{1}\" is created on the platform. Git repository is also configured to work with the platform. Please review and push the changes to the configured remote \"{2}\" to complete the integration.", (Object[])messages));
            }
        });
        return true;
    }

    private final class CreateRemoteApplicationTask
    implements IRunnableWithProgress {
        private final FeedHenryProject fHProject;
        private final HybridProject project;
        private final String remoteName;
        private final String applicationName;

        private CreateRemoteApplicationTask(FeedHenryProject fHProject, HybridProject project, String remoteName, String applicationName) {
            this.fHProject = fHProject;
            this.project = project;
            this.remoteName = remoteName;
            this.applicationName = applicationName;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            FeedHenry fh = new FeedHenry();
            FHPreferences prefs = FHPreferences.getPreferences();
            String feedHenryURL = prefs.getFeedHenryURL();
            if (feedHenryURL == null || feedHenryURL.isEmpty()) {
                CoreException ce = new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", 10, "FeedHenry URL preference is empty. Specify FeedHenry URL on preferences.", null));
                throw new InvocationTargetException(ce);
            }
            try {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Create FeedHenry Application {0} on {1}", (Object[])new String[]{this.applicationName, feedHenryURL}), (int)100);
                FeedHenryApplication fha = fh.setFeedHenryURL(new URL(feedHenryURL)).setAPIKey(prefs.getUserAPIKey()).importBareRepo(this.fHProject.getGuid(), this.applicationName, "client_advanced_hybrid", (IProgressMonitor)sm.newChild(50));
                Repository repository = GitUtil.getRepository(this.project.getProject());
                if (repository == null) {
                    sm.setTaskName("Create Git repository");
                    repository = GitUtil.share(this.project.getProject(), (IProgressMonitor)sm.newChild(50));
                }
                GitUtil.addRemoteConfig(this.remoteName, new URIish(fha.getRepoUrl()), repository);
                sm.done();
            }
            catch (IOException | URISyntaxException | CoreException | FeedHenryException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

