/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.feedhenry.ui.FHPlugin;

public class FeedHenryPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PAGE_DESCRIPTION = "FeedHendry connection preferences";
    private static final String LABEL_API_KEY = "API Key:";
    private static final String LABEL_TARGET_URL = "Target URL:";
    private static final String MESSAGE_TARGET_URL = "https://my.feedhenry.url";

    public FeedHenryPreferencesPage() {
        super(1);
        this.setDescription(PAGE_DESCRIPTION);
        this.setPreferenceStore(FHPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setFont(this.getControl().getFont());
        URLFieldEditor targetUrlField = new URLFieldEditor("fh_target_url", LABEL_TARGET_URL, parent);
        targetUrlField.setValidateStrategy(1);
        targetUrlField.setPreferenceStore(this.getPreferenceStore());
        targetUrlField.setPage((DialogPage)this);
        targetUrlField.load();
        targetUrlField.setPropertyChangeListener((IPropertyChangeListener)this);
        targetUrlField.getTextControl(parent).setMessage(MESSAGE_TARGET_URL);
        this.addField((FieldEditor)targetUrlField);
        StringFieldEditor apikeyField = new StringFieldEditor("fh_user_api_key", LABEL_API_KEY, parent);
        apikeyField.setPreferenceStore(this.getPreferenceStore());
        apikeyField.setPage((DialogPage)this);
        apikeyField.load();
        this.addField((FieldEditor)apikeyField);
    }

    private class URLFieldEditor
    extends StringFieldEditor {
        public URLFieldEditor(String property, String label, Composite parent) {
            super(property, label, parent);
        }

        protected boolean doCheckState() {
            String url = this.getStringValue();
            if (url != null && !url.isEmpty()) {
                try {
                    new URL(url);
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
            return true;
        }
    }
}

