/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.jboss.tools.feedhenry.ui.FHPlugin;

public class FHPreferences
implements IPropertyChangeListener {
    private static FHPreferences instance;
    private IPreferenceStore kernelStore;
    private String fhURL;
    private String userAPIKey;

    private FHPreferences(IPreferenceStore store) {
        this.kernelStore = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FHPreferences getPreferences() {
        Class<FHPreferences> clazz = FHPreferences.class;
        synchronized (FHPreferences.class) {
            if (instance == null) {
                IPreferenceStore prefs = FHPlugin.getDefault().getPreferenceStore();
                FHPreferences preferences = new FHPreferences(prefs);
                prefs.addPropertyChangeListener((IPropertyChangeListener)preferences);
                preferences.loadValues();
                instance = preferences;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadValues() {
        this.fhURL = this.kernelStore.getString("fh_target_url");
        this.userAPIKey = this.kernelStore.getString("fh_user_api_key");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("fh_user_api_key") || event.getProperty().equals("fh_target_url")) {
            this.loadValues();
        }
    }

    public String getFeedHenryURL() {
        return this.fhURL;
    }

    public String getUserAPIKey() {
        return this.userAPIKey;
    }
}

