/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.Refreshable;
import org.jboss.tools.jmx.ui.internal.JMXImages;
import org.jboss.tools.jmx.ui.internal.actions.RefreshActionState;

public class RefreshAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private StructuredViewer viewer;
    private String viewId;

    public RefreshAction() {
    }

    public RefreshAction(String viewId) {
        this.viewId = viewId;
        this.setText(Messages.RefreshAction_text);
        this.setDescription(Messages.RefreshAction_description);
        this.setToolTipText(Messages.RefreshAction_tooltip);
        JMXImages.setLocalImageDescriptors((IAction)this, "refresh.gif");
    }

    private void refreshObjectNode(Object onode) {
        if (onode == null) {
            return;
        }
        if (onode instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)onode;
            refreshable.refresh();
            this.refreshViewer(onode);
        } else {
            IConnectionWrapper wrapper = null;
            if (onode instanceof IConnectionWrapper) {
                wrapper = (IConnectionWrapper)onode;
            } else if (onode instanceof Node) {
                Root r = ((Node)onode).getRoot();
                IConnectionWrapper iConnectionWrapper = wrapper = r == null ? null : r.getConnection();
            }
            if (wrapper != null && wrapper.isConnected()) {
                ISelection sel = this.viewer.getSelection();
                TreePath[] paths = ((TreeViewer)this.viewer).getExpandedTreePaths();
                RefreshActionState.getDefault().setSelection(wrapper, sel);
                RefreshActionState.getDefault().setExpansion(wrapper, paths);
                try {
                    wrapper.disconnect();
                    wrapper.connect();
                    this.refreshViewer(wrapper);
                    if (this.viewer instanceof TreeViewer) {
                        TreeViewer treeViewer = (TreeViewer)this.viewer;
                        treeViewer.expandToLevel((Object)wrapper, 1);
                    }
                }
                catch (Exception ex) {
                    Status status = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.RefreshJobFailed, (Throwable)ex);
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)JMXCoreMessages.RefreshJob, null, (IStatus)status);
                }
            }
        }
    }

    public void run() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return;
        }
        IWorkbenchPage ap = aww.getActivePage();
        if (ap == null) {
            return;
        }
        ISelection sel = this.getSelection(ap);
        if (sel == null) {
            IConnectionWrapper[] connections = ExtensionManager.getAllConnections();
            if (connections.length > 0) {
                this.refreshObjectNode(connections[0]);
            }
        } else if (sel instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)sel;
            this.refreshObjectNode(treeSelection.getFirstElement());
        } else if (sel instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            this.refreshObjectNode(ss.getFirstElement());
        }
    }

    protected ISelection getSelection(IWorkbenchPage ap) {
        return ap.getSelection(this.viewId);
    }

    private void refreshViewer(Object node) {
        if (this.viewer != null) {
            this.viewer.refresh(node);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setViewer(StructuredViewer viewer) {
        this.viewer = viewer;
    }
}

